/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NonValidatingParser;
import oracle.xml.parser.v2.ValidatingParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLParser
implements XMLConstants {
    NonValidatingParser parser = new NonValidatingParser();
    boolean validating;
    static final String releaseVersion = "Oracle XML Parser\t2.0.2.9.0\tProduction";

    XMLParser() {
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public boolean getValidationMode() {
        return this.validating;
    }

    public final void parse(InputStream inputStream) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.xmlHandler, this.parser.entResolver, this.validating);
            this.parser.reader.pushXMLReader(inputStream, null, null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(Reader reader) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.xmlHandler, this.parser.entResolver, this.validating);
            this.parser.reader.pushXMLReader(reader, null, null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(String string) throws XMLParseException, SAXException, IOException {
        try {
            InputSource inputSource = new InputSource(string);
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.xmlHandler, this.parser.entResolver, this.validating);
            this.parser.reader.pushXMLReader(inputSource);
            this.parser.parseDocument();
        }
        finally {
            Object var3_3 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(URL uRL) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.xmlHandler, this.parser.entResolver, this.validating);
            this.parser.reader.pushXMLReader(uRL, uRL.toString(), null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(InputSource inputSource) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.xmlHandler, this.parser.entResolver, this.validating);
            this.parser.reader.pushXMLReader(inputSource);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public void reset() {
        this.parser.reset();
    }

    public void setBaseURL(URL uRL) {
        this.parser.baseURL = uRL;
    }

    public void setDoctype(DTD dTD) {
        this.parser.dtd = dTD;
        this.parser.fixedDTD = true;
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.err.setLocale(locale);
    }

    public void setPreserveWhitespace(boolean bl) {
        this.parser.preserveWS = bl;
    }

    public void setSchemaValidationMode(boolean bl) {
        this.parser.schemaValidationMode = bl;
    }

    public void setValidationMode(boolean bl) {
        if (bl != this.validating) {
            this.parser = bl ? new ValidatingParser(this.parser) : new NonValidatingParser(this.parser);
            this.validating = bl;
        }
    }

    public void setXMLSchema(Object object) {
        this.parser.setXMLSchema(object, true);
    }
}

