/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.FastVector;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNodeList;
import org.w3c.dom.Node;

public class XSLContext
implements XSLConstants {
    FastVector contexts;
    boolean globalContext = false;
    XSLContext currentContext;
    XSLNodeList currentNodeList;
    XMLNode currentNode;
    FastVector varNames;
    FastVector varNamespace;
    FastVector varValues;
    Hashtable globalVariables;

    public XSLContext() {
        this.varNames = new FastVector(16);
        this.varNamespace = new FastVector(16);
        this.varValues = new FastVector(16);
        this.contexts = new FastVector(16);
        this.globalVariables = new Hashtable(20);
    }

    XSLContext(XSLNodeList xSLNodeList) {
        this.currentNodeList = xSLNodeList;
    }

    public XMLNode getCurrentNode() {
        return this.currentContext.currentNode;
    }

    XSLNodeList getCurrentNodeList() {
        return this.currentContext.currentNodeList;
    }

    XSLExprValue getVariable(NSName nSName) {
        String string = nSName.getLocalName();
        String string2 = nSName.getNamespace();
        int n = this.varNames.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            if ((String)this.varNames.elementAt(n2) == string && (String)this.varNamespace.elementAt(n2) == string2) {
                return (XSLExprValue)this.varValues.elementAt(n2);
            }
            --n2;
        }
        return (XSLExprValue)this.globalVariables.get(nSName);
    }

    public void popCurrentNodeList() {
        int n = this.contexts.size();
        this.contexts.setSize(--n);
        this.currentContext = n != 0 ? (XSLContext)this.contexts.elementAt(n - 1) : null;
    }

    void popVariable(int n) {
        int n2 = this.varNames.size();
        this.varNames.setSize(n2 -= n);
        this.varNamespace.setSize(n2);
        this.varValues.setSize(n2);
    }

    public void pushCurrentNodeList(XSLNodeList xSLNodeList) {
        XSLContext xSLContext;
        this.currentContext = xSLContext = new XSLContext(xSLNodeList);
        this.contexts.addElement(xSLContext);
    }

    void pushVariable(NSName nSName, XSLExprValue xSLExprValue) {
        if (this.globalContext) {
            this.globalVariables.put(nSName, xSLExprValue);
            return;
        }
        this.varNames.addElement(nSName.getLocalName());
        this.varNamespace.addElement(nSName.getNamespace());
        this.varValues.addElement(xSLExprValue);
    }

    void reset() {
        this.contexts.setSize(0);
        this.varNames.setSize(0);
        this.varNamespace.setSize(0);
        this.varValues.setSize(0);
        this.globalContext = false;
    }

    public void setCurrentNode(Node node) {
        this.currentContext.currentNode = (XMLNode)node;
    }

    void setGlobalContext(boolean bl) {
        this.globalContext = bl;
    }
}

