/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLCopy
extends XSLNode
implements XSLConstants {
    XSLCopy(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet);
        this.elementType = 5;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        XMLNode xMLNode = xSLTContext.getCurrentNode();
        boolean bl = false;
        switch (xMLNode.getNodeType()) {
            case 2: {
                XMLAttr xMLAttr = (XMLAttr)xMLNode;
                if (xMLAttr.getPrefix() == "xmlns" || xMLAttr.getLocalName() == "xmlns") break;
                xSLEventHandler.attribute(xMLAttr.getPrefix(), xMLAttr.getLocalName(), xMLAttr.getNamespace(), xMLAttr.getNodeValue());
                break;
            }
            case 1: {
                Object object;
                Object object2;
                if (xMLNode.getParentNode() == null) {
                    this.processAttrSets(xSLTContext);
                    this.processChildren(xSLTContext);
                    break;
                }
                XMLElement xMLElement = (XMLElement)xMLNode;
                xSLEventHandler.startElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                String string = xMLElement.getAttribute("xml:space");
                bl = string.equals("") ^ true;
                if (bl) {
                    if (string.equals("preserve")) {
                        xSLTContext.setSrcWhiteSpaceMode(true);
                    } else if (string.equals("default")) {
                        xSLTContext.setSrcWhiteSpaceMode(false);
                    } else {
                        bl = false;
                        object2 = xMLElement.getAttributeNode("xml:space");
                        object = xSLTContext.getDebugNode();
                        xSLTContext.setDebugNode((XMLNode)object2);
                        xSLTContext.warning(xSLTContext.getError().getMessage2(1030, string, "xml:space"), 1030);
                        xSLTContext.setDebugNode((XMLNode)object);
                    }
                }
                this.processAttrSets(xSLTContext);
                if (xMLElement.defNamespace != null) {
                    xSLEventHandler.namespaceAttr("", xMLElement.defNamespace);
                }
                if ((object2 = xMLElement.getAllNamespaceAttrs()) != null) {
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        String string2 = (String)object.nextElement();
                        String string3 = (String)((Hashtable)object2).get(string2);
                        xSLEventHandler.namespaceAttr(string2, string3);
                    }
                }
                this.processChildren(xSLTContext);
                if (bl) {
                    xSLTContext.resetSrcWhiteSpaceMode();
                }
                xSLEventHandler.endElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                break;
            }
            case 3: {
                XMLText xMLText = (XMLText)xMLNode;
                if (xMLText.isWhiteSpaceNode()) {
                    if (!xSLTContext.isSrcWhiteSpacePreserving(xMLText.getParentNode().getNodeName())) break;
                    xSLEventHandler.characters(xMLText.getText(), false);
                    break;
                }
                xSLEventHandler.characters(xMLText.getText(), false);
                break;
            }
            case 7: {
                xSLEventHandler.processingInstruction(xMLNode.getNodeName(), xMLNode.getNodeValue());
                break;
            }
            case 8: {
                xSLEventHandler.comment(xMLNode.getNodeValue());
                break;
            }
        }
    }

    void processAttributes(XSLTContext xSLTContext) throws XSLException {
        super.processAttributes(xSLTContext);
        if (this.attrlist == null) {
            return;
        }
        int n = this.attrlist.getLength();
        XMLNode xMLNode = null;
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)this.attrlist.item(n2);
            if (xSLTContext.getDebugFlag()) {
                xMLNode = xSLTContext.getDebugNode();
                xSLTContext.setDebugNode(xMLAttr);
            }
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getNodeValue().intern();
            if (string == "use-attribute-sets") {
                this.processUseAttrSets(string2);
            } else if (string == "space" && xMLAttr.getNamespace() == "http://www.w3/org/XML/1998/namespace") {
                this.processSpaceAttr(string2);
            }
            if (xSLTContext.getDebugFlag()) {
                xSLTContext.setDebugNode(xMLNode);
            }
            ++n2;
        }
    }
}

