/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.DOMBuilder;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.async.ResourceManager;
import oracle.xml.async.XSLTransformer;
import oracle.xml.async.XSLTransformerErrorEvent;
import oracle.xml.async.XSLTransformerErrorListener;
import oracle.xml.async.XSLTransformerEvent;
import oracle.xml.async.XSLTransformerListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLStylesheet;

class oraxslDriver
implements DOMBuilderListener,
XSLTransformerListener,
DOMBuilderErrorListener,
XSLTransformerErrorListener {
    private boolean warnings = false;
    private OutputStream errors = System.err;
    private String xslinput;
    private String output;
    private boolean xmlpar = false;
    private Vector paramNames = new Vector();
    private Vector paramValues = new Vector();
    private boolean xmllist = false;
    private Vector xmlfiles = new Vector();
    private boolean xmldir = false;
    private String basedir = null;
    private boolean stylesheet = false;
    private boolean resultext = false;
    private int numXMLDocs = 1;
    private String extension;
    private int thrdNum = 1;
    private boolean serialize = false;
    private ResourceManager rm;
    private XMLDocument xsldoc = null;
    private URL xslURL = null;
    private boolean resdir = false;
    private String resultdir = null;
    private String omitExt = null;
    private String inclExt = null;
    private boolean matchExtension = false;
    private boolean debugFlag = false;
    private XMLDocument[] xmldocs;
    private DOMBuilder tparser;
    private XSLTransformer processor;
    private XSLStylesheet xsl;
    private static final String newline = System.getProperty("line.separator");
    private static boolean verbose = false;
    private static long startTime;
    private static long endTime;
    private static final String usageMessage;

    static {
        usageMessage = "usage: oraxsl options* source? stylesheet? result?" + newline + "            -w                          Show warnings" + newline + "            -e <error log>              A file to write errors to" + newline + "            -l <xml file list>          List of files to transform" + newline + "            -d <directory>              Directory with files to " + "transform" + newline + "            -x <source extension>       Extensions to exclude " + newline + "            -i <source extension>       Extensions to include " + newline + "            -s <stylesheet>             Stylesheet to use" + newline + "            -r <result extension>       Extension to use for results" + newline + "            -o <result directory>       Directory to place results" + newline + "            -p <param list>             List of Params " + newline + "            -t <# of threads>           Number of threads to use" + newline + "            -v                          Verbose mode" + newline + "            -debug                      Debug mode" + newline + "Please refer to the readme file for more information on the above options";
    }

    oraxslDriver() {
    }

    void compile() {
        this.showTask(String.valueOf(this.numXMLDocs) + " XML document" + (this.numXMLDocs > 1 ? "s" : "") + " will be transformed" + " using XSLT stylesheet specified in " + this.xslinput + " with " + this.thrdNum + " thread" + (this.thrdNum > 1 ? "s" : ""));
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(true);
            this.xslURL = this.createURL(this.xslinput);
            this.showTask("Parsing file " + this.xslinput);
            dOMParser.setErrorStream(this.errors);
            dOMParser.setDebugMode(this.debugFlag);
            dOMParser.parse(this.xslURL);
            this.xsldoc = dOMParser.getDocument();
        }
        catch (Exception exception) {
            this.exitWithError("Error occurred while parsing " + this.xslinput + ": " + exception.getMessage());
        }
        this.xmldocs = new XMLDocument[this.numXMLDocs];
        this.rm = new ResourceManager(this.thrdNum);
        int n = 0;
        while (n < this.numXMLDocs) {
            this.rm.getResource();
            try {
                this.tparser = new DOMBuilder(n);
                URL uRL = this.basedir == null ? this.createURL((String)this.xmlfiles.elementAt(n)) : this.createURL(String.valueOf(this.basedir) + "/" + (String)this.xmlfiles.elementAt(n));
                if (uRL == null) {
                    this.exitWithError("File " + (String)this.xmlfiles.elementAt(n) + " not found");
                }
                if (!this.serialize) {
                    this.tparser.setPreserveWhitespace(true);
                    if (this.basedir != null) {
                        URL uRL2 = this.createURL(String.valueOf(this.basedir) + "/");
                        this.tparser.setBaseURL(uRL2);
                    }
                    this.tparser.setDebugMode(this.debugFlag);
                    this.tparser.setErrorStream(this.errors);
                    this.tparser.addDOMBuilderListener(this);
                    this.tparser.addDOMBuilderErrorListener(this);
                    this.showTask("Parsing file " + this.xmlfiles.elementAt(n));
                    this.tparser.parse(uRL);
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error occurred while parsing " + (String)this.xmlfiles.elementAt(n) + ": " + exception.getMessage());
            }
            ++n;
        }
    }

    private URL createURL(String string) throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = String.valueOf('/') + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                this.exitWithError("Cannot create url for: " + string);
            }
        }
        return uRL;
    }

    public void domBuilderError(DOMBuilderEvent dOMBuilderEvent) {
    }

    public void domBuilderErrorCalled(DOMBuilderErrorEvent dOMBuilderErrorEvent) {
        int n = ((DOMBuilder)dOMBuilderErrorEvent.getSource()).getId();
        this.exitWithError("Error occurred while parsing " + this.xmlfiles.elementAt(n) + ": " + dOMBuilderErrorEvent.getException().getMessage());
    }

    public synchronized void domBuilderOver(DOMBuilderEvent dOMBuilderEvent) {
        DOMBuilder dOMBuilder = (DOMBuilder)dOMBuilderEvent.getSource();
        int n = dOMBuilder.getId();
        this.xmldocs[n] = dOMBuilder.getDocument();
        XSLTransformer xSLTransformer = new XSLTransformer(n);
        xSLTransformer.showWarnings(this.warnings);
        try {
            Object object;
            Object object2;
            xSLTransformer.setErrorStream(this.errors);
            xSLTransformer.addXSLTransformerListener(this);
            xSLTransformer.addXSLTransformerErrorListener(this);
            XSLStylesheet xSLStylesheet = new XSLStylesheet(this.xsldoc, this.xslURL);
            if (this.xmlpar) {
                object2 = this.paramNames.elements();
                object = this.paramValues.elements();
                while (object2.hasMoreElements()) {
                    xSLStylesheet.setParam((String)object2.nextElement(), (String)object.nextElement());
                }
            }
            this.showTask("Transforming XML document specified in " + this.xmlfiles.elementAt(n));
            object2 = null;
            try {
                if (this.output != null) {
                    object2 = new FileOutputStream(this.output);
                } else if (!this.resultext) {
                    object2 = System.out;
                } else {
                    File file;
                    if (!this.resdir) {
                        object = new File((String)this.xmlfiles.elementAt(n));
                        file = new File(String.valueOf(((File)object).getName()) + "." + this.extension);
                    } else {
                        object = new File(this.basedir, (String)this.xmlfiles.elementAt(n));
                        file = new File(this.resultdir, String.valueOf(((File)object).getName()) + "." + this.extension);
                    }
                    object2 = new FileOutputStream(file);
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error occurred while generating output : " + exception.getMessage());
            }
            xSLTransformer.processXSL(xSLStylesheet, this.xmldocs[n], (OutputStream)object2);
        }
        catch (Exception exception) {
            this.exitWithError("Error occurred while processing " + this.xslinput + ": " + exception.getMessage());
        }
    }

    public void domBuilderStarted(DOMBuilderEvent dOMBuilderEvent) {
    }

    private void exitWithError(String string) {
        PrintWriter printWriter = new PrintWriter(this.errors);
        printWriter.println(string);
        printWriter.flush();
        System.exit(1);
    }

    private boolean isFlag(String string) {
        return string.charAt(0) == '-';
    }

    private void printUsage(String string) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string2) + "oraxsl: " + string + newline + usageMessage;
            this.exitWithError(string2);
        } else {
            System.out.println(usageMessage);
        }
    }

    void processArgs(String[] stringArray) throws Exception {
        block83: {
            int n;
            int n2;
            block84: {
                String string;
                String[] stringArray2;
                block82: {
                    n2 = stringArray.length;
                    String string2 = null;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string3 = stringArray[n3];
                        if (string3.charAt(0) != '-') break;
                        switch (string3.charAt(1)) {
                            case 'h': {
                                this.printUsage(null);
                                System.exit(0);
                                break;
                            }
                            case 'v': {
                                verbose = true;
                                break;
                            }
                            case 't': {
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <# of threads> after -t");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <# of threads> after -t");
                                }
                                try {
                                    this.thrdNum = Integer.parseInt(string2);
                                    if (this.thrdNum > 0) break;
                                    this.printUsage("# of threads specified (" + this.thrdNum + ") is not positive");
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.printUsage(String.valueOf(string2) + " is not a valid number");
                                }
                                break;
                            }
                            case 'e': {
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <error log> after -e");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <error log> after -e");
                                }
                                try {
                                    this.errors = new FileOutputStream(string2);
                                }
                                catch (IOException iOException) {
                                    this.printUsage("The specified error log " + string2 + " could not be opened for writing: " + iOException.getMessage());
                                }
                                break;
                            }
                            case 'w': {
                                this.warnings = true;
                                break;
                            }
                            case 'd': {
                                if (string3.equals("-debug")) {
                                    this.debugFlag = true;
                                    break;
                                }
                                this.xmldir = true;
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <directory> after -d");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <directory> after -d");
                                }
                                this.basedir = string2;
                                break;
                            }
                            case 'l': {
                                this.xmllist = true;
                                if (string3.length() > 2) {
                                    this.xmlfiles.addElement(string3.substring(2));
                                }
                                while (++n3 < n2 && !this.isFlag(string3 = stringArray[n3])) {
                                    this.xmlfiles.addElement(string3);
                                }
                                if (this.xmlfiles.isEmpty()) {
                                    this.printUsage("Missing <xml file list> after -l");
                                }
                                --n3;
                                this.numXMLDocs = this.xmlfiles.size();
                                break;
                            }
                            case 'x': {
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <source extension> after -x");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <source extension> after -x");
                                }
                                this.omitExt = string2;
                                this.matchExtension = true;
                                break;
                            }
                            case 'i': {
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <source extension> after -i");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <source extension> after -i");
                                }
                                this.inclExt = string2;
                                this.matchExtension = true;
                                break;
                            }
                            case 's': {
                                this.stylesheet = true;
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <stylesheet> after -s");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <stylesheet> after -s");
                                }
                                this.xslinput = string2;
                                break;
                            }
                            case 'r': {
                                this.resultext = true;
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <result extension> after -r");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <result extension> after -r");
                                }
                                this.extension = string2;
                                break;
                            }
                            case 'o': {
                                this.resdir = true;
                                if (string3.length() > 2) {
                                    string2 = string3.substring(2);
                                    if (this.isFlag(string2)) {
                                        this.printUsage("Missing <directory> after -R");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string2 = stringArray[n3])) {
                                    this.printUsage("Missing <directory> after -R");
                                }
                                this.resultdir = string2;
                                break;
                            }
                            case 'p': {
                                this.xmlpar = true;
                                String string4 = null;
                                int n4 = -1;
                                if (string3.length() > 2) {
                                    string4 = string3.substring(2);
                                    if (this.isFlag(string4) || (n4 = string4.indexOf(61)) == -1) {
                                        this.printUsage("Missing <param list> after -p");
                                    }
                                } else if (++n3 >= n2 || this.isFlag(string4 = stringArray[n3]) || (n4 = string4.indexOf(61)) == -1) {
                                    this.printUsage("Missing <param list> after -p");
                                }
                                do {
                                    stringArray2 = string4.substring(0, n4);
                                    string = string4.substring(n4 + 1, string4.length());
                                    if (stringArray2.length() == 0 || string.length() == 0) {
                                        this.printUsage("'" + string4 + "'" + " is not a valid parameter definition");
                                    }
                                    this.paramNames.addElement(stringArray2);
                                    this.paramValues.addElement(string);
                                } while (++n3 < n2 && !this.isFlag(string4 = stringArray[n3]) && (n4 = string4.indexOf(61)) != -1);
                                --n3;
                                break;
                            }
                            default: {
                                this.printUsage("Unknown flag '-" + string3.charAt(1) + "'");
                            }
                        }
                        ++n3;
                    }
                    n = n2 - n3;
                    if (this.xmldir || this.xmllist || this.stylesheet || this.resultext) break block82;
                    if (n != 2 && n != 3) {
                        this.printUsage("Number of arguments specified (" + n2 + ")" + " is illegal");
                    }
                    this.xmlfiles.addElement(stringArray[n3]);
                    this.xslinput = stringArray[n3 + 1];
                    if (n2 > n3 + 2) {
                        this.output = stringArray[n3 + 2];
                    }
                    break block83;
                }
                if (!this.xmllist && !this.xmldir) {
                    this.printUsage("One of -l or -d options must be specified");
                } else if (!this.stylesheet) {
                    this.printUsage("-s option not specified");
                } else if (!this.resultext) {
                    this.printUsage("-r option not specified");
                } else if (this.matchExtension && (this.xmllist || !this.xmldir)) {
                    this.printUsage("-i or -o option can not be specified here");
                } else if (this.inclExt != null && this.omitExt != null) {
                    this.printUsage("both -i and -o options specified");
                }
                if (this.xmllist) break block84;
                File file = new File(this.basedir);
                if (!file.isDirectory()) {
                    this.printUsage(String.valueOf(this.basedir) + " is not a directory");
                }
                this.showTask("Processing files in directory " + this.basedir);
                stringArray2 = file.list();
                string = null;
                if (this.matchExtension) {
                    string = this.omitExt != null ? "." + this.omitExt : "." + this.inclExt;
                }
                boolean bl = false;
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    block86: {
                        String string5;
                        block85: {
                            string5 = stringArray2[n5];
                            if (!this.matchExtension) break block85;
                            bl = string5.endsWith(string);
                            if (this.omitExt != null && bl || this.inclExt != null && !bl) break block86;
                        }
                        this.xmlfiles.addElement(string5);
                    }
                    ++n5;
                }
                if (this.xmlfiles.isEmpty()) {
                    this.printUsage("No files in directory " + this.basedir + " were selected for processing");
                }
                this.numXMLDocs = this.xmlfiles.size();
            }
            if (n != 0) {
                this.printUsage("Number of arguments specified (" + n2 + ")" + " is illegal");
            }
        }
    }

    private void showTask(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    boolean stillActive() {
        return this.rm.activeFound();
    }

    public void xslTransformerError(XSLTransformerEvent xSLTransformerEvent) {
    }

    public void xslTransformerErrorCalled(XSLTransformerErrorEvent xSLTransformerErrorEvent) {
        int n = ((XSLTransformer)xSLTransformerErrorEvent.getSource()).getId();
        this.exitWithError("Error occurred while processing " + this.xmlfiles.elementAt(n) + ": " + xSLTransformerErrorEvent.getException().getMessage());
    }

    public void xslTransformerOver(XSLTransformerEvent xSLTransformerEvent) {
        this.rm.releaseResource();
    }

    public void xslTransformerStarted(XSLTransformerEvent xSLTransformerEvent) {
    }
}

