/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.sample.event;

import java.lang.reflect.Method;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;

public class PageEventDispatcher
implements JspScopeListener {
    private Object page;
    private String methodName;
    private Method method;

    public Object getPage() {
        return this.page;
    }

    public void setPage(Object page) {
        this.page = page;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String m) throws ClassNotFoundException, NoSuchMethodException {
        this.method = this.verifyMethod(m);
        this.methodName = m;
    }

    public void outOfScope(JspScopeEvent ae) {
        int scope = ae.getScope();
        if ((scope == 2 || scope == 1) && this.method != null) {
            try {
                Object[] args = new Object[]{ae.getApplication(), ae.getContainer()};
                this.method.invoke(this.page, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Method verifyMethod(String m) throws ClassNotFoundException, NoSuchMethodException {
        if (this.page == null) {
            throw new NoSuchMethodException("A page hasn't been set yet.");
        }
        Class<?> c = this.page.getClass();
        Class[] pTypes = new Class[]{Class.forName("javax.servlet.ServletContext"), Class.forName("javax.servlet.jsp.PageContext")};
        try {
            Method method = c.getDeclaredMethod(m, pTypes);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            pTypes[1] = Class.forName("javax.servlet.http.HttpServletRequest");
            return c.getDeclaredMethod(m, pTypes);
        }
    }
}

