/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import oracle.de.backend.runinformation.RIObjectPUDetails;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;

public class RIObjectPUDetailsList {
    Vector _RIPUDetailsList;
    OracleConnection _ConObject;
    OraclePreparedStatement _stmt;

    RIObjectPUDetailsList() {
        this._RIPUDetailsList = new Vector(0, 1);
        this._ConObject = null;
        this._stmt = null;
    }

    RIObjectPUDetailsList(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
        this._RIPUDetailsList = new Vector(0, 1);
        this._stmt = null;
    }

    public void setConObject(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
    }

    public OracleConnection getConObject() {
        return this._ConObject;
    }

    public boolean poppulate(int n, long l) {
        if (this._ConObject == null) {
            System.out.println("Cannot continue without Database connection.");
            return false;
        }
        try {
            String string;
            if (n > 0) {
                string = " select T1.UNIT_NAME as PUNAME, T1.UNIT_OWNER as PUOWNER, T1.UNIT_TYPE as PUTYPE, T2.LINE# as LINENUM, T2.TOTAL_OCCUR as TOT_OCCUR, T2.TOTAL_TIME as TOT_TIME, T2.MIN_TIME as MIN_TIME, T2.MAX_TIME as MAX_TIME from PLSQL_PROFILER_UNITS T1, PLSQL_PROFILER_DATA T2  where T1.RUNID = ? and T1.UNIT_NUMBER =  ?  and T2.RUNID = T1.RUNID and  T2.UNIT_NUMBER = T1.UNIT_NUMBER";
                this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string);
                this._stmt.setInt(1, n);
                this._stmt.setLong(2, l);
            } else {
                string = "select T1.UNIT_NAME as PUNAME, T1.UNIT_OWNER as PUOWNER, T1.UNIT_TYPE as PUTYPE,  T2.LINE# as LINENUM, sum(T2.TOTAL_OCCUR) as TOT_OCCUR, sum(T2.TOTAL_TIME) as TOT_TIME, min(T2.MIN_TIME) as MIN_TIME,  max(T2.MAX_TIME) as MAX_TIME  from PLSQL_PROFILER_UNITS T1, PLSQL_PROFILER_DATA T2  where  T1.UNIT_NUMBER =  ? and  T2.UNIT_NUMBER = T1.UNIT_NUMBER  group by T1.UNIT_TYPE, T1.UNIT_OWNER, T1.UNIT_NAME, T2.LINE#";
                this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string);
                this._stmt.setLong(1, l);
            }
            OracleResultSet oracleResultSet = (OracleResultSet)this._stmt.executeQuery();
            while (oracleResultSet.next()) {
                if (oracleResultSet.getLong("TOT_OCCUR") == 0L) continue;
                this.addPUDetails(new RIObjectPUDetails(n, l, oracleResultSet.getString("PUTYPE"), oracleResultSet.getString("PUOWNER"), oracleResultSet.getString("PUNAME"), oracleResultSet.getLong("LINENUM"), oracleResultSet.getLong("TOT_OCCUR"), oracleResultSet.getLong("TOT_TIME"), oracleResultSet.getLong("MIN_TIME"), oracleResultSet.getLong("MAX_TIME"), (double)(oracleResultSet.getLong("TOT_TIME") / oracleResultSet.getLong("TOT_OCCUR"))));
            }
            oracleResultSet.close();
            this._stmt.close();
            this._stmt = null;
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException thrown: " + sQLException.getMessage());
            return false;
        }
    }

    public boolean addPUDetails(RIObjectPUDetails rIObjectPUDetails) {
        this._RIPUDetailsList.addElement(rIObjectPUDetails);
        return true;
    }

    public RIObjectPUDetails getFirstPUDetails() {
        return (RIObjectPUDetails)this._RIPUDetailsList.firstElement();
    }

    public RIObjectPUDetails getPUDetails(int n) {
        if (this._RIPUDetailsList != null && n > -1 && n < this.getPUDetailsCount()) {
            return (RIObjectPUDetails)this._RIPUDetailsList.elementAt(n);
        }
        return null;
    }

    public int getPUDetailsCount() {
        return this._RIPUDetailsList.size();
    }

    public RIObjectPUDetails getPUDetailsByPUName(String string) {
        int n = 0;
        while (n < this.getPUDetailsCount()) {
            if (this.getPUDetails(n).getPUName() == string) {
                return this.getPUDetails(n);
            }
            ++n;
        }
        return null;
    }

    public boolean exportObjectPUDetailsList(FileWriter fileWriter) {
        String string = System.getProperties().getProperty("line.separator");
        try {
            int n = 0;
            while (n < this.getPUDetailsCount()) {
                fileWriter.write(string);
                if (!this.getPUDetails(n).exportObjectPUDetails(fileWriter)) {
                    return false;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not write to the file");
            return false;
        }
        return true;
    }

    protected void finalize() throws SQLException {
    }
}

