/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;
import oracle.de.backend.runinformation.RIDataSource;
import oracle.de.backend.runinformation.RIObjectPU;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;

public class RIObjectPUList {
    Vector _RIPUList;
    OracleConnection _ConObject;
    OraclePreparedStatement _stmt;

    RIObjectPUList() {
        this._RIPUList = new Vector(0, 1);
        this._ConObject = null;
    }

    RIObjectPUList(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
        this._RIPUList = new Vector(0, 1);
    }

    public void setConObject(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
    }

    public OracleConnection getConObject() {
        return this._ConObject;
    }

    public boolean poppulate(int n) {
        Calendar calendar = Calendar.getInstance();
        if (this._ConObject == null) {
            System.out.println("Cannot continue without Database connection.");
            return false;
        }
        try {
            String string;
            if (n > 0) {
                string = "Select UNIT_NUMBER, UNIT_TYPE, UNIT_OWNER, UNIT_NAME, to_char(UNIT_TIMESTAMP,'DD-MM-YYYY HH24:MI:SS'), TOTAL_TIME from PLSQL_PROFILER_UNITS where RUNID = ? and UNIT_TYPE != 'ANONYMOUS BLOCK'";
                this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string);
                this._stmt.setInt(1, n);
            } else {
                string = "Select UNIT_NUMBER, UNIT_TYPE, UNIT_OWNER, UNIT_NAME, to_char(UNIT_TIMESTAMP,'DD-MM-YYYY HH24:MI:SS'),  sum(TOTAL_TIME) from PLSQL_PROFILER_UNITS where UNIT_TYPE != 'ANONYMOUS BLOCK' group by UNIT_OWNER, UNIT_TYPE, UNIT_NUMBER, UNIT_NAME, UNIT_TIMESTAMP";
                this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string);
            }
            OracleResultSet oracleResultSet = (OracleResultSet)this._stmt.executeQuery();
            while (oracleResultSet.next()) {
                String string2 = oracleResultSet.getString(5);
                Integer n2 = Integer.valueOf(string2.substring(0, 2));
                Integer n3 = Integer.valueOf(string2.substring(4, 5));
                Integer n4 = Integer.valueOf(string2.substring(6, 10));
                Integer n5 = Integer.valueOf(string2.substring(11, 13));
                Integer n6 = Integer.valueOf(string2.substring(14, 16));
                Integer n7 = Integer.valueOf(string2.substring(17, 19));
                calendar.set(n4, n3 - 1, n2, n5, n6, n7);
                this.addPU(new RIObjectPU(n, oracleResultSet.getInt(1), oracleResultSet.getString(2), oracleResultSet.getString(3), oracleResultSet.getString(4), calendar.getTime(), oracleResultSet.getLong(6)));
            }
            oracleResultSet.close();
            this._stmt.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException thrown:  " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    public boolean addPU(RIObjectPU rIObjectPU) {
        this._RIPUList.addElement(rIObjectPU);
        return true;
    }

    public RIObjectPU getFirstPU() {
        return (RIObjectPU)this._RIPUList.firstElement();
    }

    public RIObjectPU getPU(int n) {
        return (RIObjectPU)this._RIPUList.elementAt(n);
    }

    public int getPUCount() {
        return this._RIPUList.size();
    }

    public RIObjectPU getPUByPUName(String string) {
        int n = 0;
        while (n < this.getPUCount()) {
            if (this.getPU(n).getPUName() == string) {
                return this.getPU(n);
            }
            ++n;
        }
        return null;
    }

    public boolean exportObjectPUList(FileWriter fileWriter) {
        try {
            String string = System.getProperties().getProperty("line.separator");
            fileWriter.write(String.valueOf(string) + RIDataSource.padSpaces((String)"PUType") + RIDataSource.padSpaces((String)"PUOwner") + RIDataSource.padSpaces((String)"PUName") + RIDataSource.padSpaces((String)"PUNumber") + RIDataSource.padSpaces((String)"TimeStamp") + RIDataSource.padSpaces((String)"Total Time") + string);
            int n = 0;
            while (n < this.getPUCount()) {
                fileWriter.write(string);
                if (!this.getPU(n).exportObjectPU(fileWriter)) {
                    return false;
                }
                ++n;
            }
            fileWriter.write(String.valueOf(string) + string + RIDataSource.padSpaces((String)"PUNumber") + RIDataSource.padSpaces((String)"Line") + RIDataSource.padSpaces((String)"Occurrences") + RIDataSource.padSpaces((String)"Total Run Time") + RIDataSource.padSpaces((String)"Min Time") + RIDataSource.padSpaces((String)"Max Time") + string);
            n = 0;
            while (n < this.getPUCount()) {
                fileWriter.write(string);
                if (!this.getPU(n).exportPUDetailslist(fileWriter)) {
                    return false;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not write to the file");
            return false;
        }
        return true;
    }

    protected void finalize() throws SQLException {
    }
}

