/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.ui.runinformation;

import oracle.de.backend.runinformation.RIObjectRun;
import oracle.de.backend.runinformation.RIObjectRunList;
import oracle.de.ui.runinformation.RIRunTreeItem;
import oracle.de.ui.runinformation.RIWindow;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeEditListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSelectionListener;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.dTree.DTreeSingleSelection;

public class RIListRuns
extends DTree
implements DTreeSelectionListener,
DTreeEditListener {
    RIObjectRunList _ds;
    RIWindow _Host;
    DTreeSimpleRoot _root;
    RIRunTreeItem _CurSelRun;

    private boolean _init() {
        this._root = new DTreeSimpleRoot();
        this.setRoot((DTreeRootItem)this._root);
        this.setSelection((DTreeSelection)new DTreeSingleSelection());
        this.addSelectionListener((DTreeSelectionListener)this);
        this.addEditListener((DTreeEditListener)this);
        this.setDecoration(null);
        this.setEditable(true);
        return true;
    }

    RIListRuns() {
        this._init();
    }

    RIListRuns(RIWindow rIWindow, RIObjectRunList rIObjectRunList) {
        this._ds = rIObjectRunList;
        this._Host = rIWindow;
        this._init();
    }

    protected void setHost(RIWindow rIWindow) {
        this._Host = rIWindow;
    }

    protected void setDataSource(RIObjectRunList rIObjectRunList) {
        this._ds = rIObjectRunList;
    }

    protected int poppulate(boolean bl) {
        int n = this._ds.getRunsCount();
        int n2 = 0;
        while (n2 < n) {
            RIObjectRun rIObjectRun = this._ds.getRun(n2);
            this._root.addItem((DTreeItem)new RIRunTreeItem(rIObjectRun.getRunId(), rIObjectRun.getRunName()));
            ++n2;
        }
        if (bl) {
            this.getSelection().selectItem(this._root.getItem(0));
        } else {
            this.getSelection().selectItem(this._root.getItem(n2 - 1));
        }
        return n;
    }

    protected int getSelectedItemRunId() {
        return this._CurSelRun.getRunId();
    }

    protected String getSelectedItemRunName() {
        return this._CurSelRun.getRunName();
    }

    protected RIRunTreeItem getCurSelItem() {
        return this._CurSelRun;
    }

    protected void setCurSelItem(RIRunTreeItem rIRunTreeItem) {
        this._CurSelRun = rIRunTreeItem;
    }

    protected void deleteCurSelItem() {
        if (this._CurSelRun != null) {
            int n = this._CurSelRun.getIndex();
            this._root.removeItems(n, 1);
            this.getSelection().selectItem(this._root.getItem(n - 1));
        }
    }

    protected void refresh() {
        this._init();
        this.poppulate(true);
    }

    public void dTreeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent) {
    }

    public void dTreeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent) {
        int n = -1;
        int n2 = -1;
        String string = "";
        DTreeRangeSet dTreeRangeSet = dTreeSelectionEvent.getOldSelectionRanges();
        RIRunTreeItem rIRunTreeItem = (RIRunTreeItem)dTreeRangeSet.getFirstItem();
        if (rIRunTreeItem != null) {
            n = rIRunTreeItem.getRunId();
            string = rIRunTreeItem.getLabel();
        }
        dTreeRangeSet = dTreeSelectionEvent.getNewSelectionRanges();
        rIRunTreeItem = (RIRunTreeItem)dTreeRangeSet.getFirstItem();
        this.setCurSelItem(rIRunTreeItem);
        if (rIRunTreeItem != null) {
            n2 = rIRunTreeItem.getRunId();
            if (n2 == 0) {
                this.setEditable(false);
            } else {
                this.setEditable(true);
            }
        }
        this._Host.runSelectionChanged(n2, n, string);
    }

    public void dTreeItemEditCancelled(DTreeItemEvent dTreeItemEvent) {
    }

    public void dTreeItemEditing(DTreeItemEvent dTreeItemEvent) {
        RIRunTreeItem rIRunTreeItem = (RIRunTreeItem)dTreeItemEvent.getItem();
        if (rIRunTreeItem.getRunId() == 0) {
            this.cancelEdit();
        }
    }

    public void dTreeItemEdited(DTreeItemEvent dTreeItemEvent) {
        RIRunTreeItem rIRunTreeItem = (RIRunTreeItem)dTreeItemEvent.getItem();
        if (rIRunTreeItem != null) {
            this._ds.getRunByRunId(rIRunTreeItem.getRunId()).setModified(true);
        }
    }
}

