/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.ui.runinformation;

import java.awt.Component;
import java.awt.PrintJob;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.bali.share.sort.DateComparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.de.backend.runinformation.RIObjectPU;
import oracle.de.backend.runinformation.RIObjectPUList;
import oracle.de.ui.runinformation.DblClkEventListener;
import oracle.de.ui.runinformation.DblClkEventObject;
import oracle.de.ui.runinformation.DoubleClickHandler;
import oracle.de.ui.runinformation.RITab;
import oracle.de.ui.runinformation.RIWSorter;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderItemInputHandler;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.print.PrinterUtils;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;

public class RISpreadByPU
extends SpreadTable
implements TableRowSelectListener,
DblClkEventListener {
    RITab _Host;
    RIObjectPUList _ds;
    ArrayOneDDataSource _RIBPHeaders;
    ArrayOneDDataSource _RIBPRowHeaders;
    SortableTwoDDataSource _RIBPData;

    RISpreadByPU() {
        this.setDataSource(null);
        this.setHost(null);
    }

    RISpreadByPU(RITab rITab, String[] stringArray) {
        this.setHost(rITab);
        this.setDataSource(null);
        this._init(stringArray);
    }

    protected void setHost(RITab rITab) {
        this._Host = rITab;
    }

    protected void setDataSource(RIObjectPUList rIObjectPUList) {
        this._ds = rIObjectPUList;
    }

    protected RIObjectPUList getDataSource() {
        return this._ds;
    }

    private boolean _init(String[] stringArray) {
        this._RIBPHeaders = new ArrayOneDDataSource((Object[])stringArray);
        return true;
    }

    protected Grid createGrid(TwoDDataSource twoDDataSource) {
        Grid grid = new Grid();
        grid.setDataSource(twoDDataSource);
        DoubleClickHandler doubleClickHandler = new DoubleClickHandler(grid.getDefaultInputHandler());
        doubleClickHandler.addDblClkEventListener((DblClkEventListener)this);
        grid.setDefaultInputHandler((CellInputHandler)doubleClickHandler);
        return grid;
    }

    protected int poppulate() {
        boolean[] blArray;
        if (this._ds != null) {
            int n = this._ds.getPUCount();
            this._RIBPData = new SortableTwoDDataSource(this._RIBPHeaders.getItemCount(), n);
            this._RIBPRowHeaders = new ArrayOneDDataSource(n);
            int n2 = 0;
            while (n2 < n) {
                RIObjectPU rIObjectPU = this._ds.getPU(n2);
                this._RIBPData.setData(0, n2, (Object)rIObjectPU.getPUType());
                this._RIBPData.setData(2, n2, (Object)rIObjectPU.getPUName());
                this._RIBPData.setData(1, n2, (Object)rIObjectPU.getPUOwner());
                this._RIBPData.setData(3, n2, (Object)new Integer(rIObjectPU.getPUNumber()));
                this._RIBPData.setData(4, n2, (Object)rIObjectPU.getPUTimeStamp());
                this._RIBPData.setData(5, n2, (Object)new Long(rIObjectPU.getTotalRunTime()));
                this._RIBPData.setData(6, n2, (Object)rIObjectPU);
                ++n2;
            }
            blArray = new boolean[this._RIBPHeaders.getItemCount()];
            blArray[0] = true;
            this._RIBPData.setColumnComparator(3, NumberComparator.getComparator());
            blArray[3] = true;
            this._RIBPData.setColumnComparator(4, DateComparator.getComparator());
            blArray[4] = true;
            this._RIBPData.setColumnComparator(5, NumberComparator.getComparator());
            blArray[5] = true;
            this.setDataSources((TwoDDataSource)this._RIBPData, (OneDDataSource)this._RIBPHeaders, (OneDDataSource)this._RIBPRowHeaders);
            this.addRowSelectListener((TableRowSelectListener)this);
            this.setSpreadColumns();
            if (this._RIBPHeaders != null) {
                this.setColumnVisible(this._RIBPHeaders.getItemCount() - 1, false);
            }
        } else {
            if (this._RIBPData != null) {
                int n = this._RIBPData.getRowCount();
                this._RIBPData.removeRows(0, n);
                this._RIBPRowHeaders.removeItems(0, n);
            }
            this.setDataSources(null, null, null);
            return 0;
        }
        Header header = this.getColumnHeader();
        header.setItemInputHandler((HeaderItemInputHandler)new RIWSorter(this._RIBPData, blArray));
        return 0;
    }

    private void setSpreadColumns() {
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        this.getGrid().setAppearanceManager((AppearanceManager)complexAppearanceManager);
        complexAppearanceManager = (ComplexAppearanceManager)this.getGrid().getAppearanceManager();
        this.setColumnWidth(0, 140);
        this.setColumnWidth(1, 140);
        this.setColumnWidth(2, 140);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(3);
        appearance.setHorizontalJustify(2);
        complexAppearanceManager.setColumnAppearance(3, appearance);
        this.setColumnWidth(3, 40);
        appearance = complexAppearanceManager.getColumnAppearance(4);
        appearance.setHorizontalJustify(3);
        complexAppearanceManager.setColumnAppearance(4, appearance);
        this.setColumnWidth(4, 120);
        appearance = complexAppearanceManager.getColumnAppearance(5);
        appearance.setHorizontalJustify(2);
        complexAppearanceManager.setColumnAppearance(5, appearance);
        this.setColumnWidth(5, 100);
    }

    public void printContents(PrintJob printJob, BufferedFrame bufferedFrame, int n, int n2) {
        int n3;
        Hashtable hashtable = this.getPrintDictionary();
        boolean bl = true;
        int n4 = -1;
        if (n2 == n4 || n == n4) {
            n3 = this._RIBPData.getRowCount();
            n = 0;
        } else {
            n3 = n2 > this._RIBPData.getRowCount() ? this._RIBPData.getRowCount() - n : n2 - n;
        }
        ArrayTwoDDataSource arrayTwoDDataSource = new ArrayTwoDDataSource(this._RIBPHeaders.getItemCount(), n3);
        ArrayOneDDataSource arrayOneDDataSource = new ArrayOneDDataSource(n3);
        int n5 = 0;
        while (n5 < n3) {
            arrayTwoDDataSource.setData(0, n5, this._RIBPData.getData(0, n5 + n));
            arrayTwoDDataSource.setData(1, n5, this._RIBPData.getData(1, n5 + n));
            arrayTwoDDataSource.setData(2, n5, this._RIBPData.getData(2, n5 + n));
            arrayTwoDDataSource.setData(3, n5, this._RIBPData.getData(3, n5 + n));
            arrayTwoDDataSource.setData(4, n5, this._RIBPData.getData(4, n5 + n));
            arrayTwoDDataSource.setData(5, n5, this._RIBPData.getData(5, n5 + n));
            ++n5;
        }
        RISpreadByPU rISpreadByPU = new RISpreadByPU();
        rISpreadByPU.setDataSources((TwoDDataSource)arrayTwoDDataSource, (OneDDataSource)this._RIBPHeaders, (OneDDataSource)arrayOneDDataSource);
        rISpreadByPU.setSpreadColumns();
        rISpreadByPU.setColumnVisible(this._RIBPHeaders.getItemCount() - 1, false);
        bufferedFrame.add((Component)rISpreadByPU, "Center");
        bufferedFrame.pack();
        int n6 = printJob.getPageResolution();
        PrinterUtils.print((LWComponent)rISpreadByPU, (Dictionary)hashtable, (boolean)bl, (PrintJob)printJob, null, null, null, (int)((int)((double)n6)), (int)((int)((double)n6)), (int)((int)((double)n6)), (int)((int)((double)n6)));
    }

    private Hashtable getPrintDictionary() {
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>(8);
        Object object = SpreadTable.DUPLICATE_COLUMN_HEADERS;
        Boolean bl = Boolean.FALSE;
        hashtable.put(object, bl);
        object = SpreadTable.DUPLICATE_ROW_HEADERS;
        bl = Boolean.FALSE;
        hashtable.put(object, bl);
        object = SpreadTable.DISPLAY_COLUMN_HEADERS;
        bl = Boolean.TRUE;
        hashtable.put(object, bl);
        object = SpreadTable.DISPLAY_ROW_HEADERS;
        bl = Boolean.FALSE;
        hashtable.put(object, bl);
        object = SpreadTable.PRINT_RAISED;
        bl = Boolean.FALSE;
        hashtable.put(object, bl);
        return hashtable;
    }

    public void gridDoubleClicked(DblClkEventObject dblClkEventObject) {
        RIObjectPU rIObjectPU = (RIObjectPU)this._RIBPData.getData(this._RIBPHeaders.getItemCount() - 1, dblClkEventObject.getRow());
        this._Host.PUSpreadRowSelected(rIObjectPU);
    }

    public void rowDeselected(TableEvent tableEvent) {
    }

    public void rowDeselecting(TableEvent tableEvent) {
    }

    public void rowSelected(TableEvent tableEvent) {
        RIObjectPU rIObjectPU = (RIObjectPU)this._RIBPData.getData(this._RIBPHeaders.getItemCount() - 1, tableEvent.getRow());
        this._Host.PUSpreadRowSelected(rIObjectPU);
    }

    public void rowSelecting(TableEvent tableEvent) {
    }
}

