/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.ui.runinformation;

import oracle.de.backend.runinformation.RIObjectRun;
import oracle.de.backend.runinformation.RIObjectRunList;
import oracle.de.ui.runinformation.RITab;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.table.SpreadTable;

public class RISpreadSummary
extends SpreadTable {
    RITab _Host;
    RIObjectRunList _ds;
    ArrayOneDDataSource _RIRSHeaders;
    ArrayTwoDDataSource _RIRSData;
    int _RunId;

    private boolean _init(String[] stringArray) {
        this._RIRSHeaders = new ArrayOneDDataSource((Object[])stringArray);
        return true;
    }

    RISpreadSummary() {
        this.setDataSource(null, -1);
        this.setHost(null);
        this._RunId = -1;
    }

    RISpreadSummary(RITab rITab, String[] stringArray) {
        this.setHost(rITab);
        this.setDataSource(null, -1);
        this._init(stringArray);
    }

    protected void setHost(RITab rITab) {
        this._Host = rITab;
    }

    protected void setDataSource(RIObjectRunList rIObjectRunList, int n) {
        this._ds = rIObjectRunList;
        this._RunId = n;
    }

    protected int poppulate() {
        if (this._ds != null) {
            int n = this.getGrid().getRowCount();
            if (n > 0) {
                this._RIRSData.removeRows(0, n);
            }
            if (this._RunId != 0) {
                if (this._RIRSData == null) {
                    this._RIRSData = new ArrayTwoDDataSource(this._RIRSHeaders.getItemCount(), 1);
                } else {
                    this._RIRSData.addRows(0, 1);
                }
                this._loadRun(this._ds.getRunByRunId(this._RunId), 0);
            } else if (this._RunId == 0) {
                n = this._ds.getRunsCount();
                if (this._RIRSData == null) {
                    this._RIRSData = new ArrayTwoDDataSource(this._RIRSHeaders.getItemCount(), n - 1);
                } else {
                    this._RIRSData.addRows(0, n - 1);
                }
                int n2 = 1;
                while (n2 < n) {
                    this._loadRun(this._ds.getRun(n2), n2 - 1);
                    ++n2;
                }
            }
            this.setDataSources((TwoDDataSource)this._RIRSData, (OneDDataSource)this._RIRSHeaders, null);
            this.setSpreadColumns();
        }
        return 0;
    }

    public String getPrintableContent() {
        String string = "";
        String string2 = System.getProperties().getProperty("line.separator");
        int n = 1;
        while (n < this._RIRSHeaders.getItemCount()) {
            string = String.valueOf(string) + this._RIRSHeaders.getData(n) + "  :  " + this._RIRSData.getData(n, 0) + string2;
            ++n;
        }
        return string;
    }

    private void setSpreadColumns() {
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        this.getGrid().setAppearanceManager((AppearanceManager)complexAppearanceManager);
        complexAppearanceManager = (ComplexAppearanceManager)this.getGrid().getAppearanceManager();
        this.setColumnWidth(0, 180);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(1);
        appearance.setHorizontalJustify(2);
        complexAppearanceManager.setColumnAppearance(1, appearance);
        this.setColumnWidth(1, 60);
        appearance = complexAppearanceManager.getColumnAppearance(2);
        appearance.setHorizontalJustify(3);
        complexAppearanceManager.setColumnAppearance(2, appearance);
        this.setColumnWidth(2, 120);
        appearance = complexAppearanceManager.getColumnAppearance(3);
        appearance.setHorizontalJustify(2);
        complexAppearanceManager.setColumnAppearance(3, appearance);
        this.setColumnWidth(3, 150);
    }

    private boolean _loadRun(RIObjectRun rIObjectRun, int n) {
        if (rIObjectRun != null) {
            this._RIRSData.setData(0, n, (Object)rIObjectRun.getRunName());
            this._RIRSData.setData(1, n, (Object)new Integer(rIObjectRun.getRunId()));
            this._RIRSData.setData(2, n, (Object)rIObjectRun.getRunDate());
            this._RIRSData.setData(3, n, (Object)new Long(rIObjectRun.getTotalRunTime()));
            return true;
        }
        return false;
    }
}

