/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql;

import java.sql.SQLException;

public class OracleXMLSQLException
extends RuntimeException {
    private String errorTag = "ERROR";
    int sqlErrorCode;
    boolean errCodeSet = false;
    String sqlState;
    Exception parentE;

    public OracleXMLSQLException(Exception exception) {
        super(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
        this.parentE = exception;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public OracleXMLSQLException(Exception exception, String string) {
        super(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
        this.parentE = exception;
        this.errorTag = string;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public OracleXMLSQLException(String string, Exception exception) {
        super(String.valueOf(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage()) + "\n Note " + string);
        this.parentE = exception;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public OracleXMLSQLException(String string, Exception exception, String string2) {
        super(String.valueOf(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage()) + "\n Note " + string);
        this.parentE = exception;
        this.errorTag = string2;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public OracleXMLSQLException(String string) {
        super(string);
    }

    public OracleXMLSQLException(String string, String string2) {
        super(string);
        this.errorTag = string2;
    }

    public OracleXMLSQLException(String string, int n) {
        super(string);
        this.sqlErrorCode = n;
        this.errCodeSet = true;
    }

    public OracleXMLSQLException(String string, int n, String string2) {
        super(string);
        this.sqlErrorCode = n;
        this.errCodeSet = true;
        this.errorTag = string2;
    }

    public String getXMLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public String getXMLSQLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append("  <MESSAGE>\n    " + this.getMessage() + "  </MESSAGE>\n");
        if (this.sqlState != null) {
            stringBuffer.append("  <SQLSTATE>" + this.sqlState + "</SQLSTATE>\n");
        }
        if (this.errCodeSet) {
            stringBuffer.append("  <ERRORCODE>" + this.sqlErrorCode + "</ERRORCODE>\n");
        }
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public Exception getParentException() {
        return this.parentE;
    }

    public void setErrorTag(String string) {
        if (string != null) {
            this.errorTag = string;
        }
    }

    public int getErrorCode() {
        return this.sqlErrorCode;
    }
}

