/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc2.Clob;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.core.OracleXMLTimer;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.name.OracleADTName;
import oracle.xml.sql.name.OracleCollectionName;
import oracle.xml.sql.name.OracleColumnName;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleXMLSave {
    public static int DEFAULT_BATCH_SIZE = 17;
    private int batchSize = DEFAULT_BATCH_SIZE;
    private int commitBatch;
    private Connection conn;
    private String tableName;
    private DOMParser parser;
    private String rowtagName = "ROW";
    private boolean ignoreCase = false;
    public static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private Vector clobList = new Vector(5, 5);
    private Vector blobList = new Vector(5, 5);
    private String dateFormat = "MM/dd/yyyy HH:mm:ss";
    private boolean collectTimingInfo = false;
    private OracleXMLTimer tim;
    private OraclePreparedStatement setSavePt;
    private OraclePreparedStatement rollbackToSavePt;
    private static final int INSERT = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 3;
    private OraclePreparedStatement updStmt;
    private OraclePreparedStatement delStmt;
    private OraclePreparedStatement insStmt;
    private OracleCallableStatement createClobStmt;
    private OracleCallableStatement createBlobStmt;
    private OracleCallableStatement freeLobStmt;
    private String[] keyColNames;
    private String[] updColNames;
    private Hashtable updHash;
    private boolean updHashValid = true;
    private Hashtable keyHash;
    private boolean keyHashValid = true;
    private Hashtable insBindPos;
    private Hashtable delBindPos;
    private Hashtable updBindPos;
    private SimpleDateFormat dateFormatter;
    OracleColumnName[] colNames;
    Hashtable colBindPos;
    int colCount;
    static XSUMesg msg = new XSUMesg();

    public OracleXMLSave(Connection connection, String string) {
        this.conn = connection;
        this.tableName = string;
        try {
            this.parser = new DOMParser();
            this.setParserOptions(this.parser);
            return;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    public OracleXMLSave(Connection connection, OracleColumnName[] oracleColumnNameArray) {
        this.conn = connection;
        this.tableName = null;
        this.colNames = oracleColumnNameArray;
    }

    private void setParserOptions(DOMParser dOMParser) throws IOException {
        dOMParser.setErrorStream((OutputStream)System.err);
        dOMParser.showWarnings(false);
    }

    private void getTableMetaData() throws SQLException {
        if (this.colNames == null) {
            String string = " select * from " + this.tableName + " where rownum < 1";
            OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc = new OracleXMLDataSetExtJdbc(this.conn, string);
            OracleXMLConvert oracleXMLConvert = new OracleXMLConvert(this.conn, oracleXMLDataSetExtJdbc);
            if (this.ignoreCase) {
                oracleXMLConvert.setMiscFlags(1);
            } else {
                oracleXMLConvert.setMiscFlags(2);
            }
            oracleXMLConvert.createColNames();
            this.colNames = oracleXMLConvert.getColNames();
            this.colCount = oracleXMLDataSetExtJdbc.getColumnCount();
            oracleXMLDataSetExtJdbc.close();
            this.colBindPos = null;
        }
        if (this.colBindPos == null) {
            this.colBindPos = new Hashtable(2 * this.colCount);
            int n = 0;
            while (n < this.colCount) {
                if (this.ignoreCase) {
                    this.colBindPos.put(this.colNames[n].getLabel().toLowerCase(), new Integer(n + 1));
                } else {
                    this.colBindPos.put(this.colNames[n].getLabel(), new Integer(n + 1));
                }
                ++n;
            }
        }
    }

    private int getColNamesIndex(String string) {
        Integer n = (Integer)this.colBindPos.get(this.ignoreCase ? string.toLowerCase() : string);
        if (n == null) {
            throw new OracleXMLSQLException(msg.getMessage1("XSUE-0200", string));
        }
        return n;
    }

    public void setCommitBatch(int n) {
        this.commitBatch = n > 0 ? n : 0;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
        this.colBindPos = null;
        this.colNames = null;
        this.clearInsertSettings();
        this.clearUpdateSettings();
        this.clearDeleteSettings();
        this.updHash = null;
        this.keyHash = null;
    }

    public void setRowTag(String string) {
        if (string == null || string.length() == 0) {
            this.rowtagName = null;
            return;
        }
        this.rowtagName = string;
    }

    public void setDateFormat(String string) {
        if (string == null || string.length() == 0) {
            this.dateFormat = DATE_FORMAT;
            return;
        }
        this.dateFormat = string;
    }

    public URL createURL(String string) {
        return OracleXMLSave.getURL(string);
    }

    public static URL getURL(String string) {
        URL uRL = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists()) {
                throw new OracleXMLSQLException(msg.getMessage1("XSUE-0016", string));
            }
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = String.valueOf('/') + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new OracleXMLSQLException(malformedURLException2);
            }
        }
        return uRL;
    }

    private void validateColHash(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2 = this.ignoreCase ? string2.toLowerCase() : string2;
            if (this.colBindPos.containsKey(string2)) continue;
            throw new OracleXMLSQLException(msg.getMessage2(string, string2, this.tableName));
        }
    }

    private Hashtable createHashFromStrArray(String[] stringArray, String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(stringArray.length);
        Integer n = new Integer(1);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2;
            if (stringArray[n2] == null) {
                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0201"));
            }
            String string3 = string2 = this.ignoreCase ? stringArray[n2].toLowerCase() : stringArray[n2];
            if (!this.colBindPos.containsKey(string2)) {
                throw new OracleXMLSQLException(msg.getMessage2(string, string2, this.tableName));
            }
            hashtable.put(string2, n);
            ++n2;
        }
        return hashtable;
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            try {
                this.clearSavePoint();
                this.clearInsertSettings();
                this.clearUpdateSettings();
                this.clearDeleteSettings();
                this.cleanLobList();
                this.cleanLobStmt();
            }
            catch (OracleXMLSQLException oracleXMLSQLException) {
                throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_3 = null;
            this.setAllToNull();
            return;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.setAllToNull();
            throw throwable;
        }
    }

    private void setAllToNull() {
        this.keyHash = null;
        this.updHash = null;
        this.keyColNames = null;
        this.updColNames = null;
        this.insStmt = null;
        this.updStmt = null;
        this.delStmt = null;
        this.insBindPos = null;
        this.updBindPos = null;
        this.delBindPos = null;
        this.freeLobStmt = null;
        this.createClobStmt = null;
        this.createBlobStmt = null;
    }

    private void createSavePoint() throws SQLException {
        this.setSavePt = (OraclePreparedStatement)this.conn.prepareStatement("savepoint SYS_XSU_hope_0001000");
        this.rollbackToSavePt = (OraclePreparedStatement)this.conn.prepareStatement("rollback to savepoint SYS_XSU_hope_0001000");
    }

    private void clearSavePoint() {
        try {
            try {
                if (this.setSavePt != null) {
                    this.setSavePt.close();
                }
                if (this.rollbackToSavePt != null) {
                    this.rollbackToSavePt.close();
                }
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_2 = null;
            this.setSavePt = null;
            this.rollbackToSavePt = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setSavePt = null;
            this.rollbackToSavePt = null;
            throw throwable;
        }
    }

    private Object getObjectVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        switch (oracleColumnName.getColumnType()) {
            case 2002: {
                return this.getStructVal(node, oracleColumnName);
            }
            case 2003: {
                return this.getArrayVal(node, oracleColumnName);
            }
            case 2006: {
                return this.getRefVal(node, oracleColumnName);
            }
            case 93: {
                if (node.getFirstChild() == null) {
                    return null;
                }
                String string = node.getFirstChild().getNodeValue();
                return this.createTimestamp(string);
            }
            case 2004: 
            case 2005: {
                return this.getLobVal(node, oracleColumnName);
            }
        }
        if (node.getFirstChild() == null) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public STRUCT getStructVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        Object[] objectArray = new Object[oracleADTName.getAttributeCount()];
        NodeList nodeList = node.getChildNodes();
        nodeList.getLength();
        String string = null;
        int n = objectArray.length - 1;
        while (n >= 0) {
            objectArray[n] = null;
            --n;
        }
        int n2 = nodeList.getLength() - 1;
        while (n2 >= 0) {
            string = nodeList.item(n2).getNodeName();
            if (!string.startsWith("#", 0)) {
                int n3 = oracleADTName.getAttributePos(string);
                if (n3 < 0) {
                    throw new OracleXMLSQLException(msg.getMessage1("XSUE-0200", string));
                }
                objectArray[n3] = this.getObjectVal(nodeList.item(n2), oracleADTName.getAttributeName(n3));
            }
            --n2;
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)((String)oracleADTName.getBaseTypeObj()), (Connection)this.conn);
        return new STRUCT(structDescriptor, this.conn, objectArray);
    }

    private Object getLobVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        CLOB cLOB;
        String string = node.getFirstChild().getNodeValue();
        if (oracleColumnName.getColumnType() == 2005) {
            cLOB = this.createTempCLOBFromString(string);
            this.clobList.addElement(cLOB);
        } else {
            cLOB = this.createTempBLOBFromString(string);
            this.blobList.addElement(cLOB);
        }
        return cLOB;
    }

    private REF getRefVal(Node node, OracleColumnName oracleColumnName) throws SQLException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("REFTYPE");
        if (node2 == null) {
            if (this.ignoreCase) {
                node2 = namedNodeMap.getNamedItem("REFTYPE".toLowerCase());
            }
            if (node2 == null) {
                throw new OracleXMLSQLException(msg.getMessage2("XSUE-0204", oracleColumnName.getLabel(), "REFTYPE"));
            }
        }
        StructDescriptor structDescriptor = new StructDescriptor(node2.getNodeValue(), this.conn);
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(node.getFirstChild().getNodeValue());
        return new REF(structDescriptor, this.conn, byArray);
    }

    private ARRAY getArrayVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        OracleCollectionName oracleCollectionName = (OracleCollectionName)oracleColumnName;
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)((String)oracleCollectionName.getBaseTypeObj()), (Connection)this.conn);
        NodeList nodeList = node.getChildNodes();
        Object[] objectArray = new Object[nodeList.getLength()];
        OracleColumnName oracleColumnName2 = oracleCollectionName.getBaseColumnName();
        int n = arrayDescriptor.getBaseType();
        int n2 = oracleColumnName2.getColumnType();
        if (n2 == 0 && (n == 2002 || n == 2003) || n2 != 0 && n2 != n) {
            throw new OracleXMLSQLException("getArrayVal:  " + msg.getMessage1("XSUE-0001", String.valueOf(oracleCollectionName.getBaseColumnName().getColumnType()) + " != " + arrayDescriptor.getBaseType()));
        }
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node2 = nodeList.item(n3);
            if (!node2.getNodeName().startsWith("#", 0)) {
                objectArray[n3] = this.getObjectVal(node2, oracleColumnName2);
            }
            ++n3;
        }
        return new ARRAY(arrayDescriptor, this.conn, (Object)objectArray);
    }

    private void cleanLobList() {
        int n = this.clobList.size();
        int n2 = this.blobList.size();
        if (n == 0 && n2 == 0) {
            return;
        }
        try {
            int n3;
            if (this.freeLobStmt == null) {
                this.freeLobStmt = (OracleCallableStatement)this.conn.prepareCall("begin dbms_lob.freetemporary(?); end;");
            }
            if (n > 0) {
                n3 = 0;
                while (n3 < n) {
                    this.freeLobStmt.setClob(1, (Clob)((CLOB)this.clobList.elementAt(n3)));
                    this.freeLobStmt.execute();
                    ++n3;
                }
                this.clobList.removeAllElements();
            }
            if (n2 > 0) {
                n3 = 0;
                while (n3 < n2) {
                    this.freeLobStmt.setBLOB(1, (BLOB)this.blobList.elementAt(n3));
                    this.freeLobStmt.execute();
                    ++n3;
                }
                this.blobList.removeAllElements();
                return;
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception.toString());
        }
    }

    private void cleanLobStmt() {
        try {
            try {
                if (this.freeLobStmt != null) {
                    this.freeLobStmt.close();
                }
                if (this.createClobStmt != null) {
                    this.createClobStmt.close();
                }
                if (this.createBlobStmt != null) {
                    this.createBlobStmt.close();
                }
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_2 = null;
            this.createClobStmt = null;
            this.createBlobStmt = null;
            this.freeLobStmt = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.createClobStmt = null;
            this.createBlobStmt = null;
            this.freeLobStmt = null;
            throw throwable;
        }
    }

    private Timestamp createTimestamp(String string) throws ParseException {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(this.dateFormat);
        }
        Date date = this.dateFormatter.parse(string);
        return new Timestamp(date.getTime());
    }

    public void collectTimingInfo(boolean bl) {
        this.collectTimingInfo = bl;
        if (bl) {
            this.tim = new OracleXMLTimer();
        }
    }

    public String getTimingInfo() {
        if (this.tim == null) {
            return "No timing result to display. Execute getXML first before";
        }
        return this.tim.getResult();
    }

    private void clearInsertSettings() {
        this.insBindPos = null;
        try {
            try {
                if (this.insStmt != null) {
                    this.insStmt.close();
                }
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_2 = null;
            this.insStmt = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.insStmt = null;
            throw throwable;
        }
    }

    public int insertXML(URL uRL) {
        return this.saveXML(uRL, 1);
    }

    public int insertXML(String string) {
        return this.saveXML(new ByteArrayInputStream(string.getBytes()), 1);
    }

    public int insertXML(InputStream inputStream) {
        return this.saveXML(inputStream, 1);
    }

    public int insertXML(Document document) {
        return this.saveXML(document, 1);
    }

    private OraclePreparedStatement createInsStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        hashtableArray[0] = null;
        if (this.insStmt != null && this.insBindPos != null) {
            hashtableArray[0] = this.insBindPos;
            return this.insStmt;
        }
        Hashtable hashtable = nodeList != null ? this.createHashFromNodeList(null, nodeList) : (this.updHash == null || this.updHash.isEmpty() ? this.colBindPos : this.updHash);
        StringBuffer stringBuffer = new StringBuffer("insert into " + this.tableName + " ( ");
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(hashtable.size());
        int n = 1;
        Enumeration enumeration = hashtable.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        stringBuffer.append(") values ( ");
        int n2 = 0;
        while (n2 < n - 1) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("?");
            ++n2;
        }
        stringBuffer.append(")");
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return oraclePreparedStatement;
    }

    private void addBindPositions(StringBuffer stringBuffer, OracleColumnName[] oracleColumnNameArray) {
        if (oracleColumnNameArray.length > 0) {
            stringBuffer.append("?");
        }
        int n = 1;
        while (n < oracleColumnNameArray.length) {
            stringBuffer.append(",?");
            ++n;
        }
    }

    private boolean isOracleSpecificType(int n) {
        return n == 2002 || n == 2006 || n == 2003;
    }

    private void setBindValue(OraclePreparedStatement oraclePreparedStatement, Node node, int n, int n2) throws SQLException, ParseException, IOException {
        OracleColumnName oracleColumnName = this.colNames[n];
        String string = null;
        switch (oracleColumnName.getColumnType()) {
            case 2002: {
                oraclePreparedStatement.setSTRUCT(n2, this.getStructVal(node, oracleColumnName));
                return;
            }
            case 2003: {
                oraclePreparedStatement.setARRAY(n2, this.getArrayVal(node, oracleColumnName));
                return;
            }
            case 2006: {
                oraclePreparedStatement.setREF(n2, this.getRefVal(node, oracleColumnName));
                return;
            }
            case 2005: {
                if (node.getFirstChild() != null) {
                    string = node.getFirstChild().getNodeValue();
                    CLOB cLOB = this.createTempCLOBFromString(string);
                    oraclePreparedStatement.setCLOB(n2, cLOB);
                    this.clobList.addElement(cLOB);
                    return;
                }
                oraclePreparedStatement.setNull(n2, oracleColumnName.getColumnType());
                return;
            }
            case 2004: {
                if (node.getFirstChild() != null) {
                    string = node.getFirstChild().getNodeValue();
                    BLOB bLOB = this.createTempBLOBFromString(string);
                    oraclePreparedStatement.setBLOB(n2, bLOB);
                    this.blobList.addElement(bLOB);
                    return;
                }
                oraclePreparedStatement.setNull(n2 + 1, oracleColumnName.getColumnType());
                return;
            }
            case 93: {
                if (node.getFirstChild() == null) {
                    oraclePreparedStatement.setNull(n2, oracleColumnName.getColumnType());
                    return;
                }
                String string2 = node.getFirstChild().getNodeValue();
                oraclePreparedStatement.setTimestamp(n2, this.createTimestamp(string2));
                return;
            }
        }
        if (node.getFirstChild() != null) {
            oraclePreparedStatement.setString(n2, node.getFirstChild().getNodeValue());
            return;
        }
        oraclePreparedStatement.setNull(n2, oracleColumnName.getColumnType());
    }

    private void clearUpdateSettings() {
        this.updBindPos = null;
        try {
            try {
                if (this.updStmt != null) {
                    this.updStmt.close();
                }
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_2 = null;
            this.updStmt = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updStmt = null;
            throw throwable;
        }
    }

    public int updateXML(URL uRL) {
        return this.saveXML(uRL, 2);
    }

    public int updateXML(String string) {
        return this.saveXML(new ByteArrayInputStream(string.getBytes()), 2);
    }

    public int updateXML(InputStream inputStream) {
        return this.saveXML(inputStream, 2);
    }

    public int updateXML(Document document) {
        return this.saveXML(document, 2);
    }

    private OraclePreparedStatement createUpdStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        Object object;
        int n = 0;
        hashtableArray[0] = null;
        if (this.keyHash == null || this.keyHash.isEmpty()) {
            throw new OracleXMLSQLException(msg.getMessage1("XSUE-0206", "setKeyColumnList()"));
        }
        if (this.updStmt != null && this.updBindPos != null) {
            hashtableArray[0] = this.updBindPos;
            return this.updStmt;
        }
        Hashtable hashtable = nodeList != null ? this.createHashFromNodeList(this.keyHash, nodeList) : this.updHash;
        if (nodeList == null && (hashtable == null || hashtable.isEmpty())) {
            return null;
        }
        if (hashtable == null || hashtable.isEmpty()) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0207"));
        }
        StringBuffer stringBuffer = new StringBuffer("update " + this.tableName + " set ");
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(hashtable.size() + this.keyHash.size());
        Enumeration enumeration = hashtable.keys();
        n = 1;
        while (enumeration.hasMoreElements()) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(" = ? ");
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        enumeration = this.keyHash.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
                stringBuffer.append(" where ");
            } else {
                stringBuffer.append(" and ");
            }
            object = (String)enumeration.nextElement();
            stringBuffer.append((String)object);
            stringBuffer.append(" = ? ");
            hashtable2.put((String)object, new Integer(n));
            ++n;
        }
        object = (OraclePreparedStatement)this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return object;
    }

    private void clearDeleteSettings() {
        this.delBindPos = null;
        try {
            try {
                if (this.delStmt != null) {
                    this.delStmt.close();
                }
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            Object var2_2 = null;
            this.delStmt = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.delStmt = null;
            throw throwable;
        }
    }

    public int deleteXML(URL uRL) {
        return this.saveXML(uRL, 3);
    }

    public int deleteXML(String string) {
        return this.saveXML(new ByteArrayInputStream(string.getBytes()), 3);
    }

    public int deleteXML(InputStream inputStream) {
        return this.saveXML(inputStream, 3);
    }

    public int deleteXML(Document document) {
        return this.saveXML(document, 3);
    }

    private OraclePreparedStatement createDelStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        Object object;
        Hashtable hashtable;
        hashtableArray[0] = null;
        if (this.delStmt != null && this.delBindPos != null) {
            hashtableArray[0] = this.delBindPos;
            return this.delStmt;
        }
        if (nodeList != null) {
            hashtable = this.createHashFromNodeList(null, nodeList);
        } else {
            if (this.keyHash == null || this.keyHash.isEmpty()) {
                return null;
            }
            hashtable = this.keyHash;
        }
        StringBuffer stringBuffer = new StringBuffer("delete from " + this.tableName + " where ");
        Hashtable<OraclePreparedStatement, Integer> hashtable2 = new Hashtable<OraclePreparedStatement, Integer>(hashtable.size());
        int n = 1;
        Enumeration enumeration = hashtable.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" and ");
            }
            object = (String)enumeration.nextElement();
            stringBuffer.append((String)object);
            stringBuffer.append(" = ? ");
            hashtable2.put((OraclePreparedStatement)object, new Integer(n));
            ++n;
        }
        object = (OraclePreparedStatement)this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return object;
    }

    private Hashtable createHashFromNodeList(Hashtable hashtable, NodeList nodeList) {
        int n = nodeList.getLength();
        Integer n2 = new Integer(10);
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(n);
        int n3 = 0;
        while (n3 < n) {
            String string = nodeList.item(n3).getNodeName();
            if (!(string.startsWith("#", 0) || hashtable != null && hashtable.containsKey(this.ignoreCase ? string.toLowerCase() : string))) {
                hashtable2.put(this.ignoreCase ? string.toLowerCase() : string, n2);
            }
            ++n3;
        }
        return hashtable2;
    }

    public void setBatchSize(int n) {
        this.batchSize = n > 0 ? n : DEFAULT_BATCH_SIZE;
    }

    public void setKeyColumnList(String[] stringArray) {
        if (stringArray.length <= 0) {
            throw new OracleXMLSQLException("setKeyColumnList:  " + msg.getMessage0("XSUE-0208"));
        }
        this.clearUpdateSettings();
        this.clearDeleteSettings();
        this.keyHash = null;
        this.keyColNames = stringArray;
        this.keyHashValid = false;
    }

    void setKeyColumn(String string) {
        if (string == null) {
            throw new OracleXMLSQLException("setKeyColumn:  " + msg.getMessage0("XSUE-0201"));
        }
        if (this.keyHash == null) {
            this.keyHash = new Hashtable(10);
        }
        this.keyHash.put(this.ignoreCase ? string.toLowerCase() : string, this.keyHash);
        this.keyHashValid = false;
        this.clearUpdateSettings();
        this.clearDeleteSettings();
    }

    void clearKeyColumnList() {
        this.keyHash = null;
        this.keyHashValid = true;
        this.clearUpdateSettings();
        this.clearDeleteSettings();
    }

    public void setUpdateColumnList(String[] stringArray) {
        if (stringArray.length <= 0) {
            throw new OracleXMLSQLException("setUpdateColumnList:  " + msg.getMessage0("XSUE-0209"));
        }
        this.clearInsertSettings();
        this.clearUpdateSettings();
        this.updHash = null;
        this.updColNames = stringArray;
        this.updHashValid = false;
    }

    void setUpdateColumn(String string) {
        if (string == null) {
            throw new OracleXMLSQLException("setUpdateColumn:  " + msg.getMessage0("XSUE-0201"));
        }
        if (this.updHash == null) {
            this.updHash = new Hashtable(10);
        }
        this.updHash.put(this.ignoreCase ? string.toLowerCase() : string, this.updHash);
        this.updHashValid = false;
        this.clearInsertSettings();
        this.clearUpdateSettings();
    }

    void clearUpdateColumnList() {
        this.updHash = null;
        this.updHashValid = true;
        this.clearInsertSettings();
        this.clearUpdateSettings();
    }

    private int saveXML(URL uRL, int n) {
        try {
            this.parser.parse(uRL);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        return this.saveXML((Document)this.parser.getDocument(), n);
    }

    private int saveXML(InputStream inputStream, int n) {
        try {
            this.parser.parse(inputStream);
            return this.saveXML((Document)this.parser.getDocument(), n);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    private int saveXML(Document document, int n) {
        try {
            int n2;
            try {
                NodeList nodeList;
                boolean bl = false;
                if (this.rowtagName != null) {
                    nodeList = document.getElementsByTagName(this.rowtagName);
                    if (this.ignoreCase && (nodeList == null || nodeList.getLength() == 0)) {
                        nodeList = document.getDocumentElement().getChildNodes();
                    }
                    bl = true;
                } else {
                    nodeList = document.getDocumentElement().getChildNodes();
                }
                if (nodeList == null || nodeList.getLength() == 0) {
                    throw new OracleXMLSQLException(msg.getMessage0("XSUE-0210"));
                }
                if (this.collectTimingInfo) {
                    this.tim.start("modifyNodeVal ----", 0);
                }
                int n3 = this.saveNodes(nodeList, bl, n);
                if (this.collectTimingInfo) {
                    this.tim.stop();
                }
                n2 = n3;
                Object var5_9 = null;
            }
            catch (OracleXMLSQLException oracleXMLSQLException) {
                throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            this.cleanLobList();
            return n2;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.cleanLobList();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int saveNodes(NodeList nodeList, boolean bl, int n) throws SQLException, ParseException, IOException {
        int n2;
        int n3 = bl ? nodeList.getLength() : 1;
        NodeList nodeList2 = null;
        if (this.colNames == null || this.colBindPos == null) {
            this.getTableMetaData();
        }
        if (this.keyHash == null && this.keyColNames != null) {
            this.keyHash = this.createHashFromStrArray(this.keyColNames, "XSUE-0202");
            this.keyHashValid = true;
        } else if (!this.keyHashValid) {
            this.validateColHash(this.keyHash, "XSUE-0202");
        }
        if (this.updHash == null && this.updColNames != null) {
            this.updHash = this.createHashFromStrArray(this.updColNames, "XSUE-0203");
            this.updHashValid = true;
        } else if (!this.updHashValid) {
            this.validateColHash(this.updHash, "XSUE-0202");
        }
        Hashtable[] hashtableArray = new Hashtable[1];
        OraclePreparedStatement oraclePreparedStatement = this.createStmt(n, null, hashtableArray);
        boolean bl2 = this.conn.getAutoCommit();
        this.conn.setAutoCommit(false);
        int n4 = n2 = bl2 ? this.batchSize : this.commitBatch;
        if (oraclePreparedStatement != null) {
            oraclePreparedStatement.setExecuteBatch(this.batchSize);
        }
        if (this.setSavePt == null || this.rollbackToSavePt == null) {
            this.createSavePoint();
        }
        this.setSavePt.execute();
        int n5 = 0;
        boolean bl3 = false;
        try {
            try {
                int n6 = 0;
                while (true) {
                    block33: {
                        block34: {
                            block32: {
                                if (n6 >= n3) {
                                    if (oraclePreparedStatement != null) {
                                        oraclePreparedStatement.sendBatch();
                                    }
                                    break;
                                }
                                if (!bl) break block32;
                                if (nodeList.item(n6).getNodeName().startsWith("#", 0)) break block33;
                                nodeList2 = nodeList.item(n6).getChildNodes();
                                break block34;
                            }
                            nodeList2 = nodeList;
                        }
                        this.saveNode(oraclePreparedStatement, hashtableArray[0], nodeList2, n);
                        if (n2 > 0 && (n5 + 1) % n2 == 0) {
                            this.conn.commit();
                            this.cleanLobList();
                            bl3 = true;
                        }
                        ++n5;
                    }
                    ++n6;
                }
            }
            catch (Exception exception) {
                String string;
                int n7;
                if (bl3) {
                    this.conn.rollback();
                    n7 = n5 / n2 * n2;
                } else {
                    n7 = 0;
                    if (this.rollbackToSavePt != null) {
                        this.rollbackToSavePt.execute();
                    }
                }
                String string2 = String.valueOf(exception instanceof OracleXMLSQLException ? " " : String.valueOf(exception.getClass().getName()) + ":") + (exception.getMessage() == null ? "" : exception.getMessage());
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(String.valueOf(n5)));
                if (n7 > 0) {
                    string = msg.getMessage1("XSUE-0212", String.valueOf(n7));
                    throw new OracleXMLSQLException(msg.getMessage2("XSUE-0211", string2, stringBuffer.append(string).toString()));
                }
                string = msg.getMessage0("XSUE-0213");
                throw new OracleXMLSQLException(msg.getMessage2("XSUE-0211", string2, stringBuffer.append(string).toString()));
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            switch (n) {
                case 1: {
                    this.insStmt = oraclePreparedStatement;
                    this.insBindPos = hashtableArray[0];
                    break;
                }
                case 2: {
                    this.updStmt = oraclePreparedStatement;
                    this.updBindPos = hashtableArray[0];
                    break;
                }
                case 3: {
                    this.delStmt = oraclePreparedStatement;
                    this.delBindPos = hashtableArray[0];
                    break;
                }
            }
            oraclePreparedStatement = null;
            hashtableArray = null;
            this.cleanLobList();
            this.conn.setAutoCommit(bl2);
            throw throwable;
        }
        switch (n) {
            case 1: {
                this.insStmt = oraclePreparedStatement;
                this.insBindPos = hashtableArray[0];
                break;
            }
            case 2: {
                this.updStmt = oraclePreparedStatement;
                this.updBindPos = hashtableArray[0];
                break;
            }
            case 3: {
                this.delStmt = oraclePreparedStatement;
                this.delBindPos = hashtableArray[0];
                break;
            }
        }
        oraclePreparedStatement = null;
        hashtableArray = null;
        this.cleanLobList();
        this.conn.setAutoCommit(bl2);
        if (n2 <= 0) return n5;
        this.conn.commit();
        return n5;
    }

    private void saveNode(OraclePreparedStatement oraclePreparedStatement, Hashtable hashtable, NodeList nodeList, int n) throws Exception {
        block7: {
            if (hashtable != null) {
                this.saveNodeVal(oraclePreparedStatement, hashtable, nodeList);
                return;
            }
            oraclePreparedStatement = null;
            try {
                try {
                    Hashtable[] hashtableArray = new Hashtable[1];
                    oraclePreparedStatement = this.createStmt(n, nodeList, hashtableArray);
                    this.saveNodeVal(oraclePreparedStatement, hashtableArray[0], nodeList);
                }
                catch (OracleXMLSQLException oracleXMLSQLException) {
                    throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
                }
                catch (Exception exception) {
                    throw exception;
                }
                Object var6_8 = null;
                if (oraclePreparedStatement == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (oraclePreparedStatement != null) {
                    oraclePreparedStatement.close();
                }
                oraclePreparedStatement = null;
                hashtable = null;
                throw throwable;
            }
            oraclePreparedStatement.close();
        }
        oraclePreparedStatement = null;
        hashtable = null;
    }

    private OraclePreparedStatement createStmt(int n, NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        switch (n) {
            case 1: {
                return this.createInsStmt(nodeList, hashtableArray);
            }
            case 2: {
                return this.createUpdStmt(nodeList, hashtableArray);
            }
            case 3: {
                return this.createDelStmt(nodeList, hashtableArray);
            }
        }
        return null;
    }

    private void saveNodeVal(OraclePreparedStatement oraclePreparedStatement, Hashtable hashtable, NodeList nodeList) throws SQLException, ParseException, IOException {
        Integer n;
        Object object;
        int n2;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n2 = this.getColNamesIndex(string);
            object = this.colNames[n2 - 1];
            n = (Integer)hashtable.get(this.ignoreCase ? string.toLowerCase() : string);
            if (this.isOracleSpecificType(((OracleColumnName)object).getColumnType())) {
                oraclePreparedStatement.setNull(n.intValue(), ((OracleColumnName)object).getColumnType(), (String)((OracleColumnName)object).getBaseTypeObj());
                continue;
            }
            oraclePreparedStatement.setNull(n.intValue(), ((OracleColumnName)object).getColumnType());
        }
        int n3 = nodeList.getLength();
        n2 = 0;
        while (n2 < n3) {
            object = nodeList.item(n2);
            String string = object.getNodeName();
            if (!string.startsWith("#", 0)) {
                int n4 = this.getColNamesIndex(string);
                n = (Integer)hashtable.get(this.ignoreCase ? string.toLowerCase() : string);
                if (n != null) {
                    this.setBindValue(oraclePreparedStatement, (Node)object, n4 - 1, n);
                }
            }
            ++n2;
        }
        oraclePreparedStatement.executeUpdate();
    }

    /*
     * Unable to fully structure code
     */
    private CLOB createTempCLOBFromString(String var1_1) throws SQLException, IOException {
        block4: {
            if (this.createClobStmt == null) {
                this.createClobStmt = (OracleCallableStatement)this.conn.prepareCall(" declare x CLOB := null;  begin dbms_lob.createtemporary(x,FALSE,DBMS_LOB.SESSION); ? := x; end;");
                this.createClobStmt.registerOutParameter(1, 2005);
            }
            this.createClobStmt.execute();
            var2_2 = this.createClobStmt.getCLOB(1);
            try {
                var2_2.putString(1L, var1_1);
                break block4;
            }
            catch (SQLException v0) {
                var3_3 = var2_2.getChunkSize();
                var3_3 = var3_3 < 4000 ? 4000 / var3_3 * var3_3 : 4000;
                var4_4 = new char[var3_3];
                var5_5 = 0L;
                var7_6 = 0;
                var8_7 = new StringReader(var1_1);
                var9_8 = var1_1.length();
                ** while ((var7_6 = var8_7.read((char[])var4_4, (int)0, (int)var3_3)) > -1)
            }
lbl-1000:
            // 1 sources

            {
                var2_2.putChars(var5_5 + 1L, var4_4);
                if ((long)var9_8 >= (var5_5 += (long)var7_6) + (long)var3_3) continue;
                var3_3 = var9_8 % var3_3;
                var4_4 = new char[var3_3];
                continue;
            }
lbl26:
            // 1 sources

            var8_7.close();
        }
        return var2_2;
    }

    private BLOB createTempBLOBFromString(String string) throws SQLException, IOException {
        if (this.createBlobStmt == null) {
            this.createBlobStmt = (OracleCallableStatement)this.conn.prepareCall(" declare x BLOB := null;  begin dbms_lob.createtemporary(x,FALSE,DBMS_LOB.SESSION); ? := x; end;");
            this.createBlobStmt.registerOutParameter(1, 2004);
        }
        this.createBlobStmt.execute();
        BLOB bLOB = this.createBlobStmt.getBLOB(1);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(string);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.flush();
        outputStream.close();
        return bLOB;
    }
}

