/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.classgen.CGDocument;
import oracle.xml.classgen.InvalidContentException;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CGNode {
    Element theElement;
    Vector children = null;
    CGNode parent;
    Hashtable m_ids;
    Hashtable m_idrefs;
    CGDocument theDocument = null;
    protected boolean isValidating = true;

    protected CGNode(String string) {
        this.theElement = new XMLElement(string);
    }

    protected void addCDATASection(String string) throws InvalidContentException {
        XMLCDATA xMLCDATA = new XMLCDATA(string);
        this.theElement.appendChild((Node)xMLCDATA);
    }

    void addChild(CGNode cGNode) throws InvalidContentException {
        if (this.isValidating) {
            DTD dTD = this.getDTDNode();
            ElementDecl elementDecl = dTD.findElementDecl(this.theElement.getNodeName());
            Vector vector = elementDecl.expectedElements(this.theElement);
            boolean bl = false;
            if (vector != null) {
                String string = cGNode.theElement.getNodeName();
                String string2 = "Invalid element '" + string + "', expected elements are [";
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = (String)vector.elementAt(n2);
                    string2 = String.valueOf(string2) + string3;
                    if (n2 < n - 1) {
                        string2 = String.valueOf(string2) + ",";
                    }
                    if (string3.equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                string2 = String.valueOf(string2) + ']';
                if (!bl) {
                    throw new InvalidContentException(string2);
                }
            }
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(cGNode);
        cGNode.parent = this;
    }

    protected void addData(String string) throws InvalidContentException {
        if (this.isValidating) {
            if (string.indexOf(38) != -1) {
                throw new InvalidContentException("Illegal character '&' in CharData");
            }
            if (string.indexOf(60) != -1) {
                throw new InvalidContentException("Illegal character '<' in CharData");
            }
        }
        XMLText xMLText = new XMLText(string);
        this.theElement.appendChild((Node)xMLText);
    }

    protected void addNode(CGNode cGNode) throws InvalidContentException {
        Element element = cGNode.theElement;
        this.addChild(cGNode);
        this.theElement.appendChild(element);
    }

    protected CGDocument getCGDocument() {
        if (this.theDocument == null && this.parent != null) {
            this.theDocument = this.parent.getCGDocument();
        }
        return this.theDocument;
    }

    protected abstract DTD getDTDNode();

    protected void setAttribute(String string, String string2) {
        this.theElement.setAttribute(string, string2);
    }

    public void setDocument(CGDocument cGDocument) {
        this.theDocument = cGDocument;
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CGNode cGNode = (CGNode)enumeration.nextElement();
                cGNode.setDocument(cGDocument);
            }
        }
    }

    protected void storeID(String string, String string2) {
        if (this.m_ids == null) {
            this.m_ids = new Hashtable();
        }
        this.m_ids.put(string, string2);
    }

    protected void storeIDREF(String string, String string2) {
        if (this.m_idrefs == null) {
            this.m_idrefs = new Hashtable();
        }
        this.m_idrefs.put(string, string2);
    }

    protected boolean validEntity(String string) {
        return this.verifyEntity(string, this.getDTDNode());
    }

    protected boolean validID(String string) {
        char c = string.charAt(0);
        if (Character.isLetter(c) || c == '_' || c == ':') {
            int n = string.length();
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected boolean validNMTOKEN(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void validateContent() throws InvalidContentException {
        DTD dTD = this.getDTDNode();
        ElementDecl elementDecl = dTD.findElementDecl(this.theElement.getNodeName());
        if (!elementDecl.validateContent(this.theElement)) {
            Vector vector = elementDecl.expectedElements(this.theElement);
            String string = vector != null ? "Expected elements are [" + vector.toString() + "]" : "Invalid Content";
            throw new InvalidContentException(string);
        }
    }

    boolean verifyEntity(String string, DTD dTD) {
        return dTD.findEntity(string, false) != null;
    }

    boolean verifyIDREFS() {
        String string;
        Enumeration enumeration;
        if (this.m_ids != null) {
            enumeration = this.m_ids.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.theDocument.storeID(string);
            }
        }
        if (this.children != null) {
            Enumeration enumeration2 = this.children.elements();
            while (enumeration2.hasMoreElements()) {
                CGNode cGNode = (CGNode)enumeration2.nextElement();
                cGNode.verifyIDREFS();
            }
        }
        if (this.m_idrefs != null) {
            enumeration = this.m_idrefs.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (this.theDocument.verifyIDREF(string)) continue;
                this.theDocument.storeIDREF(string);
            }
        }
        return true;
    }
}

