/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.AQ.AQDriver;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQSession;

public class AQDriverManager {
    static Vector drivers;
    private static boolean initialized;
    static OutputStream logstream;
    static PrintWriter pstream;
    static boolean cache_stmts;
    static boolean enable_jni;

    static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AQDriverManager.loadInitialDrivers();
    }

    /*
     * Unable to fully structure code
     */
    private static void loadInitialDrivers() {
        try {
            in_drivers = System.getProperty("aq.drivers");
        }
        catch (Exception v0) {
            in_drivers = null;
        }
        if (in_drivers != null) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            x = in_drivers.indexOf(58);
            if (x < 0) {
                driver = in_drivers;
                in_drivers = "";
            } else {
                driver = in_drivers.substring(0, x);
                in_drivers = in_drivers.substring(x + 1);
            }
            if (driver.length() == 0) continue;
            try {
                AQOracleDebug.println("DriverManager.Initialize: loading " + driver);
                Class.forName(driver);
                continue;
            }
            catch (Exception ex) {
                AQOracleDebug.println("DriverManager.Initialize: load failed: " + ex);
            }
lbl23:
            // 4 sources

            ** while (in_drivers.length() != 0)
        }
lbl24:
        // 1 sources

    }

    private AQDriverManager() {
    }

    public static void registerDriver(AQDriver aq_driver) {
        if (!initialized) {
            AQDriverManager.initialize();
        }
        drivers.addElement(aq_driver);
        AQOracleDebug.trace(4, "AQDriverManager.registerDriver", "Registered driver: " + aq_driver.toString());
    }

    public static Vector getDrivers() {
        return drivers;
    }

    public static synchronized AQSession createAQSession(Object conn) throws AQException {
        int i = 0;
        AQSession aq_sess = null;
        AQDriver curr_drv = null;
        boolean use_drv = false;
        Vector dr = AQDriverManager.getDrivers();
        if (!initialized) {
            AQDriverManager.initialize();
        }
        if (drivers == null || drivers.size() == 0) {
            if (drivers.size() == 0) {
                throw new AQException(0, "No AQ drivers registered");
            }
        } else {
            try {
                i = 0;
                while (i < drivers.size()) {
                    use_drv = false;
                    curr_drv = (AQDriver)drivers.elementAt(i);
                    try {
                        use_drv = curr_drv.acceptsObject(conn);
                    }
                    catch (Exception exception) {}
                    if (use_drv) {
                        aq_sess = curr_drv.createAQSession(conn);
                        break;
                    }
                    ++i;
                }
                if (!use_drv) {
                    throw new AQException(0, "Cannot open connection - invalid conn");
                }
            }
            catch (Exception exc2) {
                throw new AQException(0, exc2.getMessage(), exc2);
            }
        }
        return aq_sess;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream output_stream) {
        logstream = output_stream;
        pstream = new PrintWriter(logstream);
    }

    static PrintWriter getPrintWriter() {
        return pstream;
    }

    public static boolean isStmtCachingEnabled() {
        return cache_stmts;
    }

    public static void setCacheStmtFlag(boolean value) {
        cache_stmts = value;
    }

    public static void enableOciAQ() {
        enable_jni = true;
    }

    public static void disableOciAQ() {
        enable_jni = false;
    }

    public static boolean isOciAQEnabled() {
        return enable_jni;
    }

    static {
        logstream = System.err;
        pstream = new PrintWriter(logstream);
        cache_stmts = true;
        enable_jni = true;
        drivers = new Vector();
    }
}

