/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.util.Date;
import java.util.Vector;
import oracle.AQ.AQAgent;
import oracle.AQ.AQException;
import oracle.AQ.AQUtil;

public class AQMessageProperty {
    public static final int DELAY_NONE = 0;
    public static final int EXPIRATION_NEVER = -1;
    public static final int STATE_READY = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_PROCESSED = 2;
    public static final int STATE_EXPIRED = 3;
    static final int DEFAULT_PRIORITY = 1;
    static final int DEFAULT_DELAY = 0;
    static final int DEFAULT_EXPIRATION = -1;
    private int m_priority = 1;
    private int m_delay = 0;
    private int m_expiration = -1;
    private String corrid = null;
    private int m_attempts = 0;
    private Vector recp_list = new Vector(30);
    private AQAgent m_sender = null;
    private byte[] orig_m_id = null;
    private String exc_queue = null;
    private int m_state = -1;
    private Date enq_time = null;

    public int getPriority() throws AQException {
        return this.m_priority;
    }

    public void setPriority(int priority) throws AQException {
        this.m_priority = priority;
    }

    public int getDelay() throws AQException {
        return this.m_delay;
    }

    public void setDelay(int delay) throws AQException {
        this.m_delay = delay;
    }

    public int getExpiration() throws AQException {
        return this.m_expiration;
    }

    public void setExpiration(int expiration) throws AQException {
        this.m_expiration = expiration;
    }

    public String getCorrelation() throws AQException {
        return this.corrid;
    }

    public void setCorrelation(String correlation) throws AQException {
        this.corrid = correlation;
    }

    public int getAttempts() throws AQException {
        return this.m_attempts;
    }

    void setAttempts(int attempts) throws AQException {
        this.m_attempts = attempts;
    }

    public Vector getRecipientList() throws AQException {
        return this.recp_list;
    }

    public void setRecipientList(Vector r_list) throws AQException {
        this.recp_list = r_list;
    }

    public byte[] getOrigMessageId() throws AQException {
        return this.orig_m_id;
    }

    void setOrigMessageId(byte[] orig_msg_id) throws AQException {
        this.orig_m_id = orig_msg_id;
    }

    public AQAgent getSender() throws AQException {
        return this.m_sender;
    }

    public void setSender(AQAgent sender) throws AQException {
        this.m_sender = sender;
    }

    public String getExceptionQueue() throws AQException {
        return this.exc_queue;
    }

    public void setExceptionQueue(String queue) throws AQException {
        this.exc_queue = queue;
    }

    public Date getEnqueueTime() throws AQException {
        return this.enq_time;
    }

    void setEnqueueTime(Date enqueue_time) throws AQException {
        this.enq_time = enqueue_time;
    }

    public int getState() throws AQException {
        return this.m_state;
    }

    void setState(int state) throws AQException {
        if (state != 0 && state != 1 && state != 2 && state != 3) {
            throw new AQException(0, "Invalid state");
        }
        this.m_state = state;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        buf.append("[AQMessageProperty]");
        buf.append("\n  message_priority : " + this.m_priority);
        buf.append("\n  delay            : " + this.m_delay);
        buf.append("\n  expiration       : " + this.m_expiration);
        buf.append("\n  correlation      : " + this.corrid);
        buf.append("\n  attempts         : " + this.m_attempts);
        if (this.recp_list != null) {
            buf.append("Recipients [" + this.recp_list.size() + "]");
            i = 0;
            while (i < this.recp_list.size()) {
                if ((AQAgent)this.recp_list.elementAt(i) != null) {
                    buf.append(((AQAgent)this.recp_list.elementAt(i)).toString());
                }
                ++i;
            }
        }
        if (this.m_sender != null) {
            buf.append("\n  sender           : \n");
            buf.append(this.m_sender.toString());
        } else {
            buf.append("\n  sender           : null");
        }
        buf.append("\n  original msg id  : " + AQUtil.ByteArraytoString(this.orig_m_id));
        buf.append("\n  exception queue  : " + this.exc_queue);
        buf.append("\n  message state    : ");
        if (this.m_state == 0) {
            buf.append("READY");
        } else if (this.m_state == 1) {
            buf.append("WAITING");
        } else if (this.m_state == 2) {
            buf.append("PROCESSED");
        } else if (this.m_state == 3) {
            buf.append("EXPIRED");
        } else {
            buf.append("Unknown state");
        }
        return buf.toString();
    }
}

