/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;
import oracle.AQ.AQMessage;
import oracle.AQ.AQMessageProperty;
import oracle.AQ.AQObjectPayload;
import oracle.AQ.AQOracleObjectPayload;
import oracle.AQ.AQOracleRawPayload;
import oracle.AQ.AQRawPayload;
import oracle.AQ.AQUtil;

public class AQOracleMessage
implements AQMessage {
    private byte[] msg_id;
    private int pload_type;
    private AQOracleRawPayload r_payload;
    private AQOracleObjectPayload o_payload;
    private AQMessageProperty m_property;

    AQOracleMessage(int payload_type, AQOracleRawPayload raw_payload, AQMessageProperty property) {
        if (payload_type != 2) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.RAW_TYPE_PAYLOAD");
        }
        this.pload_type = payload_type;
        this.r_payload = raw_payload;
        this.o_payload = null;
        this.m_property = property;
        this.msg_id = null;
    }

    AQOracleMessage(int payload_type, AQOracleObjectPayload obj_payload, AQMessageProperty property) {
        if (payload_type != 1) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.OBJECT_TYPE_PAYLOAD");
        }
        this.pload_type = payload_type;
        this.o_payload = obj_payload;
        this.r_payload = null;
        this.m_property = property;
        this.msg_id = null;
    }

    AQOracleMessage(int payload_type) {
        if (payload_type != 1 && payload_type != 2) {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = payload_type;
        this.o_payload = null;
        this.r_payload = null;
        this.m_property = null;
        this.msg_id = null;
    }

    public byte[] getMessageId() throws AQException {
        return this.msg_id;
    }

    void setMessageId(byte[] message_id) throws AQException {
        this.msg_id = message_id;
    }

    public AQRawPayload getRawPayload() throws AQException {
        return this.r_payload;
    }

    public void setRawPayload(AQRawPayload message_payload) throws AQException {
        Class<?> cl = null;
        if (this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if (message_payload != null) {
            try {
                cl = Class.forName("oracle.AQ.AQOracleRawPayload");
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(109);
            }
            if (cl.isInstance(message_payload)) {
                this.r_payload = (AQOracleRawPayload)message_payload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.r_payload = null;
        }
    }

    public AQObjectPayload getObjectPayload() throws AQException {
        return this.o_payload;
    }

    public void setObjectPayload(AQObjectPayload message_payload) throws AQException {
        Class<?> cl = null;
        if (this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if (message_payload != null) {
            try {
                cl = Class.forName("oracle.AQ.AQOracleObjectPayload");
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(109);
            }
            if (cl.isInstance(message_payload)) {
                this.o_payload = (AQOracleObjectPayload)message_payload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.o_payload = null;
        }
    }

    public AQMessageProperty getMessageProperty() throws AQException {
        return this.m_property;
    }

    public void setMessageProperty(AQMessageProperty property) throws AQException {
        this.m_property = property;
    }
}

