/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import oracle.AQ.AQAgent;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQEnqueueOption;
import oracle.AQ.AQException;
import oracle.AQ.AQMessage;
import oracle.AQ.AQMessageProperty;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleMessage;
import oracle.AQ.AQOracleObjectPayload;
import oracle.AQ.AQOracleRawPayload;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc2.SQLData;
import oracle.jms.AQjmsSession;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;

public class AQOracleQueue
implements AQQueue {
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    AQQueueProperty property;
    private AQOracleSession aq_sess;
    private CallableStatement alterq_stmt;
    private CallableStatement rems_stmt;
    private CallableStatement adds_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement allq_stmt;
    private CallableStatement allqo_stmt;
    private CallableStatement alprop_stmt;
    private CallableStatement unscprop_stmt;
    private CallableStatement enprop_stmt;
    private CallableStatement disprop_stmt;
    private OracleCallableStatement enqr_norcp_stmt;
    private OracleCallableStatement enqr_rcp_stmt;
    private OracleCallableStatement enqo_norcp_stmt;
    private OracleCallableStatement enqo_rcp_stmt;
    private OracleCallableStatement deq_raw_stmt;
    private OracleCallableStatement deq_obj_stmt;

    AQOracleQueue(AQOracleSession conn, String q_owner, String q_name, String q_table, AQQueueProperty q_prop, int payload_type, String payload_object_type) {
        this.owner = q_owner;
        this.table = q_table;
        this.aq_sess = conn;
        if (q_name == null || q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        } else {
            this.name = q_name;
        }
        if (q_prop == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = q_prop;
        }
        if (payload_type == 2) {
            this.p_data_type = null;
        } else if (payload_type == 1) {
            if (payload_object_type == null || payload_object_type.equals("")) {
                AQUtil.throwAQEx(122, "payload object type must be specified");
            }
            this.p_data_type = payload_object_type;
        } else {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = payload_type;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
    }

    public AQOracleQueue(AQjmsSession jms_session, String q_owner, String q_name, String q_table, AQQueueProperty q_prop, int payload_type, String payload_object_type) throws JMSException, AQException {
        Connection db_conn = null;
        this.owner = q_owner;
        this.table = q_table;
        if (q_name == null || q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        } else {
            this.name = q_name;
        }
        db_conn = jms_session.getDBConnection();
        if (q_prop == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = q_prop;
        }
        this.aq_sess = new AQOracleSession(db_conn);
        if (payload_type == 2) {
            AQUtil.throwAQEx(193);
        }
        if (payload_object_type == null || payload_object_type.equals("")) {
            AQUtil.throwAQEx(122, "payload object type must be specified");
        }
        this.pload_type = payload_type;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
    }

    public String getOwner() throws AQException {
        return this.owner;
    }

    void setOwner(String q_owner) throws AQException {
        this.owner = q_owner;
    }

    public String getName() throws AQException {
        return this.name;
    }

    void setName(String q_name) throws AQException {
        this.name = q_name;
    }

    public AQSession getAQSession() {
        return this.aq_sess;
    }

    private void setAQSession(AQOracleSession sess) {
        if (sess != null) {
            this.aq_sess = sess;
        } else {
            AQUtil.throwAQEx(122, "Session cannot be null");
        }
    }

    public int getPayloadType() throws AQException {
        return this.pload_type;
    }

    void setPayloadType(int payload_type) throws AQException {
        this.pload_type = payload_type;
    }

    public String getObjectPayloadType() throws AQException {
        return this.p_data_type;
    }

    public String getQueueTableName() throws AQException {
        return this.table;
    }

    void setQueueTableName(String q_table) throws AQException {
        this.table = q_table;
    }

    public AQQueueProperty getProperty() throws AQException {
        Connection db_conn = null;
        ResultSet rset = null;
        String ret_time = "";
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                if (this.owner == null || this.owner.equals("")) {
                    if (this.allq_stmt == null) {
                        this.allq_stmt = db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, this.name.toUpperCase());
                    rset = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        this.allqo_stmt = db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, this.owner.toUpperCase());
                    this.allqo_stmt.setString(2, this.name.toUpperCase());
                    this.allqo_stmt.setString(3, this.owner.toUpperCase());
                    rset = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-1", sqlex);
                if (this.owner == null || this.owner.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception exception) {}
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception exception) {}
                    this.allqo_stmt = null;
                }
                throw sqlex;
            }
            if (rset.next()) {
                if (rset.getString(4).equals("EXCEPTION_QUEUE")) {
                    this.property.setQueueType(1);
                }
                this.property.setMaxRetries(rset.getInt(5));
                this.property.setRetryInterval(rset.getInt(6));
                ret_time = rset.getString(7).trim();
                if (ret_time.equals("FOREVER")) {
                    this.property.setRetentionTime(-1.0);
                } else {
                    this.property.setRetentionTime(rset.getDouble(7));
                }
                this.property.setComment(rset.getString(8));
            } else if (this.owner == null || this.owner.equals("")) {
                AQUtil.throwAQEx(190, this.name);
            } else {
                AQUtil.throwAQEx(190, String.valueOf(this.owner) + "." + this.name);
            }
            if (rset.next()) {
                AQUtil.throwAQEx(182);
            }
            try {
                rset.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-2", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        return this.property;
    }

    void setProperty(AQQueueProperty q_property) throws AQException {
        this.property = q_property;
    }

    public void start(boolean enqueue, boolean dequeue) throws AQException {
        Statement startq_stmt = null;
        Connection db_conn = null;
        String q_name = "";
        String eq_flag = "true";
        String dq_flag = "true";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(122, "name invalid");
        }
        q_name = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!enqueue) {
                eq_flag = "false";
            }
            if (!dequeue) {
                dq_flag = "false";
            }
            startq_stmt = db_conn.prepareCall("begin dbms_aqadm.start_queue(queue_name => ?, enqueue => " + eq_flag + ", dequeue => " + dq_flag + "); end;");
            startq_stmt.setString(1, q_name);
            startq_stmt.execute();
            try {
                startq_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.start", sqlex);
            try {
                startq_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void start() throws AQException {
        this.start(true, true);
    }

    public void startEnqueue() throws AQException {
        this.start(true, false);
    }

    public void startDequeue() throws AQException {
        this.start(false, true);
    }

    public void stop(boolean enqueue, boolean dequeue, boolean wait) throws AQException {
        Statement stopq_stmt = null;
        Connection db_conn = null;
        String q_name = "";
        String eq_flag = "true";
        String dq_flag = "true";
        String wt_flag = "false";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(122, "invalid name");
        }
        q_name = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!enqueue) {
                eq_flag = "false";
            }
            if (!dequeue) {
                dq_flag = "false";
            }
            if (wait) {
                wt_flag = "true";
            }
            stopq_stmt = db_conn.prepareCall("begin dbms_aqadm.stop_queue(queue_name => ?, enqueue => " + eq_flag + ", dequeue => " + dq_flag + ", wait => " + wt_flag + "); end;");
            stopq_stmt.setString(1, q_name);
            stopq_stmt.execute();
            try {
                stopq_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.stop", sqlex);
            try {
                stopq_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void stop(boolean wait) throws AQException {
        this.stop(true, true, wait);
    }

    public void stopEnqueue(boolean wait) throws AQException {
        this.stop(true, false, wait);
    }

    public void stopDequeue(boolean wait) throws AQException {
        this.stop(false, true, wait);
    }

    public void alterQueue(AQQueueProperty q_property) throws AQException {
        CallableStatement aq_stmt = null;
        Connection db_conn = null;
        Object new_queue = null;
        String q_name = "";
        String ac_flag = "true";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!q_property.isAutoCommitEnabled()) {
                ac_flag = "false";
                aq_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => false, comment => ?); end;");
            } else {
                if (this.alterq_stmt != null) {
                    this.alterq_stmt.clearParameters();
                } else {
                    this.alterq_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => true, comment => ?); end;");
                }
                aq_stmt = this.alterq_stmt;
            }
            aq_stmt.setString(1, q_name);
            if (q_property.max_retries != null) {
                ((OracleCallableStatement)aq_stmt).setObject(2, (Object)q_property.max_retries, 4);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(2, 4);
            }
            if (q_property.retry_interval != null) {
                ((OracleCallableStatement)aq_stmt).setObject(3, (Object)q_property.retry_interval, 8);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(3, 8);
            }
            if (q_property.retention_time != null) {
                ((OracleCallableStatement)aq_stmt).setObject(4, (Object)q_property.retention_time, 8);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(4, 8);
            }
            aq_stmt.setString(5, q_property.getComment());
            aq_stmt.execute();
            if (!q_property.equals(this.property)) {
                this.property.setMaxRetries(q_property.getMaxRetries());
                this.property.setRetryInterval(q_property.getRetryInterval());
                this.property.setRetentionTime(q_property.getRetentionTime());
                this.property.setComment(q_property.getComment());
            }
        }
        catch (SQLException sqlex) {
            if (ac_flag.equals("true")) {
                try {
                    this.alterq_stmt.close();
                }
                catch (Exception exception) {}
                this.alterq_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterQueue", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public AQMessage createMessage() throws AQException {
        AQOracleMessage message = null;
        AQOracleRawPayload r_payload = null;
        AQOracleObjectPayload o_payload = null;
        AQMessageProperty property = null;
        property = new AQMessageProperty();
        if (this.pload_type == 2) {
            r_payload = new AQOracleRawPayload();
            message = new AQOracleMessage(this.pload_type, r_payload, property);
        } else if (this.pload_type == 1) {
            o_payload = new AQOracleObjectPayload();
            message = new AQOracleMessage(this.pload_type, o_payload, property);
        } else {
            AQUtil.throwAQEx(129);
        }
        return message;
    }

    public void drop() throws AQException {
        Statement dq_stmt = null;
        Connection db_conn = null;
        String q_name = "";
        boolean auto_commit = true;
        String ac_flag = "true";
        q_name = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!auto_commit) {
                ac_flag = "false";
            }
            dq_stmt = db_conn.prepareCall("begin dbms_aqadm.drop_queue(queue_name => ?, auto_commit =>" + ac_flag + "); end;");
            dq_stmt.setString(1, q_name);
            dq_stmt.execute();
            try {
                dq_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dropQueue", sqlex);
            try {
                dq_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
        this.aq_sess = null;
    }

    public byte[] enqueue(AQEnqueueOption enq_option, AQMessage message) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        OracleCallableStatement enq_stmt = null;
        ResultSet rset = null;
        AQMessageProperty property = null;
        AQAgent sender = null;
        AQOracleRawPayload raw_pload = null;
        AQOracleObjectPayload obj_pload = null;
        byte[] b_array = null;
        byte[] msg_id = null;
        String str_mid = null;
        Integer visib = null;
        Integer prior = null;
        Integer delay = null;
        Integer expire = null;
        Integer p_type = null;
        Hashtable map = null;
        Vector recp_list = null;
        int num_recps = 0;
        ARRAY recp_array = null;
        if (message == null) {
            AQUtil.throwAQEx(133);
        }
        if (enq_option == null) {
            AQUtil.throwAQEx(176);
        }
        q_name = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        property = message.getMessageProperty();
        sender = property.getSender();
        try {
            db_conn = this.aq_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception ex2) {
            AQUtil.throwAQEx(146, ex2);
        }
        raw_pload = (AQOracleRawPayload)message.getRawPayload();
        if (raw_pload != null && this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if ((obj_pload = (AQOracleObjectPayload)message.getObjectPayload()) != null && this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if ((recp_list = property.getRecipientList()) != null && !recp_list.isEmpty()) {
            num_recps = recp_list.size();
        }
        try {
            if (raw_pload != null) {
                enq_stmt = this.getEnqRawStmt(num_recps, db_conn);
                b_array = raw_pload.getBytes();
                enq_stmt.setBytes(15, b_array);
                p_type = new Integer(2);
            } else if (obj_pload != null) {
                enq_stmt = this.getEnqObjStmt(num_recps, db_conn);
                if (obj_pload.getCustomDatum() != null) {
                    enq_stmt.setCustomDatum(15, obj_pload.getCustomDatum());
                } else if (obj_pload.getSqlData() != null) {
                    Class<?> ocl = obj_pload.getClass();
                    map.put(this.p_data_type, ocl.getName());
                    enq_stmt.setObject(15, (Object)obj_pload.getSqlData(), 2002);
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.enqueue-3", "Null object payload");
                    AQUtil.throwAQEx(104);
                }
                p_type = new Integer(1);
            } else {
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue-2", "Null payload");
                AQUtil.throwAQEx(104);
            }
            enq_stmt.setString(1, q_name);
            if (sender != null) {
                enq_stmt.setString(2, sender.getName());
                enq_stmt.setString(3, sender.getAddress());
                enq_stmt.setInt(4, sender.getProtocol());
            } else {
                enq_stmt.setString(2, null);
                enq_stmt.setString(3, null);
                enq_stmt.setInt(4, 0);
            }
            if (property.getOrigMessageId() != null) {
                enq_stmt.setObject(5, (Object)property.getOrigMessageId(), -2);
            } else {
                enq_stmt.setNull(5, -2);
            }
            enq_stmt.setString(6, property.getCorrelation());
            visib = new Integer(enq_option.getVisibility());
            enq_stmt.setObject(7, (Object)visib, 4);
            prior = new Integer(property.getPriority());
            enq_stmt.setObject(8, (Object)prior, 4);
            delay = new Integer(property.getDelay());
            enq_stmt.setObject(9, (Object)delay, 4);
            expire = new Integer(property.getExpiration());
            enq_stmt.setObject(10, (Object)expire, 4);
            if (enq_option.getRelMessageId() == null) {
                enq_stmt.setNull(11, -2);
            } else {
                enq_stmt.setBytes(11, enq_option.getRelMessageId());
            }
            if (enq_option.seq_deviation == null) {
                enq_stmt.setNull(12, 2);
            } else {
                enq_stmt.setObject(12, (Object)enq_option.seq_deviation, 4);
            }
            enq_stmt.setString(13, property.getExceptionQueue());
            enq_stmt.setObject(14, (Object)p_type, 4);
            enq_stmt.registerOutParameter(16, -2);
            if (num_recps > 0) {
                recp_array = this.createRecpArrayfromVector(recp_list);
                enq_stmt.setObject(17, (Object)recp_array, 2003);
            }
            rset = enq_stmt.executeQuery();
            msg_id = enq_stmt.getBytes(16);
            ((AQOracleMessage)message).setMessageId(msg_id);
            if (AQOracleDebug.DEBUG) {
                str_mid = enq_stmt.getString(16);
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue", str_mid);
            }
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(enq_stmt);
            }
            rset.close();
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-4", aqex);
            this.destroyStmt(enq_stmt);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-5", sqlex);
            this.destroyStmt(enq_stmt);
            throw new AQOracleSQLException(sqlex);
        }
        return msg_id;
    }

    public AQMessage dequeue(AQDequeueOption deq_option) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(deq_option, null, null, false);
    }

    public AQMessage dequeue(AQDequeueOption deq_option, CustomDatumFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, false);
    }

    public AQMessage dequeue(AQDequeueOption deq_option, Class sql_data_cl) throws AQException {
        Class<?> cl = null;
        String cl_name = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (sql_data_cl == null) {
            AQUtil.throwAQEx(169);
        }
        if ((cl_name = sql_data_cl.getName()).equals("oracle.jdbc2.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        try {
            cl = Class.forName("oracle.jdbc2.SQLData");
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(109);
        }
        if (!cl.isAssignableFrom(sql_data_cl)) {
            AQUtil.throwAQEx(191);
        }
        return this.dequeue(deq_option, null, sql_data_cl, false);
    }

    AQMessage dequeue(AQDequeueOption deq_option, Object payload_fact, Class sql_data_cl, boolean get_recpl) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        OracleCallableStatement deq_stmt = null;
        Object sel_stmt = null;
        byte[] b_array = null;
        byte[] msg_id = null;
        Object sel_rset = null;
        ResultSet deq_rset = null;
        AQMessageProperty property = null;
        AQOracleMessage message = null;
        AQAgent sender = null;
        AQOracleRawPayload rawpayload = null;
        AQOracleObjectPayload objpayload = null;
        Integer navig = null;
        Integer visib = null;
        Integer dq_mode = null;
        Integer wt_mode = null;
        Integer p_type = null;
        String s_name = null;
        Timestamp etime = null;
        Hashtable map = null;
        long secs = 0L;
        long msecs = 0L;
        CustomDatum obj_cust_data = null;
        SQLData obj_sql_data = null;
        Object obj_str_data = null;
        ARRAY recp_list = null;
        AQAgent[] agent_list = null;
        Vector<AQAgent> recp_vec = null;
        int idx = 0;
        if (deq_option == null) {
            AQUtil.throwAQEx(175);
        }
        q_name = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        if (this.pload_type == 1 && payload_fact == null && sql_data_cl == null) {
            AQUtil.throwAQEx(167);
        }
        if (payload_fact != null && sql_data_cl != null) {
            AQUtil.throwAQEx(168);
        }
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex2) {
                AQUtil.throwAQEx(146, ex2);
            }
            if (this.pload_type == 2) {
                deq_stmt = this.getDeqRawStmt(db_conn);
                p_type = new Integer(2);
                deq_stmt.registerOutParameter(24, -2);
            } else if (this.pload_type == 1) {
                deq_stmt = this.getDeqObjStmt(db_conn);
                p_type = new Integer(1);
                deq_stmt.registerOutParameter(24, -2);
                deq_stmt.registerOutParameter(25, 2002, this.p_data_type);
            } else {
                AQUtil.throwAQEx(129);
            }
            deq_stmt.setString(1, q_name);
            deq_stmt.setString(2, deq_option.getConsumerName());
            if (deq_option.getMessageId() == null) {
                deq_stmt.setNull(3, -2);
            } else {
                deq_stmt.setBytes(3, deq_option.getMessageId());
            }
            deq_stmt.setString(4, deq_option.getCorrelation());
            dq_mode = new Integer(deq_option.getDequeueMode());
            deq_stmt.setObject(5, (Object)dq_mode, 4);
            navig = new Integer(deq_option.getNavigationMode());
            deq_stmt.setObject(6, (Object)navig, 4);
            visib = new Integer(deq_option.getVisibility());
            deq_stmt.setObject(7, (Object)visib, 4);
            wt_mode = new Integer(deq_option.getWaitTime());
            deq_stmt.setObject(8, (Object)wt_mode, 4);
            deq_stmt.registerOutParameter(9, 91);
            deq_stmt.registerOutParameter(10, 4);
            deq_stmt.registerOutParameter(11, -2);
            deq_stmt.registerOutParameter(12, 12);
            deq_stmt.registerOutParameter(13, 4);
            deq_stmt.registerOutParameter(14, 4);
            deq_stmt.registerOutParameter(15, 4);
            deq_stmt.registerOutParameter(16, 4);
            deq_stmt.registerOutParameter(17, 12);
            deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
            deq_stmt.registerOutParameter(19, 12);
            deq_stmt.registerOutParameter(20, 12);
            deq_stmt.registerOutParameter(21, 4);
            deq_stmt.registerOutParameter(22, -2);
            deq_stmt.setObject(23, (Object)p_type, 4);
            deq_rset = deq_stmt.executeQuery();
            property = new AQMessageProperty();
            etime = deq_stmt.getTimestamp(9);
            secs = ((java.util.Date)etime).getTime();
            msecs = secs + (long)(etime.getNanos() / 1000000);
            java.util.Date dt = new java.util.Date(msecs);
            property.setEnqueueTime(dt);
            property.setState(deq_stmt.getInt(10));
            msg_id = deq_stmt.getBytes(11);
            property.setCorrelation(deq_stmt.getString(12));
            property.setPriority(deq_stmt.getInt(13));
            property.setDelay(deq_stmt.getInt(14));
            property.setExpiration(deq_stmt.getInt(15));
            property.setAttempts(deq_stmt.getInt(16));
            property.setExceptionQueue(deq_stmt.getString(17));
            if (get_recpl && (recp_list = deq_stmt.getARRAY(18)) != null && recp_list.length() > 0) {
                agent_list = this.createAgentListfromSubsArray(recp_list);
                recp_vec = new Vector<AQAgent>(agent_list.length);
                idx = 0;
                while (idx < agent_list.length) {
                    recp_vec.addElement(agent_list[idx]);
                    ++idx;
                }
                property.setRecipientList(recp_vec);
            }
            if ((s_name = deq_stmt.getString(19)) != null && !s_name.equals("")) {
                sender = new AQAgent(s_name, deq_stmt.getString(20), deq_stmt.getInt(21));
                property.setSender(sender);
            }
            property.setOrigMessageId(deq_stmt.getBytes(22));
            if (this.pload_type == 2) {
                b_array = deq_stmt.getBytes(24);
                rawpayload = new AQOracleRawPayload(b_array, b_array.length);
                message = new AQOracleMessage(this.pload_type, rawpayload, property);
            } else {
                if (payload_fact != null) {
                    obj_cust_data = (CustomDatum)deq_stmt.getCustomDatum(25, (CustomDatumFactory)payload_fact);
                    objpayload = new AQOracleObjectPayload(obj_cust_data);
                } else if (sql_data_cl != null) {
                    String cl_name = sql_data_cl.getName();
                    map.put(this.p_data_type, sql_data_cl);
                    obj_sql_data = (SQLData)deq_stmt.getObject(25);
                    objpayload = new AQOracleObjectPayload(obj_sql_data);
                }
                message = new AQOracleMessage(this.pload_type, objpayload, property);
            }
            message.setMessageId(msg_id);
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(deq_stmt);
            }
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-2", aqex);
            this.destroyStmt(deq_stmt);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-3", sqlex);
            this.destroyStmt(deq_stmt);
            throw new AQOracleSQLException(sqlex);
        }
        return message;
    }

    public void addSubscriber(AQAgent subscriber, String rule) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.adds_stmt != null) {
                this.adds_stmt.clearParameters();
            } else {
                this.adds_stmt = db_conn.prepareCall("begin dbms_aqadm.add_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.adds_stmt.setString(1, q_name);
            this.adds_stmt.setObject(2, (Object)agt, 2002);
            this.adds_stmt.setString(3, rule);
            this.adds_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.adds_stmt.close();
            }
            catch (Exception exception) {}
            this.adds_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.addSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void removeSubscriber(AQAgent subscriber) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                this.rems_stmt = db_conn.prepareCall("begin dbms_aqadm.remove_subscriber(queue_name => ?, subscriber => ?); end;");
            }
            this.rems_stmt.setString(1, q_name);
            this.rems_stmt.setObject(2, (Object)agt, 2002);
            this.rems_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.rems_stmt.close();
            }
            catch (Exception exception) {}
            this.rems_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.removeSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void alterSubscriber(AQAgent subscriber, String rule) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                this.alts_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.alts_stmt.setString(1, q_name);
            this.alts_stmt.setObject(2, (Object)agt, 2002);
            this.alts_stmt.setString(3, rule);
            this.alts_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {}
            this.alts_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public AQAgent[] getSubscribers() throws AQException {
        Connection db_conn = null;
        OracleCallableStatement gsubs_stmt = null;
        Hashtable map = null;
        String q_name = "";
        ARRAY subs_list = null;
        AQAgent[] agent_list = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            gsubs_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_queue_subscribers(?, ?); end;");
            gsubs_stmt.setString(1, q_name);
            gsubs_stmt.registerOutParameter(2, 2003, "SYS.AQ$_SUBSCRIBERS");
            gsubs_stmt.execute();
            subs_list = gsubs_stmt.getARRAY(2);
            if (subs_list != null && subs_list.length() > 0) {
                AQOracleDebug.println("Array is of length: " + subs_list.length());
                AQOracleDebug.println("Array is of type " + subs_list.getSQLTypeName());
                AQOracleDebug.println("Array element is of type code " + subs_list.getBaseType());
                AQOracleDebug.println("Array element is of type name " + subs_list.getBaseTypeName());
                agent_list = this.createAgentListfromSubsArray(subs_list);
            }
            try {
                gsubs_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getSubscribers", sqlex);
            try {
                gsubs_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
        return agent_list;
    }

    public void schedulePropagation(String destination, java.util.Date start_time, Double duration, String next_time, Double latency) throws AQException {
        Connection db_conn = null;
        Statement scprop_stmt = null;
        Date st_time = null;
        String q_name = "";
        Double lat_val = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (start_time != null) {
                st_time = new Date(start_time.getTime());
                scprop_stmt = db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, start_time => ?); end;");
                scprop_stmt.setDate(6, st_time);
            } else {
                scprop_stmt = db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;");
            }
            scprop_stmt.setString(1, q_name);
            scprop_stmt.setString(2, destination);
            if (duration != null) {
                scprop_stmt.setObject(3, duration, 8);
            } else {
                scprop_stmt.setNull(3, 8);
            }
            scprop_stmt.setString(4, next_time);
            if (latency != null) {
                scprop_stmt.setObject(5, latency, 8);
            } else {
                lat_val = new Double(60.0);
                scprop_stmt.setObject(5, lat_val, 8);
            }
            scprop_stmt.execute();
            try {
                scprop_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.schedulePropagation", sqlex);
            try {
                scprop_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void unschedulePropagation(String destination) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.unscprop_stmt != null) {
                this.unscprop_stmt.clearParameters();
            } else {
                this.unscprop_stmt = db_conn.prepareCall("begin dbms_aqadm.unschedule_propagation(queue_name => ?, destination => ?); end;");
            }
            this.unscprop_stmt.setString(1, q_name);
            this.unscprop_stmt.setString(2, destination);
            this.unscprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.unscprop_stmt.close();
            }
            catch (Exception exception) {}
            this.unscprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.unschedulePropagation", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void alterPropagationSchedule(String destination, Double duration, String next_time, Double latency) throws AQException {
        Connection db_conn = null;
        Object st_time = null;
        String q_name = "";
        Double lat_val = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.alprop_stmt != null) {
                this.alprop_stmt.clearParameters();
            } else {
                this.alprop_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_propagation_schedule(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;");
            }
            this.alprop_stmt.setString(1, q_name);
            this.alprop_stmt.setString(2, destination);
            if (duration != null) {
                this.alprop_stmt.setObject(3, (Object)duration, 8);
            } else {
                this.alprop_stmt.setNull(3, 8);
            }
            this.alprop_stmt.setString(4, next_time);
            if (latency != null) {
                this.alprop_stmt.setObject(5, (Object)latency, 8);
            } else {
                lat_val = new Double(60.0);
                this.alprop_stmt.setObject(5, (Object)lat_val, 8);
            }
            this.alprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.alprop_stmt.close();
            }
            catch (Exception exception) {}
            this.alprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterPropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void enablePropagationSchedule(String destination) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.enprop_stmt != null) {
                this.enprop_stmt.clearParameters();
            } else {
                this.enprop_stmt = db_conn.prepareCall("begin dbms_aqadm.enable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.enprop_stmt.setString(1, q_name);
            this.enprop_stmt.setString(2, destination);
            this.enprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.enprop_stmt.close();
            }
            catch (Exception exception) {}
            this.enprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.enablePropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void disablePropagationSchedule(String destination) throws AQException {
        Connection db_conn = null;
        String q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.disprop_stmt != null) {
                this.disprop_stmt.clearParameters();
            } else {
                this.disprop_stmt = db_conn.prepareCall("begin dbms_aqadm.disable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.disprop_stmt.setString(1, q_name);
            this.disprop_stmt.setString(2, destination);
            this.disprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.disprop_stmt.close();
            }
            catch (Exception exception) {}
            this.disprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.disablePropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void grantQueuePrivilege(String privilege, String grantee, boolean grant_option) throws AQException {
        Connection db_conn = null;
        Statement grant_stmt = null;
        String q_name = "";
        String grant_flag = "false";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (grant_option) {
                grant_flag = "true";
            }
            grant_stmt = db_conn.prepareCall("begin dbms_aqadm.grant_queue_privilege(privilege => ?, queue_name => ?, grantee => ?, grant_option => " + grant_flag + "); end;");
            grant_stmt.setString(1, privilege);
            grant_stmt.setString(2, q_name);
            grant_stmt.setString(3, grantee);
            grant_stmt.execute();
            try {
                grant_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.grantQueuePrivilege", sqlex);
            try {
                grant_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void grantQueuePrivilege(String privilege, String grantee) throws AQException {
        this.grantQueuePrivilege(privilege, grantee, false);
    }

    public void revokeQueuePrivilege(String privilege, String grantee) throws AQException {
        Connection db_conn = null;
        CallableStatement revoke_stmt = null;
        String q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : String.valueOf(this.owner) + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            revoke_stmt = db_conn.prepareCall("begin dbms_aqadm.revoke_queue_privilege(privilege => ?, queue_name => ?, grantee => ?); end;");
            revoke_stmt.setString(1, privilege);
            revoke_stmt.setString(2, q_name);
            revoke_stmt.setString(3, grantee);
            revoke_stmt.execute();
            try {
                revoke_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.revokeQueuePrivilege", sqlex);
            try {
                revoke_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
    }

    public byte[] propEnqueue(AQEnqueueOption enq_option, AQMessage message) throws AQException {
        return this.enqueue(enq_option, message);
    }

    public AQMessage propDequeue(AQDequeueOption deq_option) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(deq_option, null, null, true);
    }

    public AQMessage propDequeue(AQDequeueOption deq_option, Class sql_data_cl) throws AQException {
        Class<?> cl = null;
        String cl_name = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (sql_data_cl == null) {
            AQUtil.throwAQEx(169);
        }
        if ((cl_name = sql_data_cl.getName()).equals("oracle.jdbc2.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        try {
            cl = Class.forName("oracle.jdbc2.SQLData");
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(109);
        }
        if (!cl.isAssignableFrom(sql_data_cl)) {
            AQUtil.throwAQEx(191);
        }
        return this.dequeue(deq_option, null, sql_data_cl, true);
    }

    public AQMessage propDequeue(AQDequeueOption deq_option, CustomDatumFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, true);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueue]");
        buf.append("\n  owner            : " + this.owner);
        buf.append("\n  name             : " + this.name);
        buf.append("\n  queue table      : " + this.table);
        if (this.property != null) {
            buf.append("\n" + this.property.toString());
        }
        if (this.pload_type == 2) {
            buf.append("\n  Payload type     : RAW");
        } else if (this.pload_type == 1) {
            buf.append("\n  Payload type     : OBJECT");
        } else {
            buf.append("\n  Payload type     : UNKNOWN");
        }
        buf.append("\n");
        return buf.toString();
    }

    private ARRAY createRecpArrayfromVector(Vector recp_list) throws AQException {
        Connection db_conn = null;
        ArrayDescriptor desc = null;
        Object[] obj_array = null;
        ARRAY recp_array = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        AQAgent agt = null;
        int i = 0;
        if (recp_list == null || recp_list.isEmpty()) {
            AQUtil.throwAQEx(145);
        }
        num_recps = recp_list.size();
        obj_array = new Object[num_recps];
        i = 0;
        while (i < num_recps) {
            agt = (AQAgent)recp_list.elementAt(i);
            ora_agt = new AQOracleAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
            obj_array[i] = ora_agt;
            ++i;
        }
        try {
            db_conn = this.aq_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            desc = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)db_conn);
            recp_array = new ARRAY(desc, db_conn, (Object)obj_array);
        }
        catch (SQLException sqlex) {
            throw new AQOracleSQLException(sqlex);
        }
        return recp_array;
    }

    private AQAgent[] createAgentListfromSubsArray(ARRAY recp_array) throws AQException {
        Connection db_conn = null;
        Object desc = null;
        Object[] values = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        Object agt = null;
        AQAgent[] agt_list = null;
        Hashtable map = null;
        int i = 0;
        try {
            db_conn = this.aq_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            if (recp_array == null || recp_array.length() == 0) {
                AQUtil.throwAQEx(145);
            }
            num_recps = recp_array.length();
            agt_list = new AQAgent[num_recps];
            values = (Object[])recp_array.getArray((Dictionary)map);
        }
        catch (SQLException sqlex) {
            throw new AQOracleSQLException(sqlex);
        }
        i = 0;
        while (i < num_recps) {
            ora_agt = (AQOracleAgent)values[i];
            AQOracleDebug.println("Agent: " + ora_agt.name + "  " + ora_agt.address + "  " + ora_agt.protocol);
            agt_list[i] = new AQAgent(ora_agt.name, ora_agt.address, ora_agt.protocol);
            ++i;
        }
        return agt_list;
    }

    OracleCallableStatement getEnqRawStmt(int num_recps, Connection db_conn) throws AQException, SQLException {
        OracleCallableStatement enq_stmt;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "num_recps=" + num_recps);
        if (num_recps > 0) {
            if (this.enqr_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "recp list - stmt=null");
                this.enqr_rcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, object_user_data => null, recipients => ?); end; ");
            } else {
                this.enqr_rcp_stmt.clearParameters();
            }
            enq_stmt = this.enqr_rcp_stmt;
        } else {
            if (this.enqr_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "no recp list - stmt=null");
                this.enqr_norcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ? ); end; ");
            } else {
                this.enqr_norcp_stmt.clearParameters();
            }
            enq_stmt = this.enqr_norcp_stmt;
        }
        return enq_stmt;
    }

    OracleCallableStatement getEnqObjStmt(int num_recps, Connection db_conn) throws AQException, SQLException {
        OracleCallableStatement enq_stmt;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "num_recps=" + num_recps);
        if (num_recps > 0) {
            if (this.enqo_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "recp list - stmt=null");
                this.enqo_rcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ? ); end;");
            } else {
                this.enqo_rcp_stmt.clearParameters();
            }
            enq_stmt = this.enqo_rcp_stmt;
        } else {
            if (this.enqo_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "no recp list - stmt=null");
                this.enqo_norcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ? ); end; ");
            } else {
                this.enqo_norcp_stmt.clearParameters();
            }
            enq_stmt = this.enqo_norcp_stmt;
        }
        return enq_stmt;
    }

    OracleCallableStatement getDeqRawStmt(Connection db_conn) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "entry");
        if (this.deq_raw_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "stmt=null");
            this.deq_raw_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_raw( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_raw_stmt.clearParameters();
        }
        return this.deq_raw_stmt;
    }

    OracleCallableStatement getDeqObjStmt(Connection db_conn) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "entry");
        if (this.deq_obj_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "stmt=null");
            this.deq_obj_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_obj_stmt.clearParameters();
        }
        return this.deq_obj_stmt;
    }

    void destroyStmt(OracleCallableStatement stmt) throws AQException {
        if (stmt == null) {
            return;
        }
        try {
            if (stmt == this.enqo_rcp_stmt) {
                this.enqo_rcp_stmt = null;
            } else if (stmt == this.enqo_norcp_stmt) {
                this.enqo_norcp_stmt = null;
            } else if (stmt == this.enqr_rcp_stmt) {
                this.enqr_rcp_stmt = null;
            } else if (stmt == this.enqr_norcp_stmt) {
                this.enqr_norcp_stmt = null;
            } else if (stmt == this.deq_raw_stmt) {
                this.deq_raw_stmt = null;
            } else if (stmt == this.deq_obj_stmt) {
                this.deq_obj_stmt = null;
            } else {
                AQOracleDebug.trace(1, "AQOracleQueue.destroyStmt", "internal error - stmt not found");
                AQUtil.throwAQEx(122, "stmt not found");
            }
            stmt.close();
        }
        catch (SQLException sql_ex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.destroystmterror during stmt close", sql_ex);
        }
    }
}

