/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;

public class AQOracleSession
implements AQSession {
    Connection db_conn;
    private CallableStatement crqu_stmt;
    private CallableStatement allq_stmt;
    private CallableStatement allqo_stmt;

    public AQOracleSession(Connection conn) {
        Hashtable map = null;
        this.db_conn = conn;
        this.crqu_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        if (conn == null) {
            AQUtil.throwAQEx(111);
        }
        try {
            map = (Hashtable)((OracleConnection)this.db_conn).getTypeMap();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(112);
        }
        if (map == null) {
            ((OracleConnection)conn).setTypeMap(new Hashtable(20));
        }
    }

    public AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property) throws AQException {
        Statement qt_stmt = null;
        String table_name = "";
        AQOracleQueueTable q_table = null;
        String ac_flag = "true";
        String mcons_flag = "false";
        String qt_compat = null;
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, name);
        }
        if (property == null) {
            AQUtil.throwAQEx(186);
        }
        table_name = owner == null || owner.equals("") ? name : String.valueOf(owner) + "." + name;
        qt_compat = property.getCompatible();
        if (qt_compat == null || qt_compat.equals("")) {
            qt_compat = "8.1";
        }
        try {
            if (property.isMulticonsumerEnabled()) {
                mcons_flag = "true";
            }
            if (!property.isAutoCommitEnabled()) {
                ac_flag = "false";
            }
            qt_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + mcons_flag + ", message_grouping => ?, comment => ?, auto_commit => " + ac_flag + ", primary_instance => ?, secondary_instance => ?, compatible => ?); end;");
            qt_stmt.setString(1, table_name);
            qt_stmt.setString(2, property.getPayloadType());
            qt_stmt.setString(3, property.getStorageClause());
            qt_stmt.setString(4, property.getSortOrder());
            qt_stmt.setInt(5, property.getMessageGrouping());
            qt_stmt.setString(6, property.getComment());
            qt_stmt.setInt(7, property.getPrimaryInstance());
            qt_stmt.setInt(8, property.getSecondaryInstance());
            qt_stmt.setString(9, qt_compat);
            qt_stmt.execute();
            try {
                qt_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueueTable", sqlex);
            try {
                qt_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQOracleSQLException(sqlex);
        }
        q_table = new AQOracleQueueTable(this, owner, name, property);
        return q_table;
    }

    public AQQueueTable getQueueTable(String owner, String name) {
        AQOracleQueueTable q_table = null;
        AQQueueTableProperty property = null;
        Object sqt_stmt = null;
        ResultSet rset = null;
        Object rset2 = null;
        String pload_type = null;
        String adt_type = "";
        String qt_owner = null;
        Statement allqt_stmt = null;
        Statement allqto_stmt = null;
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, name);
        }
        try {
            if (owner != null && !owner.equals("")) {
                qt_owner = owner;
            }
            if (qt_owner != null) {
                try {
                    allqto_stmt = this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where owner = ? and queue_table = ?");
                    allqto_stmt.setString(1, qt_owner.toUpperCase());
                    allqto_stmt.setString(2, name.toUpperCase());
                    rset = allqto_stmt.executeQuery();
                }
                catch (SQLException sqlex) {
                    AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-1", sqlex);
                    throw sqlex;
                }
            }
            try {
                allqt_stmt = this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where queue_table = ?");
                allqt_stmt.setString(1, name.toUpperCase());
                rset = allqt_stmt.executeQuery();
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-2", sqlex);
                throw sqlex;
            }
            if (rset != null && rset.next()) {
                pload_type = rset.getString(2);
                if (pload_type.equals("RAW")) {
                    property = new AQQueueTableProperty("RAW");
                } else {
                    adt_type = rset.getString(3);
                    property = new AQQueueTableProperty(adt_type);
                }
                property.setSortOrder(rset.getString(4));
                if (rset.getString(5).equals("SINGLE")) {
                    property.setMultiConsumer(false);
                } else {
                    property.setMultiConsumer(true);
                }
                if (rset.getString(6).equals("TRANSACTIONAL")) {
                    property.setMessageGrouping(1);
                }
                if (rset.getString(7) != null) {
                    property.setComment(rset.getString(7));
                }
                property.setCompatible(rset.getString(8));
                property.setPrimaryInstance(rset.getInt(9));
                property.setSecondaryInstance(rset.getInt(10));
            } else if (qt_owner != null) {
                AQUtil.throwAQEx(173, String.valueOf(qt_owner) + "." + name);
            } else {
                AQUtil.throwAQEx(173, name);
            }
            if (rset.next()) {
                if (qt_owner != null) {
                    AQUtil.throwAQEx(172, "");
                } else {
                    AQUtil.throwAQEx(172, "(must specify owner)");
                }
            }
            if (qt_owner != null) {
                try {
                    allqto_stmt.close();
                }
                catch (Exception exception) {}
            } else {
                try {
                    allqt_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception aqex) {
            if (qt_owner != null) {
                try {
                    allqto_stmt.close();
                }
                catch (Exception exception) {}
            } else {
                try {
                    allqt_stmt.close();
                }
                catch (Exception exception) {}
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.getQeueueTable-4", aqex);
            if (aqex.getClass().getName().equals("oracle.AQ.AQException")) {
                throw (AQException)aqex;
            }
            throw new AQOracleSQLException((SQLException)aqex);
        }
        q_table = new AQOracleQueueTable(this, qt_owner, name, property);
        return q_table;
    }

    public AQQueue createQueue(AQQueueTable q_table, String q_name, AQQueueProperty q_property) throws AQException {
        CallableStatement cq_stmt = null;
        AQOracleQueue new_queue = null;
        String owner = null;
        String table_name = "";
        String ac_flag = "true";
        String pload_type = null;
        if (q_name == null || q_name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (q_property == null) {
            AQUtil.throwAQEx(185);
        }
        if (q_table == null) {
            AQUtil.throwAQEx(187);
        }
        if (q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        }
        table_name = (owner = q_table.getOwner()) == null || owner.equals("") ? q_table.getName() : String.valueOf(owner) + "." + q_table.getName();
        try {
            if (!q_property.isAutoCommitEnabled()) {
                ac_flag = "false";
                cq_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => false); end;");
            } else {
                if (this.crqu_stmt != null) {
                    this.crqu_stmt.clearParameters();
                } else {
                    this.crqu_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => true); end;");
                }
                cq_stmt = this.crqu_stmt;
            }
            cq_stmt.setString(1, q_name);
            cq_stmt.setString(2, table_name);
            cq_stmt.setInt(3, q_property.getQueueType());
            if (q_property.max_retries != null) {
                ((OracleCallableStatement)cq_stmt).setObject(4, (Object)q_property.max_retries, 4);
            } else {
                ((OracleCallableStatement)cq_stmt).setNull(4, 4);
            }
            cq_stmt.setDouble(5, q_property.getRetryInterval());
            cq_stmt.setDouble(6, q_property.getRetentionTime());
            cq_stmt.setString(7, q_property.getComment());
            cq_stmt.execute();
        }
        catch (SQLException sqlex) {
            if (ac_flag.equals("true")) {
                try {
                    this.crqu_stmt.close();
                }
                catch (Exception exception) {}
                this.crqu_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueue", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        pload_type = ((AQOracleQueueTable)q_table).property.getPayloadType();
        new_queue = pload_type.equalsIgnoreCase("RAW") ? new AQOracleQueue(this, owner, q_name, q_table.getName(), q_property, 2, null) : new AQOracleQueue(this, owner, q_name, q_table.getName(), q_property, 1, pload_type);
        return new_queue;
    }

    public AQQueue getQueue(String owner, String name) {
        AQOracleQueue que_hdl = null;
        AQQueueProperty q_property = null;
        ResultSet rset = null;
        int pload_type = 0;
        String obj_type = "";
        String ret_time = "";
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, name);
        }
        try {
            try {
                if (owner == null || owner.equals("")) {
                    if (this.allq_stmt == null) {
                        this.allq_stmt = this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, name.toUpperCase());
                    rset = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        this.allqo_stmt = this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, owner.toUpperCase());
                    this.allqo_stmt.setString(2, name.toUpperCase());
                    this.allqo_stmt.setString(3, owner.toUpperCase());
                    rset = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQeueue-1", sqlex);
                if (owner == null || owner.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception exception) {}
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception exception) {}
                    this.allqo_stmt = null;
                }
                throw sqlex;
            }
            if (rset.next()) {
                q_property = new AQQueueProperty();
                if (rset.getString(4).equals("EXCEPTION_QUEUE")) {
                    q_property.setQueueType(1);
                }
                q_property.setMaxRetries(rset.getInt(5));
                q_property.setRetryInterval(rset.getInt(6));
                ret_time = rset.getString(7).trim();
                if (ret_time.equals("FOREVER")) {
                    q_property.setRetentionTime(-1.0);
                } else {
                    q_property.setRetentionTime(rset.getDouble(7));
                }
                q_property.setComment(rset.getString(8));
                if (rset.getString(9).equals("RAW")) {
                    pload_type = 2;
                } else {
                    pload_type = 1;
                    obj_type = rset.getString(10);
                }
            } else if (owner == null || owner.equals("")) {
                AQUtil.throwAQEx(190, name);
            } else {
                AQUtil.throwAQEx(190, String.valueOf(owner) + "." + name);
            }
            que_hdl = pload_type == 2 ? new AQOracleQueue(this, rset.getString(1), name, rset.getString(3), q_property, pload_type, null) : new AQOracleQueue(this, rset.getString(1), name, rset.getString(3), q_property, pload_type, obj_type);
            if (rset.next()) {
                AQUtil.throwAQEx(182);
            }
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-2", aqex);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-3", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        return que_hdl;
    }

    public Connection getDBConnection() throws AQException {
        return this.db_conn;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQOracleSession]");
        if (this.db_conn != null) {
            buf.append("\n  db_conn          : " + this.db_conn);
        } else {
            buf.append("\n  db_conn          : NULL");
        }
        return buf.toString();
    }
}

