/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;

public class AQQueueProperty {
    public static final int NORMAL_QUEUE = 0;
    public static final int EXCEPTION_QUEUE = 1;
    static final int DEFAULT_QUEUE_TYPE = 0;
    static final int DEFAULT_MAX_RETRIES = 0;
    static final int DEFAULT_RETRY_INTERVAL = 0;
    static final int DEFAULT_RETENTION_TIME = 0;
    static final boolean DEFAULT_DEP_TRACKING = false;
    static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final int INFINITE = -1;
    private int type = 0;
    Integer max_retries = null;
    Double retry_interval = null;
    Double retention_time = null;
    private boolean dep_tracking = false;
    private String comment = null;
    private boolean auto_commit = true;

    public int getQueueType() throws AQException {
        return this.type;
    }

    public void setQueueType(int q_type) throws AQException {
        if (q_type != 0 && q_type != 1) {
            throw new AQException(0, "Invalid queue type");
        }
        this.type = q_type;
    }

    public int getMaxRetries() throws AQException {
        if (this.max_retries == null) {
            return 0;
        }
        return this.max_retries;
    }

    public void setMaxRetries(int retries) throws AQException {
        this.max_retries = new Integer(retries);
    }

    public void setMaxRetries(Integer retries) throws AQException {
        this.max_retries = retries;
    }

    public double getRetryInterval() throws AQException {
        if (this.retry_interval == null) {
            return 0.0;
        }
        return this.retry_interval;
    }

    public void setRetryInterval(double interval) throws AQException {
        this.retry_interval = new Double(interval);
    }

    public void setRetryInterval(Double interval) throws AQException {
        this.retry_interval = interval;
    }

    public double getRetentionTime() throws AQException {
        if (this.retention_time == null) {
            return 0.0;
        }
        return this.retention_time;
    }

    public void setRetentionTime(double r_time) throws AQException {
        this.retention_time = new Double(r_time);
    }

    public void setRetentionTime(Double r_time) throws AQException {
        this.retention_time = r_time;
    }

    boolean isDepTrackingEnabled() throws AQException {
        return this.dep_tracking;
    }

    void setDepTracking(boolean flag) throws AQException {
        if (flag) {
            throw new AQException(0, "Dependency tracking cannot be TRUE");
        }
        this.dep_tracking = flag;
    }

    public String getComment() throws AQException {
        return this.comment;
    }

    public void setComment(String qt_comment) throws AQException {
        this.comment = qt_comment;
    }

    boolean isAutoCommitEnabled() throws AQException {
        return this.auto_commit;
    }

    void setAutoCommit(boolean flag) throws AQException {
        this.auto_commit = flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueueProperty]");
        if (this.type == 0) {
            buf.append("\n  type             : NORMAL");
        } else {
            buf.append("\n  type             : EXCEPTION");
        }
        buf.append("\n  max_retries      : " + this.max_retries);
        buf.append("\n  retry_interval   : " + this.retry_interval);
        buf.append("\n  retention_time   : " + this.retention_time);
        buf.append("\n  dep_tracking     : " + this.dep_tracking);
        buf.append("\n  comment          : " + this.comment);
        buf.append("\n  auto_commit      : " + this.auto_commit);
        buf.append("\n");
        return buf.toString();
    }
}

