/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;

public class AQQueueTableProperty {
    static final boolean DEFAULT_MULTICONSUMER_FLAG = false;
    static final boolean DEFAULT_AUTO_COMMIT = true;
    static final int DEFAULT_MESSAGE_GROUPING = 0;
    public static final int NONE = 0;
    public static final int TRANSACTIONAL = 1;
    private String payload_type;
    private String storage_clause;
    private String sort_order;
    private boolean multi_consumer;
    private int mess_grouping;
    private String comment;
    private boolean auto_commit;
    private String compatible;
    private int primary_inst;
    private int secondary_inst;

    public AQQueueTableProperty(String p_type) {
        if (p_type == null || p_type.equals("")) {
            throw new AQException(0, "payload type must be specified");
        }
        this.payload_type = p_type;
        this.storage_clause = null;
        this.sort_order = null;
        this.multi_consumer = false;
        this.mess_grouping = 0;
        this.comment = null;
        this.auto_commit = true;
        this.compatible = null;
        this.primary_inst = 0;
        this.secondary_inst = 0;
    }

    public String getPayloadType() throws AQException {
        return this.payload_type;
    }

    public void setPayloadType(String p_type) throws AQException {
        if (p_type == null || p_type.equals("")) {
            throw new AQException(0, "payload type must be specified");
        }
        this.payload_type = p_type;
    }

    String getStorageClause() throws AQException {
        return this.storage_clause;
    }

    public void setStorageClause(String s_clause) throws AQException {
        this.storage_clause = s_clause;
    }

    public String getSortOrder() throws AQException {
        return this.sort_order;
    }

    public void setSortOrder(String s_order) throws AQException {
        this.sort_order = s_order;
    }

    public boolean isMulticonsumerEnabled() throws AQException {
        return this.multi_consumer;
    }

    public void setMultiConsumer(boolean enable) throws AQException {
        this.multi_consumer = enable;
    }

    public int getMessageGrouping() throws AQException {
        return this.mess_grouping;
    }

    public void setMessageGrouping(int message_grouping) throws AQException {
        this.mess_grouping = message_grouping;
    }

    public String getComment() throws AQException {
        return this.comment;
    }

    public void setComment(String qt_comment) throws AQException {
        this.comment = qt_comment;
    }

    boolean isAutoCommitEnabled() throws AQException {
        return this.auto_commit;
    }

    void setAutoCommit(boolean flag) throws AQException {
        this.auto_commit = flag;
    }

    public String getCompatible() throws AQException {
        return this.compatible;
    }

    public void setCompatible(String qt_compatible) throws AQException {
        this.compatible = qt_compatible;
    }

    public int getPrimaryInstance() throws AQException {
        return this.primary_inst;
    }

    public void setPrimaryInstance(int inst) throws AQException {
        this.primary_inst = inst;
    }

    public int getSecondaryInstance() throws AQException {
        return this.secondary_inst;
    }

    public void setSecondaryInstance(int inst) throws AQException {
        this.secondary_inst = inst;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueueTableProperty]");
        buf.append("\n  payload_type     : " + this.payload_type);
        buf.append("\n  storage_clause   : " + this.storage_clause);
        buf.append("\n  sort_order       : " + this.sort_order);
        buf.append("\n  multi_consumer   : " + this.multi_consumer);
        if (this.mess_grouping == 1) {
            buf.append("\n  message_grouping : TRANSACTIONAL");
        } else {
            buf.append("\n  message grouping : NONE");
        }
        buf.append("\n  comment          : " + this.comment);
        buf.append("\n  compatible       : " + this.compatible);
        buf.append("\n  auto_commit      : " + this.auto_commit);
        buf.append("\n  primary inst     : " + this.primary_inst);
        buf.append("\n  Secondary inst   : " + this.secondary_inst);
        buf.append("\n");
        return buf.toString();
    }
}

