/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import oracle.AQ.AQDriverManager;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsQueueReceiver;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AQjmsTopicSubscriber;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;

public class AQjmsConsumer
implements AQjmsQueueReceiver,
AQjmsTopicSubscriber,
AQjmsTopicReceiver {
    AQjmsSession jms_sess;
    AQjmsSelector selector;
    MessageListener listener;
    AQjmsDestination cons_dest;
    int dest_type;
    int deq_mode;
    int navig_mode;
    int visibility;
    String cons_name;
    boolean first_receive;
    boolean nolocal;
    CustomDatumFactory cd_factory;
    volatile boolean close_in_progress;
    private AQjmsEventListener evtListener;
    private OracleCallableStatement deq_stmt;

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, CustomDatumFactory payload_fact) throws JMSException {
        this(session, destination, dest_type, deq_mode, consumer_name, payload_fact, null);
    }

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, CustomDatumFactory payload_fact, AQjmsSelector selector) throws JMSException {
        String ptype = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "entry");
        if (destination == null) {
            AQjmsError.throwEx(200);
        }
        this.jms_sess = session;
        this.cons_dest = (AQjmsDestination)destination;
        this.dest_type = dest_type;
        this.listener = null;
        this.deq_stmt = null;
        if (deq_mode == 1 || deq_mode == 2 || deq_mode == 3 || deq_mode == 4) {
            this.deq_mode = deq_mode;
        } else {
            AQjmsError.throwEx(124);
        }
        this.navig_mode = 3;
        this.visibility = 2;
        if (dest_type == 20 && consumer_name == null) {
            AQjmsError.throwEx(116);
        }
        this.cons_name = consumer_name;
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "dest_type: " + dest_type);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "cons_dest: " + this.cons_dest.getCompleteName());
        if (this.cons_name != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "consumer_name: " + this.cons_name);
        }
        ptype = this.cons_dest.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "p_type: " + ptype);
        if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (payload_fact != null) {
                AQjmsError.throwEx(136);
            }
            this.cd_factory = null;
        } else {
            if (payload_fact == null) {
                AQjmsError.throwEx(137);
            }
            this.cd_factory = payload_fact;
        }
        this.selector = selector;
        if (selector != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "selector: " + selector.getSelectorString());
        }
        this.nolocal = false;
        this.first_receive = true;
        this.close_in_progress = false;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "exit");
    }

    private native AQjmsMessage ocideq(String var1, String var2, int var3, int var4, int var5, String var6, byte[] var7, int var8, long var9, long[] var11, long var12) throws Exception;

    public synchronized String getMessageSelector() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (this.selector != null) {
            return this.selector.getSelectorString();
        }
        return null;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        return this.listener;
    }

    void register(int port) throws JMSException {
        OracleCallableStatement reg_stmt = null;
        ResultSet reg_rset = null;
        Object location = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "enter");
        try {
            reg_stmt = this.jms_sess.getRegisterStmt();
            reg_stmt.setString(1, this.cons_dest.getQueueOwner().toUpperCase());
            String subname = this.dest_type == 20 ? String.valueOf(this.cons_dest.getCompleteName()) + ':' + this.cons_name : this.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "Subname " + subname);
            reg_stmt.setString(2, subname.toUpperCase());
            AQjmsOracleDebug.println("protocol http:");
            reg_stmt.setString(3, "http://");
            String address = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "address " + address);
            reg_stmt.setString(4, address);
            Integer iport = new Integer(port);
            reg_stmt.setObject(5, (Object)iport, 4);
            Integer ipresent = new Integer(1);
            reg_stmt.setObject(6, (Object)ipresent, 4);
            Integer iversion = new Integer(1);
            reg_stmt.setObject(7, (Object)iversion, 4);
            reg_rset = reg_stmt.executeQuery();
        }
        catch (Exception ex1) {
            this.jms_sess.destroyStmt(reg_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.register-ex1", ex1);
            AQjmsError.throwEx(199, ex1);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "exit");
    }

    void unregister(int port, AQjmsConnection this_conn) throws JMSException {
        OracleCallableStatement reg_stmt = null;
        ResultSet reg_rset = null;
        Object location = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.unregister", "enter");
        try {
            reg_stmt = this.jms_sess.getUnregisterStmt();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "Schema " + this.cons_dest.getQueueOwner());
            reg_stmt.setString(1, this.cons_dest.getQueueOwner().toUpperCase());
            String subname = this.dest_type == 20 ? String.valueOf(this.cons_dest.getCompleteName()) + ':' + this.cons_name : this.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "Subname " + subname);
            reg_stmt.setString(2, subname.toUpperCase());
            AQjmsOracleDebug.println("protocol http:");
            reg_stmt.setString(3, "http://");
            String address = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "address " + address);
            reg_stmt.setString(4, address);
            Integer iport = new Integer(port);
            reg_stmt.setObject(5, (Object)iport, 4);
            reg_rset = reg_stmt.executeQuery();
        }
        catch (Exception ex1) {
            this.jms_sess.destroyStmt(reg_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.unregister-ex1", ex1);
            AQjmsError.throwEx(202);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.unregister", "exit");
    }

    boolean pollMessage(MessageListener privilegedListener) throws JMSException {
        boolean foundMessage = false;
        MessageListener lsnr_to_post = null;
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", "entry");
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", " cons_name:" + this.cons_name + "cons_length: " + this.cons_name);
        lsnr_to_post = privilegedListener != null ? privilegedListener : this.listener;
        if (lsnr_to_post == null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.pollMessage", "exit");
            return foundMessage;
        }
        Message m = this.dequeue(this.cons_dest, 0L, this.cons_name, 1, 3);
        if (m != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.pollMessage", "before onMessage");
            lsnr_to_post.onMessage(m);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.pollMessage", "after onMessage");
            foundMessage = true;
        }
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", "exit");
        return foundMessage;
    }

    boolean notifyConsumer(Hashtable mProp, MessageListener privileged_listener) throws JMSException {
        Message m;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.notifyConsumer", "entry");
        MessageListener lsnr_to_notify = privileged_listener != null ? privileged_listener : this.listener;
        String queue = (String)mProp.get("QueueName");
        String consumer = (String)mProp.get("Consumer");
        String myQueueName = this.cons_dest.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.notifyConsumer", " queue:" + queue + " queue length:" + queue.length() + " myqueue:" + myQueueName + " myQueueLength:" + myQueueName.length());
        if (this.dest_type == 20) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.notifyConsumer", " consumer:" + consumer + "consumer length:" + consumer.length() + " cons_name: " + this.cons_name + " cons_name length:" + this.cons_name.length());
        }
        if (this.dest_type == 20) {
            if (!myQueueName.equalsIgnoreCase(queue) || !consumer.equalsIgnoreCase(this.cons_name)) {
                AQjmsOracleDebug.println("false1");
                return false;
            }
        } else if (!myQueueName.equalsIgnoreCase(queue)) {
            AQjmsOracleDebug.println("false2");
            return false;
        }
        if ((m = this.dequeue(this.cons_dest, 0L, consumer, 1, 3)) == null) {
            return false;
        }
        AQjmsOracleDebug.println("there was a message");
        lsnr_to_notify.onMessage(m);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.notifyConsumer", "exit");
        return true;
    }

    public void setMessageListener(MessageListener myListener) throws JMSException {
        boolean port = false;
        boolean bListenerAlreadyExists = false;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        AQjmsConnection jms_conn = this.jms_sess.getJmsConnection();
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (this.listener != null) {
            bListenerAlreadyExists = true;
        }
        this.listener = myListener;
        if (!bListenerAlreadyExists && this.listener != null) {
            this.evtListener = jms_conn.createEventListener();
            this.jms_sess.register(this.evtListener.getPort(), this);
            if (jms_conn.isConnectionStarted()) {
                this.evtListener.startAQjmsEventListener();
            }
            this.evtListener.addConsumer(this.jms_sess, this);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public Message receive() throws JMSException {
        return this.receiveFromAQ(-1L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receiveFromAQ(0L);
    }

    public Message receive(long timeout) throws JMSException {
        if (timeout == 0L) {
            timeout = -1L;
        }
        return this.receiveFromAQ(timeout);
    }

    public synchronized Message receiveFromAQ(long timeout) throws JMSException {
        int navigation_mode;
        Message ret_message = null;
        AQjmsConnection jms_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "entry");
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (!(jms_conn = this.jms_sess.getJmsConnection()).isConnectionStarted()) {
            AQjmsError.throwEx(113);
        }
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receive-2", "timeout(millisecs): " + timeout);
        if (this.first_receive) {
            navigation_mode = 1;
            this.first_receive = false;
        } else {
            navigation_mode = this.navig_mode;
        }
        if (this.dest_type == 10) {
            ret_message = this.dequeue(this.cons_dest, timeout, null, navigation_mode, this.deq_mode);
        } else if (this.dest_type == 20) {
            ret_message = this.dequeue(this.cons_dest, timeout, this.cons_name, navigation_mode, this.deq_mode);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return ret_message;
    }

    synchronized Message dequeue(AQjmsDestination dest_queue, long timeout, String consumer_name, int navigation_mode, int msg_dequeue_mode) throws JMSException {
        CustomDatumFactory payload_fact = null;
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        String q_name = "";
        ResultSet deq_rset = null;
        Integer navig = null;
        Integer visib = null;
        Integer dq_mode = null;
        AQjmsTextMessage_C text_msg_c = null;
        AQjmsTextMessage text_msg = null;
        AQjmsBytesMessage_C bytes_msg_c = null;
        AQjmsBytesMessage bytes_msg = null;
        AQjmsMapMessage_C map_msg_c = null;
        AQjmsMapMessage map_msg = null;
        AQjmsObjectMessage_C obj_msg_c = null;
        AQjmsObjectMessage obj_msg = null;
        AQjmsStreamMessage_C stream_msg_c = null;
        AQjmsStreamMessage stream_msg = null;
        AQjmsMessage ret_msg = null;
        CustomDatum cust_data = null;
        AQjmsAdtMessage adt_msg = null;
        AQjmsPropertyList prop_list = null;
        AQjmsMessageHeaderExt header_ext = null;
        Hashtable props_ht = null;
        Hashtable map = null;
        byte[] msg_id = null;
        byte[] sel_msg_id = null;
        String sel_corr_id = null;
        String s_name = null;
        AQjmsAgent sender = null;
        Timestamp etime = null;
        int msg_delay = 0;
        int interval = 0;
        long iterations = 1L;
        long last_interval = 0L;
        int idx = 0;
        boolean retry = false;
        long sec_timeout = 0L;
        long exp_time = 0L;
        int attempts = 0;
        int mtype = -1;
        long[] oci_handles = null;
        boolean use_ociaq_lib = false;
        long cntxt = 0L;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "entry");
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        sec_timeout = timeout >= 0L ? (timeout + 999L) / 1000L : -1L;
        interval = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "sec_timeout: " + sec_timeout + "  close_check_interval: " + interval);
        if (sec_timeout > (long)interval) {
            iterations = sec_timeout / (long)interval;
            last_interval = sec_timeout % (long)interval;
            if (last_interval > 0L) {
                ++iterations;
            } else {
                last_interval = interval;
            }
        } else {
            iterations = 1L;
            last_interval = sec_timeout;
        }
        AQjmsOracleDebug.println("Timeout: " + sec_timeout + " Iterations: " + iterations + " Interval: " + interval + " Last_interval: " + last_interval);
        if (dest_queue == null || dest_queue.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        String p_data_type = dest_queue.getAdtType();
        q_name = dest_queue.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "q_name: " + q_name + "  p_data_type: " + p_data_type);
        jms_conn = this.jms_sess.getJmsConnection();
        try {
            db_conn = this.jms_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "After getDbConnection");
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception exception) {
            AQjmsError.throwEx(146);
        }
        try {
            if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                payload_fact = AQjmsTextMessage_C.getFactory();
                mtype = 0;
            } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                payload_fact = AQjmsBytesMessage_C.getFactory();
                mtype = 1;
            } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                payload_fact = AQjmsStreamMessage_C.getFactory();
                mtype = 2;
            } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                payload_fact = AQjmsMapMessage_C.getFactory();
                mtype = 3;
            } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                payload_fact = AQjmsObjectMessage_C.getFactory();
                mtype = 4;
            } else if (this.cd_factory != null) {
                payload_fact = this.cd_factory;
            } else {
                AQjmsError.throwEx(129, p_data_type);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Payload type" + mtype);
            if (this.selector != null) {
                AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                if (this.selector.getSelectorType() == 20) {
                    sel_corr_id = this.selector.getSelectorCorrelationId();
                    AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + this.selector.getSelectorCorrelationId());
                } else if (this.selector.getSelectorType() == 30) {
                    sel_msg_id = this.selector.getSelectorMessageId();
                    AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                }
            }
            if (jms_conn.getDriver() != null && jms_conn.getDriver().equalsIgnoreCase("oci8") && this.cd_factory == null && AQDriverManager.isOciAQEnabled()) {
                oci_handles = new long[]{this.jms_sess.oci_env_handle, this.jms_sess.oci_err_handle, this.jms_sess.oci_svc_handle};
                cntxt = this.jms_sess.oci_aq_cntxt;
                use_ociaq_lib = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = true");
            } else {
                use_ociaq_lib = false;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = false");
                this.deq_stmt = this.jms_sess.getDequeueStmt();
                this.deq_stmt.setString(1, q_name);
                this.deq_stmt.setString(2, consumer_name);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + consumer_name);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                    if (this.selector.getSelectorType() == 20) {
                        this.deq_stmt.setNull(3, -2);
                        sel_corr_id = this.selector.getSelectorCorrelationId();
                        this.deq_stmt.setString(4, sel_corr_id);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + this.selector.getSelectorCorrelationId());
                    } else if (this.selector.getSelectorType() == 30) {
                        sel_msg_id = this.selector.getSelectorMessageId();
                        this.deq_stmt.setBytes(3, sel_msg_id);
                        this.deq_stmt.setString(4, null);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, null);
                    }
                } else {
                    this.deq_stmt.setNull(3, -2);
                    this.deq_stmt.setString(4, null);
                }
                dq_mode = new Integer(msg_dequeue_mode);
                this.deq_stmt.setObject(5, (Object)dq_mode, 4);
                navig = new Integer(navigation_mode);
                this.deq_stmt.setObject(6, (Object)navig, 4);
                visib = new Integer(this.visibility);
                this.deq_stmt.setObject(7, (Object)visib, 4);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "dq_mode: " + dq_mode + "navig: " + navig + "visibility: " + visib);
                this.deq_stmt.registerOutParameter(9, 91);
                this.deq_stmt.registerOutParameter(10, 4);
                this.deq_stmt.registerOutParameter(11, -2);
                this.deq_stmt.registerOutParameter(12, 12);
                this.deq_stmt.registerOutParameter(13, 4);
                this.deq_stmt.registerOutParameter(14, 4);
                this.deq_stmt.registerOutParameter(15, 4);
                this.deq_stmt.registerOutParameter(16, 4);
                this.deq_stmt.registerOutParameter(17, 12);
                this.deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
                this.deq_stmt.registerOutParameter(19, 12);
                this.deq_stmt.registerOutParameter(20, 12);
                this.deq_stmt.registerOutParameter(21, 4);
                this.deq_stmt.registerOutParameter(22, -2);
                Integer p_type = new Integer(1);
                this.deq_stmt.setObject(23, (Object)p_type, 4);
                this.deq_stmt.registerOutParameter(24, -2);
                this.deq_stmt.registerOutParameter(25, 2002, p_data_type);
            }
            if (sec_timeout == -1L) {
                do {
                    retry = false;
                    try {
                        long wt_time = interval;
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + wt_time);
                        if (use_ociaq_lib) {
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Calling Native Deq-1");
                            if (consumer_name != null) {
                                consumer_name = consumer_name.toUpperCase();
                            }
                            ret_msg = this.ocideq(q_name, consumer_name, mtype, navigation_mode, msg_dequeue_mode, sel_corr_id, sel_msg_id, this.visibility, wt_time, oci_handles, cntxt);
                        } else {
                            this.deq_stmt.setLong(8, wt_time);
                            deq_rset = this.deq_stmt.executeQuery();
                        }
                    }
                    catch (SQLException sql_ex) {
                        AQjmsOracleDebug.println("SQL excpetion-1:" + sql_ex.getErrorCode());
                        if (sql_ex.getErrorCode() == 25228) {
                            retry = true;
                            try {
                                if (deq_rset != null) {
                                    deq_rset.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-sqlex", sql_ex);
                        throw sql_ex;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                    if (!this.jms_sess.isSessionClosed() && !this.close_in_progress) continue;
                    AQjmsOracleDebug.println("Session closed: return");
                    if (this.deq_stmt != null) {
                        this.jms_sess.destroyStmt(this.deq_stmt);
                    }
                    return null;
                } while (retry);
            } else {
                idx = 0;
                while ((long)idx < iterations) {
                    retry = false;
                    try {
                        long wt_time = (long)idx == iterations - 1L ? last_interval : (long)interval;
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + wt_time);
                        if (use_ociaq_lib) {
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Calling Native Deq-2");
                            AQjmsOracleDebug.println("Context: " + cntxt);
                            if (consumer_name != null) {
                                consumer_name = consumer_name.toUpperCase();
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_dequeue_mode: " + msg_dequeue_mode);
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + consumer_name);
                            ret_msg = this.ocideq(q_name, consumer_name, mtype, navigation_mode, msg_dequeue_mode, sel_corr_id, sel_msg_id, this.visibility, wt_time, oci_handles, cntxt);
                        } else {
                            this.deq_stmt.setLong(8, wt_time);
                            deq_rset = this.deq_stmt.executeQuery();
                        }
                    }
                    catch (SQLException sql_ex) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sql_ex.getErrorCode());
                        if ((long)idx < iterations - 1L && sql_ex.getErrorCode() == 25228) {
                            retry = true;
                            try {
                                if (deq_rset != null) {
                                    deq_rset.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        throw sql_ex;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                    if (this.jms_sess.isSessionClosed() || this.close_in_progress) {
                        AQjmsOracleDebug.println("Session closed: return");
                        if (this.deq_stmt != null) {
                            this.jms_sess.destroyStmt(this.deq_stmt);
                        }
                        return null;
                    }
                    if (!retry) break;
                    ++idx;
                }
            }
            if (msg_dequeue_mode == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            if (!use_ociaq_lib) {
                if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    text_msg_c = (AQjmsTextMessage_C)this.deq_stmt.getCustomDatum(25, payload_fact);
                    text_msg = new AQjmsTextMessage(text_msg_c, (OracleConnection)db_conn);
                    ret_msg = text_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "text_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    bytes_msg_c = (AQjmsBytesMessage_C)this.deq_stmt.getCustomDatum(25, payload_fact);
                    bytes_msg = new AQjmsBytesMessage(bytes_msg_c);
                    ret_msg = bytes_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "bytes_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    map_msg_c = (AQjmsMapMessage_C)this.deq_stmt.getCustomDatum(25, payload_fact);
                    map_msg = new AQjmsMapMessage(map_msg_c);
                    ret_msg = map_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "map_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    obj_msg_c = (AQjmsObjectMessage_C)this.deq_stmt.getCustomDatum(25, payload_fact);
                    obj_msg = new AQjmsObjectMessage(obj_msg_c);
                    ret_msg = obj_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "object_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    stream_msg_c = (AQjmsStreamMessage_C)this.deq_stmt.getCustomDatum(25, payload_fact);
                    stream_msg = new AQjmsStreamMessage(stream_msg_c);
                    ret_msg = stream_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "stream_message retrieved");
                } else {
                    cust_data = (CustomDatum)this.deq_stmt.getCustomDatum(25, payload_fact);
                    adt_msg = new AQjmsAdtMessage(cust_data);
                    ret_msg = adt_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "adt_message retrieved");
                }
                etime = this.deq_stmt.getTimestamp(9);
                long secs = ((Date)etime).getTime();
                ret_msg.setJMSTimestamp(secs);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "enq_time: " + etime);
                ret_msg.setMessageState(this.deq_stmt.getInt(10));
                msg_id = this.deq_stmt.getBytes(11);
                ret_msg.setJMSMessageID(msg_id);
                ret_msg.setJMSCorrelationID(this.deq_stmt.getString(12));
                ret_msg.setJMSPriority(this.deq_stmt.getInt(13));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_id: " + RepConversion.bArray2String((byte[])msg_id) + " corrid: " + this.deq_stmt.getString(12) + " priority: " + this.deq_stmt.getInt(13));
                msg_delay = this.deq_stmt.getInt(14);
                ret_msg.setDelay(msg_delay);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_delay(secs): " + msg_delay);
                exp_time = this.deq_stmt.getLong(15);
                ret_msg.setJMSExpiration(exp_time);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "exptime(secs): " + exp_time);
                attempts = this.deq_stmt.getInt(16);
                ret_msg.setAttempts(attempts);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "attempts: " + attempts);
                ret_msg.setExceptionQueue(this.deq_stmt.getString(17));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "excp_q: " + this.deq_stmt.getString(17));
                s_name = this.deq_stmt.getString(19);
                if (s_name != null && !s_name.equals("")) {
                    sender = new AQjmsAgent();
                    sender.setName(s_name);
                    sender.setAddress(this.deq_stmt.getString(20));
                    sender.setProtocol(this.deq_stmt.getInt(21));
                    ret_msg.setSenderID(sender);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Sender" + sender);
                }
                ret_msg.setOriginalMessageId(this.deq_stmt.getBytes(22));
            }
            if (this.cd_factory == null) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-0 " + ret_msg);
                header_ext = ret_msg.getMessageHeaderExt();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-1");
                prop_list = header_ext.getProperties();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-2");
                props_ht = AQjmsMessage.convertPropertyListToHashtable(prop_list);
                ret_msg.setPropertiesHashtable(props_ht);
            }
            if (ret_msg.getJMSExpiration() >= 0L) {
                ret_msg.setJMSExpiration(ret_msg.getJMSExpiration() * 1000L);
            }
            Date recv_time = new Date();
            ret_msg.setReceiveTime(recv_time.getTime());
            if (attempts > 1) {
                ret_msg.setJMSRedelivered(true);
            } else {
                ret_msg.setJMSRedelivered(false);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "recv_time: " + recv_time);
            ret_msg.setPropReadOnly(true);
            ret_msg.setAccessMode(0);
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sql_ex2) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if (sql_ex2.getErrorCode() == 25228 && msg_dequeue_mode != 4) {
                ret_msg = null;
            } else {
                AQjmsError.throwEx(120, sql_ex2);
            }
        }
        catch (Exception ex3) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsError.throwEx(120, ex3);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-2");
        return ret_msg;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "entry");
        this.close_in_progress = true;
        this.closeConsumerResources(this.jms_sess.getJmsConnection());
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit");
    }

    void closeFromSession(AQjmsConnection this_conn) {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeFromSession", "entry");
        this.close_in_progress = true;
        this.closeConsumerResources(this_conn);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeFromSession", "exit");
    }

    synchronized void closeConsumerResources(AQjmsConnection this_conn) {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeConsumerResources", "entry");
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit-1");
            return;
        }
        this.jms_sess.destroyStmt(this.deq_stmt);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deq_stmt closed");
        try {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deleting listener info");
            if (this.evtListener != null) {
                if (this.listener != null) {
                    AQjmsOracleDebug.println("there was a listener");
                    this.unregister(this.evtListener.getPort(), this_conn);
                }
                this.evtListener.removeConsumer(this);
            }
        }
        catch (Exception exception) {}
        this.evtListener = null;
        this.listener = null;
        this.selector = null;
        this.cons_dest = null;
        this.cd_factory = null;
        this.jms_sess = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit-2");
    }

    public synchronized Queue getQueue() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (this.dest_type == 10) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "TopicSubscriber");
        return null;
    }

    public synchronized Topic getTopic() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (this.dest_type == 20) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized boolean getNoLocal() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        return this.nolocal;
    }

    public synchronized int getNavigationMode() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        return this.navig_mode;
    }

    public synchronized void setNavigationMode(int mode) throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (mode == 1 || mode == 3 || mode == 2) {
            this.navig_mode = mode;
        } else {
            AQjmsError.throwEx(128);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.setNavigationMode", "navig_mode: " + mode);
    }

    public synchronized void receiveNoData() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "entry");
        this.receiveNoData(-1L);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "exit");
    }

    public synchronized void receiveNoData(long timeout) throws JMSException {
        int navigation_mode;
        Message ret_message = null;
        AQjmsConnection jms_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveNoData", "timeout: " + timeout);
        if (this.isConsumerClosed()) {
            AQjmsError.throwEx(115);
        }
        if (!(jms_conn = this.jms_sess.getJmsConnection()).isConnectionStarted()) {
            AQjmsError.throwEx(113);
        }
        if (this.first_receive) {
            navigation_mode = 1;
            this.first_receive = false;
        } else {
            navigation_mode = this.navig_mode;
        }
        if (this.dest_type == 10) {
            ret_message = this.dequeue(this.cons_dest, timeout, null, navigation_mode, 4);
        } else if (this.dest_type == 20) {
            ret_message = this.dequeue(this.cons_dest, timeout, this.cons_name, navigation_mode, 4);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "exit");
    }

    boolean isConsumerClosed() {
        return this.close_in_progress || this.jms_sess == null;
    }
}

