/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.Service;

public class AQjmsEventListener
implements Runnable {
    private Thread myThread;
    Service theService;
    ConnectionManager theConManager;
    PollerManager thePollerManager;
    volatile boolean stopped;
    ServerSocket theListenSock;
    int thePort;
    AQjmsSession theSession;
    Hashtable theConsumerList;
    static /* synthetic */ Class class$oracle$jms$AQjmsEventListener;

    public AQjmsEventListener(String myService, int maxConnections) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsEventListener-constructor", "Starting event listener");
        this.theConManager = new ConnectionManager(maxConnections);
        this.thePollerManager = new PollerManager(maxConnections);
        this.theConsumerList = new Hashtable();
        Class[] servArgsClass = new Class[]{class$oracle$jms$AQjmsEventListener != null ? class$oracle$jms$AQjmsEventListener : (class$oracle$jms$AQjmsEventListener = AQjmsEventListener.class$("oracle.jms.AQjmsEventListener"))};
        Object[] servArgs = new Object[]{this};
        Constructor<?> servArgsConstructor = null;
        try {
            Class<?> servClassDefinition = Class.forName(myService);
            servArgsConstructor = servClassDefinition.getConstructor(servArgsClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(122, "service class not found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            AQjmsError.throwEx(122, "service class constructor not found");
        }
        try {
            this.theService = (Service)servArgsConstructor.newInstance(servArgs);
        }
        catch (InstantiationException instantiationException) {
            AQjmsError.throwEx(122, "couldn't instantiate service classs");
        }
        catch (IllegalAccessException illegalAccessException) {
            AQjmsError.throwEx(122, "illegal access exception on instantiating service");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AQjmsError.throwEx(122, "illegal argument to service constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            AQjmsError.throwEx(122, "exception when instantiating service class");
        }
        this.stopped = true;
        try {
            this.theListenSock = new ServerSocket(0);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(122, "Couldn't create listener's socket");
        }
        try {
            this.theListenSock.setSoTimeout(120000);
        }
        catch (SocketException socketException) {
            AQjmsError.throwEx(122, "Couldn't set timeout on the socket");
        }
        this.thePort = this.theListenSock.getLocalPort();
    }

    public synchronized void addConsumer(AQjmsSession sess, AQjmsConsumer cons) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addConsumer", "enter");
        this.theSession = sess;
        this.theConsumerList.put(cons, cons);
        if (!this.isStopped()) {
            Poller myPoller = new Poller(sess, cons);
            this.thePollerManager.addPoller(myPoller);
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addConsumer", "exit");
    }

    public synchronized void addSession(AQjmsSession sess, Hashtable cons_list) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addSession", "enter");
        this.theSession = sess;
        this.theConsumerList = cons_list;
        if (!this.isStopped()) {
            Enumeration e = cons_list.elements();
            while (e.hasMoreElements()) {
                AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
                Poller myPoller = new Poller(sess, cons);
                this.thePollerManager.addPoller(myPoller);
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addSession", "exit");
    }

    public synchronized void removeConsumer(AQjmsConsumer cons) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "enter");
        this.theConsumerList.remove(cons);
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "exit");
    }

    public synchronized void removeSession(AQjmsSession sess) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeSession", "enter");
        this.theSession = null;
        this.theConsumerList = null;
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "exit");
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void startAQjmsEventListener() throws JMSException {
        AQjmsOracleDebug.trace(3, "startAQjmsEventListener", "enter");
        if (!this.stopped) {
            AQjmsOracleDebug.trace(4, "AQjmsEventListener", "already started");
            return;
        }
        this.stopped = false;
        AQjmsOracleDebug.trace(4, "AQjmsEventListener.startAQjmsListener", "entry");
        this.myThread = new Thread((Runnable)this, "AQjmsEventListener");
        this.myThread.start();
        this.pollMessages();
        AQjmsOracleDebug.trace(3, "startAQjmsEventListener", "exit");
    }

    void notifyEventListener(Hashtable mProp) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.notifyEventListener", "enter");
        this.theSession.notifySession(mProp, this.theConsumerList);
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.notifyEventListener", "exit");
    }

    public synchronized void stopAQjmsEventListener() {
        AQjmsOracleDebug.trace(4, "AQjmsEventListener", "enter");
        if (this.stopped) {
            AQjmsOracleDebug.trace(4, "AQjmsEventListener", "already stopped");
            return;
        }
        this.stopped = true;
        AQjmsOracleDebug.trace(4, "AQjmsEventListener", "set state to stop");
        try {
            this.theListenSock.close();
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "ServerSocket.close ()");
        }
        this.theConManager.closeConnectionManager();
        this.thePollerManager.closePollerManager();
        AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "exit");
    }

    public int getPort() {
        return this.thePort;
    }

    synchronized void pollMessages() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.pollMessages", "enter");
        Enumeration e = this.theConsumerList.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            AQjmsOracleDebug.println("Added poller for consumer ");
            Poller myPoller = new Poller(this.theSession, cons);
            this.thePollerManager.addPoller(myPoller);
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.pollMessages", "exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.run", "enter");
        try {
            try {
                while (!this.stopped) {
                    try {
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "before Accept");
                        Socket aClient = this.theListenSock.accept();
                        this.theConManager.addConnection(aClient, this.theService);
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "After adding Connection");
                    }
                    catch (InterruptedIOException e) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsEventListener-int-ioex", e);
                    }
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsEventListener-ex", e);
            }
            Object var2_4 = null;
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "finally");
            throw throwable;
        }
        AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "finally");
        AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "exit");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public class ConnectionManager {
        int maxCon;
        Hashtable m_connectionList;

        public ConnectionManager(int maxCon) {
            AQjmsEventListener.this = AQjmsEventListener.this;
            this.maxCon = maxCon;
            this.m_connectionList = new Hashtable();
            AQjmsOracleDebug.trace(4, "ConnectionManager-constructor", "Created connection manager.  Max connnections: " + maxCon);
        }

        synchronized void addConnection(Socket aSock, Service aService) {
            if (this.m_connectionList.size() >= this.maxCon) {
                try {
                    AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connection refused; server has reached maximum number of clients.");
                    aSock.close();
                    AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connection refused to " + aSock.getInetAddress().getHostAddress() + ":" + aSock.getPort() + ": max conVec reached.");
                }
                catch (IOException e) {
                    AQjmsOracleDebug.traceEx(3, "ConectionManager.addConnection-ioex", e);
                }
            } else {
                Connection aCon = new Connection(aSock, aService);
                this.m_connectionList.put(aCon, aCon);
                AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connected to " + aSock.getInetAddress().getHostAddress() + ":" + aSock.getPort() + " on port " + aSock.getLocalPort() + " for service " + aService.getClass().getName());
                aCon.start();
            }
        }

        public synchronized void removeConnection(Connection aCon) {
            if (this.m_connectionList.remove(aCon) != null) {
                AQjmsOracleDebug.trace(3, "ConectionManager.removeConnection", "remove connection");
            }
        }

        public synchronized void setMaxConnections(int newMax) {
            this.maxCon = newMax;
        }

        synchronized void printConnections(PrintWriter out) {
            Enumeration enumeration = this.m_connectionList.elements();
            while (enumeration.hasMoreElements()) {
                Connection aCon = (Connection)enumeration.nextElement();
                out.println("CONNECTED TO " + aCon.theClient.getInetAddress().getHostAddress() + ":" + aCon.theClient.getPort() + " ON PORT " + aCon.theClient.getLocalPort() + " FOR SERVICE " + aCon.theService.getClass().getName());
            }
        }

        public synchronized void closeConnectionManager() {
            AQjmsOracleDebug.trace(3, "ConectionManager.closeConnectionManager", "stopping ConnManager");
            Enumeration enumeration = this.m_connectionList.elements();
            while (enumeration.hasMoreElements()) {
                Connection aCon = (Connection)enumeration.nextElement();
                aCon.stopConnection();
            }
        }
    }

    public class PollerManager {
        int maxThreads;
        Hashtable m_pollerList;

        public PollerManager(int myMaxThreads) {
            AQjmsEventListener.this = AQjmsEventListener.this;
            this.maxThreads = myMaxThreads;
            this.m_pollerList = new Hashtable();
            AQjmsOracleDebug.trace(4, "PollerManager-constructor", "Created poller manager.  Max threads: " + this.maxThreads);
        }

        public synchronized boolean addPoller(Poller aPoller) {
            AQjmsOracleDebug.trace(3, "PollerManager.addPoller", "enter");
            if (this.m_pollerList.size() >= this.maxThreads) {
                return false;
            }
            this.m_pollerList.put(aPoller, aPoller);
            aPoller.start();
            AQjmsOracleDebug.trace(3, "PollerManager.addPoller", "exit");
            return true;
        }

        synchronized boolean removePoller(Poller aPoller) {
            return this.m_pollerList.remove(aPoller) != null;
        }

        public synchronized void closePollerManager() {
            AQjmsOracleDebug.trace(3, "PollerManager.closePollerManager", "entry");
            Enumeration enumeration = this.m_pollerList.elements();
            while (enumeration.hasMoreElements()) {
                Poller aPoll = (Poller)enumeration.nextElement();
                aPoll.stopPoller();
            }
            AQjmsOracleDebug.trace(3, "PollerManager.closePollerManager", "entry");
        }
    }

    public class Poller
    extends Thread {
        AQjmsSession theSession;
        AQjmsConsumer theConsumer;
        volatile boolean stopped;

        public Poller(AQjmsSession mySession, AQjmsConsumer myConsumer) {
            AQjmsEventListener.this = AQjmsEventListener.this;
            this.theSession = mySession;
            this.theConsumer = myConsumer;
            this.stopped = false;
        }

        public void stopPoller() {
            this.stopped = true;
        }

        public void run() {
            AQjmsOracleDebug.trace(3, "PollerManager.run", "enter");
            try {
                try {
                    while (!this.stopped && this.theSession.pollMessage(this.theConsumer)) {
                        AQjmsOracleDebug.trace(3, "PollerManager.run", "found a message");
                    }
                }
                catch (AQjmsException aQjmsException) {
                    AQjmsOracleDebug.trace(3, "Polling:run", "exception");
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.trace(3, "Polling:run", "exception2");
                }
                Object var2_1 = null;
                AQjmsEventListener.this.thePollerManager.removePoller(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AQjmsEventListener.this.thePollerManager.removePoller(this);
                AQjmsOracleDebug.trace(3, "Polling:run", "exit");
                throw throwable;
            }
            AQjmsOracleDebug.trace(3, "Polling:run", "exit");
        }
    }

    public class Connection
    extends Thread {
        Socket theClient;
        Service theService;

        public Connection(Socket aClient, Service aService) {
            super("Server.Connection:" + aClient.getInetAddress().getHostAddress() + ":" + aClient.getPort());
            AQjmsEventListener.this = AQjmsEventListener.this;
            this.theClient = aClient;
            this.theService = aService;
        }

        public void stopConnection() {
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.stopConenction", "stop");
            this.theService.stopService();
            this.cleanup();
        }

        public void run() {
            try {
                try {
                    AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "enter");
                    InputStream in = this.theClient.getInputStream();
                    OutputStream out = this.theClient.getOutputStream();
                    this.theService.serve(in, out);
                }
                catch (IOException e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-ioex", e);
                }
                catch (JMSException e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-jmsex", (Exception)((Object)e));
                }
                catch (Exception ex) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-throwable", ex);
                }
                Object var2_6 = null;
                this.cleanup();
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                this.cleanup();
                throw throwable;
            }
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "exit");
        }

        void cleanup() {
            try {
                AQjmsEventListener.this.theConManager.removeConnection(this);
                this.theClient.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

