/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Date;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AQjmsProperty;
import oracle.jms.AQjmsPropertyList;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class AQjmsMessage
implements Message {
    static final Class m_boolClass = new Boolean(false).getClass();
    static final Class m_byteClass = new Byte(0).getClass();
    static final Class m_shortClass = new Byte(0).getClass();
    static final Class m_intClass = new Integer(0).getClass();
    static final Class m_longClass = new Long(0L).getClass();
    static final Class m_floatClass = new Float(0.0f).getClass();
    static final Class m_doubleClass = new Double(0.0).getClass();
    static final Class m_strClass = new String(" ").getClass();
    static Hashtable m_systemProperties;
    AQjmsMessageHeaderExt header_ext;
    byte[] message_id = null;
    Date enqueue_time = null;
    String corr_id = "";
    Destination msg_dest = null;
    int del_mode = 2;
    boolean redelivered = false;
    long expiration = 0L;
    int priority = 1;
    Hashtable msg_properties = new Hashtable();
    int access_mode = 2;
    boolean prop_read_only = false;
    long recv_time = 0L;
    int msg_state;
    String excp_queue = null;
    int msg_delay = 0;
    byte[] orig_msg_id = null;
    AQjmsAgent sender_id;
    int attempts;

    public AQjmsMessage() {
        this.header_ext = new AQjmsMessageHeaderExt();
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    void setPropertiesHashtable(Hashtable props) {
        this.msg_properties = props;
    }

    public String getJMSMessageID() throws JMSException {
        String ret_msg_id = RepConversion.bArray2String((byte[])this.message_id);
        return new String("ID:" + ret_msg_id);
    }

    public byte[] getJMSMessageIDAsBytes() throws JMSException {
        if (this.message_id != null) {
            byte[] ret_msg_id = new byte[this.message_id.length];
            System.arraycopy(this.message_id, 0, ret_msg_id, 0, this.message_id.length);
            return ret_msg_id;
        }
        return this.message_id;
    }

    void setJMSMessageID(byte[] id) throws JMSException {
        this.message_id = id;
    }

    public void setJMSMessageID(String id) throws JMSException {
        AQjmsError.throwEx(110, "JMSMessageID");
    }

    public long getJMSTimestamp() throws JMSException {
        return this.enqueue_time.getTime();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.enqueue_time = new Date(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.corr_id.getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.corr_id = new String(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.corr_id = correlationID;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.corr_id;
    }

    public Destination getJMSReplyTo() throws JMSException {
        try {
            return this.header_ext.getReplyto();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        try {
            if (replyTo instanceof AQjmsAgent) {
                this.header_ext.setReplyto((AQjmsAgent)replyTo);
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msg_dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.msg_dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.del_mode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.del_mode = deliveryMode;
        } else {
            AQjmsError.throwEx(101);
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        try {
            return this.header_ext.getType();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void setJMSType(String type) throws JMSException {
        try {
            this.header_ext.setType(type);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void clearProperties() throws JMSException {
        if (this.msg_properties != null) {
            this.msg_properties.clear();
        }
        if (this.header_ext != null) {
            try {
                this.header_ext.setReplyto(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setType(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setUserid(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setAppid(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setGroupid(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setGroupseq(null);
            }
            catch (Exception exception) {}
            try {
                this.header_ext.setProperties(null);
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.clearProperties", ex);
            }
        }
        this.redelivered = false;
        this.msg_dest = null;
        this.expiration = 0L;
        this.priority = 1;
        this.corr_id = "";
        this.message_id = null;
        this.del_mode = 2;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.setPropReadOnly(false);
    }

    public boolean propertyExists(String name) throws JMSException {
        if (m_systemProperties.containsKey(name)) {
            try {
                return this.getSystemProperty(name) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.msg_properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        block15: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Boolean.valueOf(str);
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 20: {
                                int val = ((Datum)value).intValue();
                                return val != 0;
                            }
                            case 27: {
                                String str = (String)value;
                                return Boolean.valueOf(str);
                            }
                            default: {
                                if (value == null) break block15;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block15;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String name) throws JMSException {
        block15: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Byte.parseByte(str);
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 21: {
                                int val = ((Datum)value).intValue();
                                return (byte)val;
                            }
                            case 27: {
                                String str = (String)value;
                                return Byte.parseByte(str);
                            }
                            default: {
                                if (value == null) break block15;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block15;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String name) throws JMSException {
        block15: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Short.parseShort(str);
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 21: 
                            case 22: {
                                int val = ((Datum)value).intValue();
                                return (short)val;
                            }
                            case 27: {
                                String str = (String)value;
                                return Short.parseShort(str);
                            }
                            default: {
                                if (value == null) break block15;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block15;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String name) throws JMSException {
        block16: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Integer.parseInt(str);
                    }
                    if (cl == m_intClass) {
                        return ((Datum)value).intValue();
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 21: 
                            case 22: 
                            case 23: {
                                return ((Datum)value).intValue();
                            }
                            case 27: {
                                String str = (String)value;
                                return Integer.parseInt(str);
                            }
                            default: {
                                if (value == null) break block16;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block16;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String name) throws JMSException {
        block18: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Long.parseLong(str);
                    }
                    if (cl == m_intClass) {
                        return ((Datum)value).intValue();
                    }
                    if (cl == m_longClass) {
                        return ((Datum)value).longValue();
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 21: 
                            case 22: 
                            case 23: {
                                return ((Datum)value).intValue();
                            }
                            case 24: {
                                return ((Datum)value).longValue();
                            }
                            case 27: {
                                String str = (String)value;
                                return Long.parseLong(str);
                            }
                            default: {
                                if (value == null) break block18;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block18;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String name) throws JMSException {
        block15: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return new Float(str).floatValue();
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 25: {
                                return ((Datum)value).floatValue();
                            }
                            case 27: {
                                String str = (String)value;
                                return new Float(str).floatValue();
                            }
                            default: {
                                if (value == null) break block15;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block15;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String name) throws JMSException {
        block16: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return new Double(str);
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 25: {
                                return ((Datum)value).floatValue();
                            }
                            case 26: {
                                return ((Datum)value).doubleValue();
                            }
                            case 27: {
                                String str = (String)value;
                                return new Double(str);
                            }
                            default: {
                                if (value == null) break block16;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block16;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
        }
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    return (String)value;
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            if (val > 0) {
                                return "true";
                            }
                            return "false";
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: {
                            return ((Datum)value).stringValue();
                        }
                    }
                    return (String)value;
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public Object getObjectProperty(String name) throws JMSException {
        block23: {
            AQjmsPropDatum prop_datum = null;
            Object value = null;
            if (name == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    if (cl == m_strClass && (value = this.getSystemProperty(name)) != null) {
                        return value;
                    }
                    if (cl == m_intClass && (value = this.getSystemProperty(name)) != null) {
                        return new Integer(((Datum)value).intValue());
                    }
                    if (cl == m_longClass && (value = this.getSystemProperty(name)) != null) {
                        return new Long(((Datum)value).longValue());
                    }
                } else {
                    prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                    if (prop_datum != null) {
                        value = prop_datum.getValue();
                        int type = prop_datum.getType();
                        switch (type) {
                            case 20: {
                                int val1 = ((Datum)value).intValue();
                                return new Boolean(val1 > 0);
                            }
                            case 21: {
                                int val2 = ((Datum)value).intValue();
                                return new Byte((byte)val2);
                            }
                            case 22: {
                                int val3 = ((Datum)value).intValue();
                                return new Short((short)val3);
                            }
                            case 23: {
                                int val4 = ((Datum)value).intValue();
                                return new Integer(val4);
                            }
                            case 24: {
                                long val41 = ((Datum)value).longValue();
                                return new Long(val41);
                            }
                            case 25: {
                                float val5 = ((Datum)value).floatValue();
                                return new Float(val5);
                            }
                            case 26: {
                                double val6 = ((Datum)value).doubleValue();
                                return new Double(val6);
                            }
                            case 27: {
                                return value;
                            }
                            default: {
                                if (value == null) break block23;
                            }
                        }
                    }
                }
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            if (value == null) break block23;
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Vector<String> properties = new Vector<String>(this.msg_properties.size() + m_systemProperties.size());
        Enumeration enumeration = m_systemProperties.keys();
        while (enumeration.hasMoreElements()) {
            properties.addElement((String)enumeration.nextElement());
        }
        enumeration = this.msg_properties.keys();
        while (enumeration.hasMoreElements()) {
            properties.addElement((String)enumeration.nextElement());
        }
        return properties.elements();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(20, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(21, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(22, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsOracleDebug.println("setIntProperty: Property: " + name + " Value:  " + value);
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(23, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(25, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(26, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        this.checkPropertyValue(name, value);
        try {
            if (name.startsWith("JMS")) {
                this.setSystemProperty(name, value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        if (value == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShortProperty(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongProperty(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleProperty(name, (Double)value);
        } else if (value instanceof String) {
            this.setStringProperty(name, (String)value);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void acknowledge() throws JMSException {
        AQjmsError.throwEx(102);
    }

    public void clearBody() throws JMSException {
        AQjmsError.throwEx(103);
    }

    public AQjmsAgent getSenderID() throws JMSException {
        return this.sender_id;
    }

    public void setSenderID(AQjmsAgent sender) throws JMSException {
        this.sender_id = sender;
    }

    int getAttempts() throws JMSException {
        return this.attempts;
    }

    void setAttempts(int num_attempts) throws JMSException {
        this.attempts = num_attempts;
    }

    boolean isPropReadOnly() {
        return this.prop_read_only;
    }

    void setPropReadOnly(boolean value) {
        this.prop_read_only = value;
    }

    boolean isBodyReadOnly() {
        return this.access_mode == 0;
    }

    boolean isBodyWriteOnly() {
        return this.access_mode == 1;
    }

    boolean isBodyReadWrite() {
        return this.access_mode == 2;
    }

    void setAccessMode(int value) throws JMSException {
        if (value == 0 || value == 1 || value == 2) {
            this.access_mode = value;
        } else {
            AQjmsError.throwEx(152);
        }
    }

    static String ByteArraytoString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        if (b == null) {
            buf.append("");
        } else {
            int n = b.length;
            int i = 0;
            while (i < n) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                } else {
                    buf.append(Integer.toHexString(v));
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public static AQjmsPropertyList convertHashtableToPropertyList(Hashtable msg_props) throws JMSException {
        int num_props = 0;
        int i = 0;
        Enumeration value_enum = null;
        Enumeration name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        Object d_value = null;
        num_props = msg_props.size();
        AQjmsOracleDebug.println("Num props " + num_props);
        AQjmsProperty[] properties = new AQjmsProperty[num_props];
        name_enum = msg_props.keys();
        value_enum = msg_props.elements();
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "entry");
        try {
            i = 0;
            while (name_enum.hasMoreElements()) {
                curr_name = (String)name_enum.nextElement();
                curr_value = (AQjmsPropDatum)value_enum.nextElement();
                d_value = curr_value.getValue();
                properties[i] = new AQjmsProperty();
                AQjmsOracleDebug.println("Property: " + i);
                AQjmsOracleDebug.println("Name: " + curr_name + "  Type: " + curr_value.getType());
                if (d_value instanceof String) {
                    properties[i].setName(curr_name);
                    properties[i].setType(new Integer(100));
                    properties[i].setStrValue((String)d_value);
                    properties[i].setNumValue(null);
                    properties[i].setJavaType(new Integer(curr_value.getType()));
                    AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + (String)d_value + "  Str Type: " + curr_value.getType());
                } else if (d_value instanceof NUMBER) {
                    properties[i].setName(curr_name);
                    properties[i].setType(new Integer(200));
                    properties[i].setStrValue(null);
                    properties[i].setNumValue(((Datum)d_value).bigDecimalValue());
                    properties[i].setJavaType(new Integer(curr_value.getType()));
                    AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + ((Datum)d_value).bigDecimalValue() + "  Num Type: " + curr_value.getType());
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.convertHashtableToPropertyList", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                ++i;
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertHashtableToPropertyList", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsPropertyList prop_list = new AQjmsPropertyList(properties);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "exit");
        AQjmsMessage.printPropertyList(properties);
        return prop_list;
    }

    static Hashtable convertPropertyListToHashtable(AQjmsPropertyList prop_list) throws JMSException {
        Hashtable<String, AQjmsPropDatum> msg_props;
        int num_props = 0;
        int i = 0;
        Object value_enum = null;
        Object name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        NUMBER d_value = null;
        String s_value = null;
        int java_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "entry");
        try {
            num_props = prop_list.length();
            msg_props = new Hashtable<String, AQjmsPropDatum>();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "num_props: " + num_props);
            AQjmsProperty[] properties = new AQjmsProperty[num_props];
            i = 0;
            while (i < num_props) {
                properties[i] = prop_list.getElement(i);
                curr_name = properties[i].getName();
                Integer type = properties[i].getType();
                java_type = properties[i].getJavaType();
                if (type == 100) {
                    s_value = properties[i].getStrValue();
                    curr_value = new AQjmsPropDatum(java_type, s_value);
                } else if (type == 200) {
                    d_value = new NUMBER(properties[i].getNumValue());
                    curr_value = new AQjmsPropDatum(java_type, (Datum)d_value);
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.converPropertyListToHashtable", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                msg_props.put(curr_name, curr_value);
                ++i;
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "exit");
        return msg_props;
    }

    static void printPropertyList(AQjmsProperty[] properties) throws JMSException {
        int num_props = 0;
        int i = 0;
        Object value_enum = null;
        Object name_enum = null;
        String curr_name = null;
        Object curr_value = null;
        Object d_value = null;
        int java_type = 0;
        AQjmsOracleDebug.println("[PropertyList]");
        try {
            num_props = properties.length;
            i = 0;
            while (i < num_props) {
                curr_name = properties[i].getName();
                Integer type = properties[i].getType();
                AQjmsOracleDebug.print("Prop:" + i + "  Type: " + type);
                if (type == 100) {
                    AQjmsOracleDebug.println("  StrVal: " + properties[i].getStrValue());
                } else if (type == 200) {
                    AQjmsOracleDebug.println("  NumVal: " + properties[i].getNumValue());
                } else {
                    AQjmsOracleDebug.println("Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                java_type = properties[i].getJavaType();
                ++i;
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    void setSystemProperty(String name, Object value) throws JMSException, SQLException {
        try {
            if (m_systemProperties.containsKey(name)) {
                if (name.equals("JMSXUserID")) {
                    AQjmsError.throwEx(110, name);
                } else if (name.equals("JMSXAppID")) {
                    if (value instanceof String) {
                        this.header_ext.setAppid((String)value);
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (name.equals("JMSXDeliveryCount")) {
                    AQjmsError.throwEx(110, name);
                } else if (name.equals("JMSXGroupID")) {
                    if (value instanceof String) {
                        this.header_ext.setGroupid((String)value);
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (name.equals("JMSXGroupSeq")) {
                    if (value instanceof NUMBER) {
                        this.header_ext.setGroupseq(new Integer(((Datum)value).intValue()));
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (name.equals("JMSXProducerTXID")) {
                    AQjmsError.throwEx(110);
                } else if (name.equals("JMSXConsumerTXID")) {
                    AQjmsError.throwEx(110);
                } else if (name.equals("JMSXRecvTimestamp")) {
                    AQjmsError.throwEx(110, name);
                } else if (name.equals("JMSXState")) {
                    AQjmsError.throwEx(110, name);
                } else if (name.equals("JMS_OracleExcpQ")) {
                    if (value instanceof String) {
                        this.excp_queue = (String)value;
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (name.equals("JMS_OracleDelay")) {
                    if (value instanceof NUMBER) {
                        this.msg_delay = ((Datum)value).intValue();
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (name.equals("JMS_OracleOriginalMessageID")) {
                    AQjmsError.throwEx(110, name);
                } else {
                    AQjmsError.throwEx(140);
                }
            } else {
                AQjmsError.throwEx(140);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setSystemProperty-sqlex", sql_ex);
            throw sql_ex;
        }
    }

    Object getSystemProperty(String name) throws SQLException {
        String prop_value;
        block15: {
            prop_value = null;
            Object str_value = null;
            int num_value = 0;
            try {
                if (m_systemProperties.containsKey(name)) {
                    if (name.equals("JMSXUserID")) {
                        prop_value = this.header_ext.getUserid();
                        break block15;
                    }
                    if (name.equals("JMSXAppID")) {
                        prop_value = this.header_ext.getAppid();
                        break block15;
                    }
                    if (name.equals("JMSXDeliveryCount")) {
                        return null;
                    }
                    if (name.equals("JMSXGroupID")) {
                        prop_value = this.header_ext.getGroupid();
                        break block15;
                    }
                    if (name.equals("JMSXGroupSeq")) {
                        num_value = this.header_ext.getGroupseq();
                        prop_value = new NUMBER(num_value);
                        break block15;
                    }
                    if (name.equals("JMSXProducerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXConsumerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXRecvTimestamp")) {
                        prop_value = new NUMBER(this.recv_time);
                        break block15;
                    }
                    if (name.equals("JMSXState")) {
                        prop_value = new NUMBER(this.msg_state);
                        break block15;
                    }
                    if (name.equals("JMS_OracleExcpQ")) {
                        prop_value = this.excp_queue;
                        break block15;
                    }
                    if (name.equals("JMS_OracleDelay")) {
                        prop_value = new NUMBER(this.msg_delay);
                        break block15;
                    }
                    if (name.equals("JMS_OracleOriginalMessageID")) {
                        prop_value = this.orig_msg_id == null ? null : "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                        break block15;
                    }
                    return null;
                }
                return null;
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getSystemProperty-sqlex", sql_ex);
                throw sql_ex;
            }
        }
        return prop_value;
    }

    void setReceiveTime(long receive_time) {
        this.recv_time = receive_time;
    }

    void setMessageState(int state) throws JMSException {
        if (state == 0 || state == 1 || state == 2 || state == 3) {
            this.msg_state = state;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsMessage.setMessageState", "Internal error - invalid message state, msg_state: " + state);
            AQjmsError.throwEx(122);
        }
    }

    void setOriginalMessageId(byte[] id) throws JMSException {
        this.orig_msg_id = id;
    }

    void setExceptionQueue(String excp_q) {
        this.excp_queue = excp_q;
    }

    String getExceptionQueue() {
        return this.excp_queue;
    }

    void setDelay(int delay) {
        this.msg_delay = delay;
    }

    int getDelay() {
        return this.msg_delay;
    }

    void checkPropertyName(String name) throws JMSException {
        if (name == null) {
            AQjmsError.throwEx(139);
        }
        if (name.length() > 100) {
            AQjmsError.throwEx(148);
        }
    }

    void checkPropertyValue(String name, String value) throws JMSException {
        if (value != null) {
            if (name.equalsIgnoreCase("JMSXAppID") || name.equalsIgnoreCase("JMSXUserID") || name.equalsIgnoreCase("JMSXGroupID") || name.equalsIgnoreCase("JMSXType")) {
                if (value.length() > 100) {
                    AQjmsError.throwEx(165);
                }
            } else if (value.length() > 2000) {
                AQjmsError.throwEx(165);
            }
        }
    }

    void insertPropertyIntoTable(Hashtable table, String name, AQjmsPropDatum value) throws JMSException {
        if (table.size() < 100) {
            table.put(name, value);
        } else {
            AQjmsError.throwEx(132);
        }
    }

    private static void initSystemPropertyTypeTable() {
        m_systemProperties = new Hashtable();
        m_systemProperties.put("JMSXAppID", m_strClass);
        m_systemProperties.put("JMSXUserID", m_strClass);
        m_systemProperties.put("JMSXRecvTimestamp", m_longClass);
        m_systemProperties.put("JMSXState", m_intClass);
        m_systemProperties.put("JMSXDeliveryCount", m_intClass);
        m_systemProperties.put("JMSXGroupID", m_strClass);
        m_systemProperties.put("JMSXGroupSeq", m_intClass);
        m_systemProperties.put("JMS_OracleExcpQ", m_strClass);
        m_systemProperties.put("JMS_OracleDelay", m_longClass);
        m_systemProperties.put("JMS_OracleOriginalMessageID", m_strClass);
    }

    static {
        AQjmsMessage.initSystemPropertyTypeTable();
    }
}

