/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import javax.jms.JMSException;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsDeqSel;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParser;
import oracle.jms.ParseException;
import oracle.jms.TokenMgrError;

class AQjmsSelector {
    String selector;
    String rule;
    String sel_corr_id;
    byte[] sel_msg_id;
    int sel_type = 0;
    String adt_rule;

    AQjmsSelector(String selector, int dest_type, boolean is_adt_rule) throws JMSException {
        this.selector = selector;
        this.sel_corr_id = null;
        this.sel_msg_id = null;
        this.rule = null;
        this.adt_rule = null;
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "selector: " + selector + " dest_type: " + dest_type + " adt_rule: " + is_adt_rule);
        if (is_adt_rule) {
            this.setAdtRule(selector);
            this.sel_type = 40;
            return;
        }
        if (dest_type == 10) {
            try {
                this.sel_type = this.parseDeqSelector(String.valueOf(selector) + ";", dest_type);
                AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "selector_type: " + this.sel_type + "  sel_corr_id: " + this.sel_corr_id);
            }
            catch (TokenMgrError err) {
                AQjmsOracleDebug.traceErr(3, "Token Mgr Error - Invalid selector", err);
                AQjmsError.throwInvalidSelectorEx(159, "Token Mgr Error");
            }
        } else if (dest_type == 20) {
            if (this.sel_type == 0) {
                try {
                    this.rule = this.parseRule(String.valueOf(selector) + ";");
                }
                catch (TokenMgrError err) {
                    AQjmsOracleDebug.traceErr(3, "Token Mgr Error - Invalid selector", err);
                    AQjmsError.throwInvalidSelectorEx(159, "Token Mgr Error");
                }
                if (this.rule != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule_len: " + this.rule.length());
                    AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule: " + this.rule);
                }
                if (this.rule.length() > 4000) {
                    AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error - exceeded " + 4000 + " characters");
                }
                this.sel_type = 10;
            }
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSelector-constructor", "INTERNAL_ERROR - invalid destination type");
            AQjmsError.throwEx(122, "Invalid destination type");
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", this.getTrace());
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "exit");
    }

    public int parseDeqSelector(String parser_input, int dest_type) throws JMSException {
        AQjmsDeqSel parser = null;
        String expr = null;
        int sel_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "entry");
        byte[] bytearray = parser_input.getBytes();
        ByteArrayInputStream bytestream = new ByteArrayInputStream(bytearray);
        parser = new AQjmsDeqSel(bytestream);
        try {
            expr = parser.DequeueSelector();
            AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "expr: " + expr);
            if (expr.equals("JMSCorrelationID")) {
                if (dest_type == 10) {
                    sel_type = 20;
                    this.sel_corr_id = parser.corr_id;
                    AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_corr_id: " + this.sel_corr_id);
                } else {
                    sel_type = 0;
                    this.sel_corr_id = null;
                }
            } else if (expr.equals("JMSMessageID")) {
                sel_type = 30;
                this.sel_msg_id = parser.msg_id;
                AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_msg_id: " + RepConversion.bArray2String((byte[])this.sel_msg_id));
            } else {
                sel_type = 0;
            }
        }
        catch (ParseException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseDeqSelector- parseEx", ex);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error", ex);
        }
        catch (TokenMgrError err) {
            AQjmsOracleDebug.traceErr(3, "AQjmsSelector.parseDeqSelector- TokenMgrErr", err);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error: " + err.getMessage());
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_type" + sel_type);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "exit");
        return sel_type;
    }

    public String parseRule(String parser_input) throws JMSException {
        AQjmsParser parser = null;
        String rule = null;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "entry");
        byte[] bytearray = parser_input.getBytes();
        ByteArrayInputStream bytestream = new ByteArrayInputStream(bytearray);
        parser = new AQjmsParser(bytestream);
        try {
            rule = parser.SubscriberRule();
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseRule - parseEx", ex);
            AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error", ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseRule", "rule: " + rule);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "exit");
        return rule;
    }

    String getSelectorString() {
        return this.selector;
    }

    int getSelectorType() {
        return this.sel_type;
    }

    String getRule() {
        return this.rule;
    }

    String getSelectorCorrelationId() {
        return this.sel_corr_id;
    }

    byte[] getSelectorMessageId() {
        return this.sel_msg_id;
    }

    String getAdtRule() {
        return this.adt_rule;
    }

    void setAdtRule(String selector) throws JMSException {
        if (selector.length() > 4000) {
            AQjmsError.throwInvalidSelectorEx(159, "Adt Selector Parse error - exceeded " + 4000 + " characters");
        }
        this.adt_rule = selector;
        AQjmsOracleDebug.trace(5, "AQjmsSelector.setAdtRule", "adt_rule: " + this.adt_rule);
    }

    String getTrace() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQjmsSelector]");
        buf.append("\n  selector         : " + this.selector);
        buf.append("\n  rule             : " + this.rule);
        buf.append("\n  sel_corr_id      : " + this.sel_corr_id);
        buf.append("\n  adt_rule         : " + this.adt_rule);
        buf.append("\n  sel_msg_id       : " + AQjmsMessage.ByteArraytoString(this.sel_msg_id));
        buf.append("\n  sel_type         : " + this.sel_type);
        buf.append("\n");
        return buf.toString();
    }
}

