/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAdmin;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsProducer;
import oracle.jms.AQjmsQueueBrowser;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AdtMessage;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;

public class AQjmsSession
implements QueueSession,
TopicSession {
    int cl_check_interval = 120;
    AQjmsConnection jms_conn;
    int ack_mode;
    boolean transacted;
    int sess_type;
    private CallableStatement rems_stmt;
    private CallableStatement adds_stmt;
    private CallableStatement alts_stmt;
    private Hashtable prod_list;
    private Hashtable cons_list;
    private Hashtable qbrowser_list;
    private volatile boolean close_in_progress;
    private QueueBrowser queue_browser;
    private MessageListener privileged_listener;
    long oci_env_handle;
    long oci_err_handle;
    long oci_svc_handle;
    long oci_aq_cntxt;
    OracleCallableStatement st_text;
    OracleCallableStatement st_bytes;
    OracleCallableStatement st_map;
    OracleCallableStatement st_stream;
    OracleCallableStatement st_object;
    OracleCallableStatement st_adt;
    OracleCallableStatement st_adt_rep;
    OracleCallableStatement reg_stmt;
    OracleCallableStatement unreg_stmt;
    OracleCallableStatement deq_stmt;
    Connection db_conn;
    boolean cache_deq_stmt = false;
    static boolean loaded_library;
    private AQjmsEventListener evtListener;

    AQjmsSession(AQjmsConnection jms_conn, int ack_mode, boolean transacted, int type) throws JMSException {
        this.jms_conn = jms_conn;
        this.ack_mode = ack_mode;
        this.transacted = transacted;
        this.db_conn = jms_conn.db_conn;
        this.rems_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        if (type == 10 || type == 20) {
            this.sess_type = type;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Invalid type - not a Queue or Topic");
            AQjmsError.throwEx(122, "invalid type");
        }
        this.prod_list = new Hashtable();
        this.cons_list = new Hashtable();
        this.qbrowser_list = new Hashtable();
        this.close_in_progress = false;
        this.queue_browser = null;
        this.privileged_listener = null;
        this.cache_deq_stmt = false;
        String drv = jms_conn.getDriver();
        if (drv != null && drv.equalsIgnoreCase("oci8")) {
            this.getOCIHandles();
        }
    }

    private native long ociinit(long[] var1, int var2) throws Exception;

    public synchronized BytesMessage createBytesMessage() throws JMSException {
        AQjmsBytesMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsBytesMessage();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createBytesMesage", "returning bytes message");
        return message;
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        AQjmsMapMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsMapMessage();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMapMessage", "returning map message");
        return message;
    }

    public synchronized Message createMessage() throws JMSException {
        AQjmsError.throwEx(102, " - use specific message types");
        return null;
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        AQjmsObjectMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return object message");
        return message;
    }

    public synchronized ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        AQjmsObjectMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage();
        message.setObject(object);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return initialized object message");
        return message;
    }

    public synchronized AdtMessage createAdtMessage() throws JMSException {
        AQjmsAdtMessage message = null;
        message = this.createAdtMessage(null);
        return message;
    }

    public synchronized AQjmsAdtMessage createAdtMessage(CustomDatum payload) throws JMSException {
        AQjmsAdtMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        AQjmsStreamMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsStreamMessage();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createStreamMessage", "return stream message");
        return message;
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        AQjmsTextMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        AQjmsTextMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage();
        message.setText(stringBuffer.toString());
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(String text) throws JMSException {
        AQjmsTextMessage message = null;
        Object db_conn = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage();
        message.setText(text);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized boolean getTransacted() throws JMSException {
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        return this.transacted;
    }

    public synchronized void commit() throws JMSException {
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.commit();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public synchronized void rollback() throws JMSException {
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.rollback();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.closing", "session closing ...");
        this.close_in_progress = true;
        this.closeSessionResources();
        AQjmsOracleDebug.trace(4, "AQjmsSession.close", "session closed.");
    }

    synchronized void closeSessionResources() {
        AQjmsConnection curr_jms_conn = null;
        Object db_conn = null;
        Session jms_conn_sess = null;
        Enumeration producers = null;
        Enumeration consumers = null;
        AQjmsProducer curr_prod = null;
        AQjmsConsumer curr_cons = null;
        Enumeration browsers = null;
        AQjmsQueueBrowser curr_browser = null;
        if (this.jms_conn == null) {
            return;
        }
        curr_jms_conn = this.jms_conn;
        this.jms_conn = null;
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.adds_stmt != null) {
                this.adds_stmt.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
            }
        }
        catch (Exception exception) {}
        this.destroyStmt(this.st_text);
        this.destroyStmt(this.st_bytes);
        this.destroyStmt(this.st_map);
        this.destroyStmt(this.st_object);
        this.destroyStmt(this.st_stream);
        this.destroyStmt(this.st_adt);
        this.destroyStmt(this.st_adt_rep);
        this.destroyStmt(this.reg_stmt);
        this.destroyStmt(this.unreg_stmt);
        this.destroyStmt(this.deq_stmt);
        browsers = this.qbrowser_list.elements();
        while (browsers.hasMoreElements()) {
            curr_browser = (AQjmsQueueBrowser)browsers.nextElement();
            try {
                curr_browser.close();
            }
            catch (Exception exception) {}
        }
        producers = this.prod_list.elements();
        while (producers.hasMoreElements()) {
            curr_prod = (AQjmsProducer)producers.nextElement();
            try {
                curr_prod.close();
            }
            catch (Exception exception) {}
        }
        try {
            if (this.privileged_listener != null) {
                Enumeration e = this.cons_list.elements();
                while (e.hasMoreElements()) {
                    AQjmsConsumer currCons = (AQjmsConsumer)e.nextElement();
                    currCons.unregister(this.evtListener.getPort(), curr_jms_conn);
                }
                this.privileged_listener = null;
            }
            if (this.evtListener != null) {
                this.evtListener.removeSession(this);
                this.evtListener = null;
            }
        }
        catch (Exception exception) {}
        AQjmsOracleDebug.trace(5, "AQjmsSession.close", "listener removed");
        consumers = this.cons_list.elements();
        while (consumers.hasMoreElements()) {
            curr_cons = (AQjmsConsumer)consumers.nextElement();
            try {
                curr_cons.closeFromSession(curr_jms_conn);
            }
            catch (Exception exception) {}
        }
        if (curr_jms_conn != null && (jms_conn_sess = curr_jms_conn.getJmsSession()) != null && jms_conn_sess.equals(this)) {
            curr_jms_conn.clearJmsSession();
        }
    }

    public void recover() throws JMSException {
        AQjmsError.throwEx(102);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.privileged_listener;
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        boolean port = false;
        this.privileged_listener = listener;
        this.evtListener = this.jms_conn.createEventListener();
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer currCons = (AQjmsConsumer)e.nextElement();
            currCons.register(this.evtListener.getPort());
        }
        this.evtListener.addSession(this, this.cons_list);
        if (this.jms_conn.isConnectionStarted()) {
            this.evtListener.startAQjmsEventListener();
        }
    }

    synchronized boolean pollMessage(AQjmsConsumer cons) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.pollMessage", "enter-exit");
        return cons.pollMessage(this.privileged_listener);
    }

    synchronized void notifySession(Hashtable mProp, Hashtable consWListener) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.notifySession", "enter");
        if (!this.jms_conn.isConnectionStarted()) {
            return;
        }
        Hashtable consToNotify = this.privileged_listener != null ? this.cons_list : consWListener;
        Enumeration e = consToNotify.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer currCons = (AQjmsConsumer)e.nextElement();
            currCons.notifyConsumer(mProp, this.privileged_listener);
        }
    }

    public Queue createQueue(String queueName) throws JMSException {
        AQjmsError.throwEx(102, "- use AQjmsSession.createQueue instead");
        return null;
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        AQjmsConsumer receiver = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (queue == null) {
            AQjmsError.throwEx(143);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueReceiver createReceiver(Queue queue, CustomDatumFactory payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (queue == null) {
            AQjmsError.throwEx(143);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payload_factory);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.createReceiver(queue, messageSelector, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String messageSelector, CustomDatumFactory payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (queue == null) {
            AQjmsError.throwEx(143);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = new AQjmsSelector(messageSelector, 10, false);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createReceiver", "Selector: " + jms_sel);
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payload_factory, jms_sel);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        AQjmsProducer sender = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (!(queue == null || queue instanceof AQjmsDestination && ((AQjmsDestination)queue).isQueue())) {
            AQjmsError.throwInvalidDestEx(125);
        }
        sender = new AQjmsProducer(this, (AQjmsDestination)queue, 10);
        this.prod_list.put(sender, sender);
        return sender;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, CustomDatumFactory payload_factory) throws JMSException {
        return this.createBrowser(queue, null, payload_factory, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, boolean locked) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, locked);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, CustomDatumFactory payload_factory) throws JMSException {
        return this.createBrowser(queue, messageSelector, payload_factory, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, CustomDatumFactory payload_factory, boolean locked) throws JMSException {
        AQjmsQueueBrowser browser = null;
        int deq_mode = 1;
        AQjmsSelector jms_sel = null;
        Object ptype = null;
        String qname = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (queue == null) {
            AQjmsError.throwEx(143);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.qbrowser_list.get(qname = ((AQjmsDestination)queue).getCompleteName()) != null) {
            AQjmsError.throwEx(196);
        }
        if (locked) {
            deq_mode = 2;
        }
        if (queue == null) {
            AQjmsError.throwEx(143);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = new AQjmsSelector(messageSelector, 10, false);
        }
        browser = new AQjmsQueueBrowser((Session)this, (Destination)queue, 10, deq_mode, null, jms_sel, payload_factory);
        this.qbrowser_list.put(qname, browser);
        return browser;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        AQjmsError.throwEx(102, "");
        return null;
    }

    public Topic createTopic(String topicName) throws JMSException {
        AQjmsError.throwEx(102, "use AQjmsSession.createTopic instead");
        return null;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        AQjmsError.throwEx(102, "");
        return null;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        AQjmsError.throwEx(102, "");
        return null;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, CustomDatumFactory payload_factory) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, payload_factory);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal) throws JMSException {
        if (noLocal) {
            AQjmsError.throwEx(102, "NoLocal=true");
        }
        return this.createDurableSubscriber(topic, subs_name, messageSelector, noLocal, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal, CustomDatumFactory payload_factory) throws JMSException {
        AQjmsAgent agent = null;
        TopicSubscriber subscriber = null;
        Object dest = null;
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        String ptype = null;
        db_conn = this.getDBConnection();
        if (subs_name == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        try {
            agent = new AQjmsAgent();
            agent.setName(subs_name);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createDurableSubscriber - error createing agent", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            ptype = ((AQjmsDestination)topic).getAdtType();
            if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, false);
            } else {
                if (payload_factory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector(messageSelector, 20, true);
            }
        }
        try {
            subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false);
        }
        catch (AQjmsException aq_ex) {
            if (aq_ex.getErrorNumber() == 24034) {
                subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, payload_factory, false);
            }
            throw aq_ex;
        }
        this.cons_list.put(subscriber, subscriber);
        return subscriber;
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector) throws JMSException {
        this.createRemoteSubscriber(topic, remote_subscriber, messageSelector, null);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector, CustomDatumFactory payload_factory) throws JMSException {
        Object dest = null;
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        String ptype = null;
        String remote_dest = null;
        db_conn = this.getDBConnection();
        if (remote_subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remote_subscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createRemoteSubscriber1 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            ptype = ((AQjmsDestination)topic).getAdtType();
            if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, false);
            } else {
                if (payload_factory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector(messageSelector, 20, true);
            }
        }
        try {
            this.addDurableSubscriber(topic, remote_subscriber, jms_sel, false, null, true);
        }
        catch (AQjmsException aq_ex) {
            if (aq_ex.getErrorNumber() == 24034) {
                this.alterDurableSubscriber(topic, remote_subscriber, jms_sel, null, true);
            }
            throw aq_ex;
        }
    }

    synchronized void removeRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber) throws JMSException {
        String remote_dest = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (remote_subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remote_subscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeRemoteSubscriber2 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        this.removeSubscriber(topic, remote_subscriber);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiver_name, String messageSelector) throws JMSException {
        return this.createTopicReceiver(topic, receiver_name, messageSelector, null);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiver_name, String messageSelector, CustomDatumFactory payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (topic == null) {
            AQjmsError.throwEx(143);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = new AQjmsSelector(messageSelector, 10, false);
        }
        receiver = new AQjmsConsumer(this, (Destination)topic, 20, 3, receiver_name, payload_factory, jms_sel);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    synchronized TopicSubscriber addDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean noLocal, CustomDatumFactory payload_factory, boolean remote) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Hashtable map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                }
            }
            if (this.adds_stmt != null) {
                this.adds_stmt.clearParameters();
            } else {
                this.adds_stmt = db_conn.prepareCall("begin dbms_aqjms.aq$_add_subscriber(?, ?, ?); end;");
            }
            this.adds_stmt.setString(1, t_name);
            this.adds_stmt.setObject(2, (Object)agt, 2002);
            this.adds_stmt.setString(3, rule);
            this.adds_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.adds_stmt.close();
            }
            catch (Exception exception) {}
            this.adds_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    synchronized TopicSubscriber alterDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, CustomDatumFactory payload_factory, boolean remote) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Hashtable map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Rule: " + rule);
                }
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                this.alts_stmt = db_conn.prepareCall("begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?); end;");
            }
            this.alts_stmt.setString(1, t_name);
            this.alts_stmt.setObject(2, (Object)agt, 2002);
            this.alts_stmt.setString(3, rule);
            this.alts_stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Subscriber");
        }
        catch (SQLException sqlex) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {}
            this.alts_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.alterDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        AQjmsProducer publisher = null;
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
        if (!(topic == null || topic instanceof AQjmsDestination && ((AQjmsDestination)topic).isTopic())) {
            AQjmsError.throwInvalidDestEx(126);
        }
        publisher = new AQjmsProducer(this, (AQjmsDestination)topic, 20);
        this.prod_list.put(publisher, publisher);
        return publisher;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        AQjmsError.throwEx(102, "");
        return null;
    }

    public synchronized void unsubscribe(String subs_name) throws JMSException {
        AQjmsError.throwEx(102, "use AQjmsSession.unsubscribe(Topic, subs_name) instead");
    }

    public synchronized void unsubscribe(Topic topic, String subs_name) throws JMSException {
        Object subscriber = null;
        AQjmsAgent agent = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (subs_name == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        try {
            agent = new AQjmsAgent();
            agent.setName(subs_name);
            this.removeSubscriber(topic, agent);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public synchronized void unsubscribe(Topic topic, AQjmsAgent remote_subscriber) throws JMSException {
        this.removeRemoteSubscriber(topic, remote_subscriber);
    }

    synchronized void removeSubscriber(Topic topic, AQjmsAgent subscriber) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Hashtable map = null;
        String subs_addr = null;
        int subs_prot = 0;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            t_name = ((AQjmsDestination)topic).getCompleteName();
            subs_name = subscriber.getName();
            subs_addr = subscriber.getAddress();
            subs_prot = subscriber.getProtocol();
            try {
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                this.rems_stmt = db_conn.prepareCall("begin dbms_aqjms.aq$_remove_subscriber(queue => ?, subscriber => ?); end;");
            }
            this.rems_stmt.setString(1, t_name);
            this.rems_stmt.setObject(2, (Object)agt, 2002);
            this.rems_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            catch (Exception exception) {}
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
    }

    public void run() {
    }

    public synchronized Connection getDBConnection() throws JMSException {
        if (!this.isSessionClosed()) {
            return this.jms_conn.getDBConnection();
        }
        AQjmsError.throwEx(131);
        return null;
    }

    private void checkSessionStarted() throws JMSException {
        if (this.isSessionClosed()) {
            AQjmsError.throwEx(131);
        }
    }

    public AQjmsConnection getJmsConnection() throws JMSException {
        if (!this.isSessionClosed()) {
            return this.jms_conn;
        }
        AQjmsError.throwEx(131);
        return null;
    }

    public synchronized AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.createQueueTable(owner, name, property);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized AQQueueTable getQueueTable(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.getQueueTable(owner, name);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized Queue createQueue(AQQueueTable q_table, String queue_name, AQjmsDestinationProperty dest_property) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (dest_property == null) {
            AQjmsError.throwEx(121);
        }
        if (q_table == null) {
            AQjmsError.throwEx(187);
        }
        if (((AQOracleQueueTable)q_table).isMulticonsumerEnabled()) {
            AQjmsError.throwEx(144);
        }
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(q_table, queue_name, dest_property);
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty());
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_queue;
    }

    public synchronized Topic createTopic(AQQueueTable q_table, String topic_name, AQjmsDestinationProperty dest_property) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (q_table == null) {
            AQjmsError.throwEx(187);
        }
        if (dest_property == null) {
            AQjmsError.throwEx(121);
        }
        if (dest_property.getQueueType() == 1) {
            AQjmsError.throwEx(151);
        }
        if (!((AQOracleQueueTable)q_table).isMulticonsumerEnabled()) {
            AQjmsError.throwEx(142);
        }
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(q_table, topic_name, dest_property);
            AQjmsOracleDebug.trace(5, "AQjmsSession.createTopic", "Queue table: " + aq_queue.getQueueTableName());
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty());
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_topic;
    }

    public synchronized Queue getQueue(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty());
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (q_table.isMulticonsumerEnabled() && dest_property.getQueueType() != 1) {
                AQjmsError.throwEx(130);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_queue;
    }

    public synchronized Topic getTopic(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty());
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (!q_table.isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_topic;
    }

    boolean isSessionClosed() throws JMSException {
        boolean closed = false;
        if (this.close_in_progress) {
            return true;
        }
        if (this.jms_conn == null) {
            closed = true;
        } else {
            if (this.jms_conn.isConnectionClosed()) {
                this.jms_conn = null;
                closed = true;
            }
            closed = false;
        }
        return closed;
    }

    int getCloseCheckInterval() {
        return this.cl_check_interval;
    }

    public synchronized void setCloseCheckInterval(int interval) throws JMSException {
        if (interval >= 30) {
            this.cl_check_interval = interval;
        } else {
            AQjmsError.throwEx(123, Integer.toString(30));
        }
    }

    public void grantSystemPrivilege(String privilege, String grantee, boolean admin_option) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.grantSystemPrivilege(sess, privilege, grantee, admin_option);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.grantSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeSystemPrivilege(String privilege, String grantee) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.revokeSystemPrivilege(sess, privilege, grantee);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.revokeSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public boolean isDeqStmtCachingEnabled() {
        return this.cache_deq_stmt;
    }

    public void setDeqStmtCachingFlag(boolean value) {
        this.cache_deq_stmt = value;
    }

    void closeQueueBrowser(String qname) {
        try {
            this.qbrowser_list.remove(qname);
        }
        catch (Exception exception) {}
    }

    OracleCallableStatement getTextStmt() throws SQLException {
        if (this.st_text == null) {
            this.st_text = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_text_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_text.clearParameters();
        }
        return this.st_text;
    }

    OracleCallableStatement getMapStmt() throws SQLException {
        if (this.st_map == null) {
            this.st_map = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_map_message( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_map.clearParameters();
        }
        return this.st_map;
    }

    OracleCallableStatement getStreamStmt() throws SQLException {
        if (this.st_stream == null) {
            this.st_stream = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_stream_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_stream.clearParameters();
        }
        return this.st_stream;
    }

    OracleCallableStatement getBytesStmt() throws SQLException {
        if (this.st_bytes == null) {
            this.st_bytes = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_bytes_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_bytes.clearParameters();
        }
        return this.st_bytes;
    }

    OracleCallableStatement getObjectStmt() throws SQLException {
        if (this.st_object == null) {
            this.st_object = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_object_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_object.clearParameters();
        }
        return this.st_object;
    }

    OracleCallableStatement getAdtStmt() throws SQLException {
        if (this.st_adt == null) {
            this.st_adt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?,exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ? ); end; ");
        } else {
            this.st_adt.clearParameters();
        }
        return this.st_adt;
    }

    OracleCallableStatement getAdtNoRecplStmt() throws SQLException {
        if (this.st_adt_rep == null) {
            this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ? ); end; ");
        } else {
            this.st_adt_rep.clearParameters();
        }
        return this.st_adt_rep;
    }

    OracleCallableStatement getRegisterStmt() throws SQLException {
        if (this.reg_stmt == null) {
            this.reg_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms.aq$_register(?, ?, ?, ?, ?, ?, ?); end;");
        } else {
            this.reg_stmt.clearParameters();
        }
        return this.reg_stmt;
    }

    OracleCallableStatement getUnregisterStmt() throws SQLException {
        if (this.unreg_stmt == null) {
            this.unreg_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms.aq$_unregister(?, ?, ?, ?, ?); end;");
        } else {
            this.unreg_stmt.clearParameters();
        }
        return this.unreg_stmt;
    }

    OracleCallableStatement getDequeueStmt() throws SQLException {
        if (this.deq_stmt == null) {
            this.deq_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_stmt.clearParameters();
        }
        return this.deq_stmt;
    }

    void destroyStmt(OracleCallableStatement stmt) {
        block22: {
            if (stmt == null) {
                return;
            }
            boolean del = false;
            if (stmt == this.st_text) {
                this.st_text = null;
                del = true;
            } else if (stmt == this.st_map) {
                this.st_map = null;
                del = true;
            } else if (stmt == this.st_bytes) {
                this.st_bytes = null;
                del = true;
            } else if (stmt == this.st_stream) {
                this.st_stream = null;
                del = true;
            } else if (stmt == this.st_object) {
                this.st_object = null;
                del = true;
            } else if (stmt == this.st_adt) {
                this.st_adt = null;
                del = true;
            } else if (stmt == this.st_adt_rep) {
                this.st_adt_rep = null;
                del = true;
            } else if (stmt == this.reg_stmt) {
                this.reg_stmt = null;
                del = true;
            } else if (stmt == this.unreg_stmt) {
                this.unreg_stmt = null;
                del = true;
            } else if (stmt == this.deq_stmt) {
                this.deq_stmt = null;
                del = true;
            }
            if (!del) break block22;
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    void getOCIHandles() throws JMSException {
        Properties prop = new Properties();
        Connection db_conn = this.getDBConnection();
        try {
            if (!loaded_library) {
                System.loadLibrary("oraclient8");
                loaded_library = true;
            }
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.loadLibrary excp:", ex);
        }
        catch (Error err) {
            AQjmsOracleDebug.traceErr(3, "AQjmsSession.loadLibrary error:", err);
        }
        try {
            prop = ((OracleConnection)db_conn).getDBAccessProperties();
        }
        catch (Exception e) {
            AQjmsError.throwEx(122, "Properties Not Found", e);
        }
        this.oci_env_handle = Long.parseLong(prop.getProperty("OCIEnvHandle"));
        this.oci_err_handle = Long.parseLong(prop.getProperty("OCIErrHandle"));
        this.oci_svc_handle = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
        long[] l = new long[]{this.oci_env_handle, this.oci_err_handle, this.oci_svc_handle};
        try {
            this.oci_aq_cntxt = this.ociinit(l, AQjmsOracleDebug.getTraceLevel());
        }
        catch (Exception e) {
            AQjmsError.throwEx(122, "OCI Init failed!", e);
        }
    }

    synchronized void register(int port, AQjmsConsumer consumer) throws JMSException {
        OracleCallableStatement reg_stmt = null;
        ResultSet reg_rset = null;
        Object location = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "enter");
        try {
            reg_stmt = this.getRegisterStmt();
            reg_stmt.setString(1, consumer.cons_dest.getQueueOwner().toUpperCase());
            String subname = consumer.dest_type == 20 ? String.valueOf(consumer.cons_dest.getCompleteName()) + ':' + consumer.cons_name : consumer.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "Subname " + subname);
            reg_stmt.setString(2, subname.toUpperCase());
            AQjmsOracleDebug.println("protocol http:");
            reg_stmt.setString(3, "http://");
            String address = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "address " + address);
            reg_stmt.setString(4, address);
            Integer iport = new Integer(port);
            reg_stmt.setObject(5, (Object)iport, 4);
            Integer ipresent = new Integer(1);
            reg_stmt.setObject(6, (Object)ipresent, 4);
            Integer iversion = new Integer(1);
            reg_stmt.setObject(7, (Object)iversion, 4);
            reg_rset = reg_stmt.executeQuery();
        }
        catch (Exception ex1) {
            this.destroyStmt(reg_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.register-ex1", ex1);
            AQjmsError.throwEx(199, ex1);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "exit");
    }
}

