/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.StreamMessage;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.sql.BLOB;
import oracle.sql.CustomDatumFactory;

public class AQjmsStreamMessage
extends AQjmsMessage
implements StreamMessage {
    byte[] bytes_data;
    AQjmsStreamMessage_C stream_msg_cont;
    ByteArrayInputStream bytes_instream;
    ObjectInputStream bytes_objectinstream;
    ByteArrayOutputStream bytes_outstream;
    ObjectOutputStream bytes_objectoutstream;

    AQjmsStreamMessage() throws JMSException {
        this.bytes_data = null;
        try {
            this.stream_msg_cont = new AQjmsStreamMessage_C();
            this.stream_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsStreamMessage(AQjmsStreamMessage_C msg_cont) throws JMSException {
        this.bytes_data = null;
        try {
            this.stream_msg_cont = msg_cont;
            this.header_ext = this.stream_msg_cont.getHeader();
            this.readStreamMessageContainer();
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsStreamMessage(byte[] bdata) throws JMSException {
        try {
            this.bytes_data = bdata;
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.stream_msg_cont != null) {
                this.stream_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public boolean readBoolean() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return false;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return false;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return false;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return false;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return false;
        }
    }

    public byte readByte() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public short readShort() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Byte) {
                return ((Byte)value).shortValue();
            }
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public char readChar() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return '\u0000';
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return '\u0000';
            }
            if (value instanceof Character) {
                return ((Character)value).charValue();
            }
            if (value instanceof String) {
                return ((String)value).charAt(0);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return '\u0000';
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return '\u0000';
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return '\u0000';
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return '\u0000';
        }
    }

    public int readInt() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (value instanceof Byte) {
                return ((Byte)value).intValue();
            }
            if (value instanceof Short) {
                return ((Short)value).intValue();
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public long readLong() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0L;
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0L;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0L;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0L;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0L;
        }
    }

    public float readFloat() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0f;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0.0f;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                return Float.valueOf((String)value).floatValue();
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0.0f;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0.0f;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0.0f;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0.0f;
        }
    }

    public double readDouble() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0.0;
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0.0;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0.0;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0.0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0.0;
        }
    }

    public String readString() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                return value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return null;
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return null;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return null;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return null;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return null;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        Object obj_value = null;
        ByteArrayInputStream binstream = null;
        int bytes_read = 0;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            obj_value = this.bytes_objectinstream.readObject();
            if (obj_value instanceof Byte || obj_value instanceof Short || obj_value instanceof Character || obj_value instanceof Integer || obj_value instanceof Long || obj_value instanceof Float || obj_value instanceof Double || obj_value instanceof String) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (obj_value instanceof byte[]) {
                binstream = new ByteArrayInputStream((byte[])obj_value);
                bytes_read = binstream.read(value);
                return bytes_read;
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException cnf_ex) {
            AQjmsError.throwMsgFormatEx(161, cnf_ex.getMessage());
            return 0;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Boolean new_value = new Boolean(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Byte new_value = new Byte(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Short new_value = new Short(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Character new_value = new Character(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Integer new_value = new Integer(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Long new_value = new Long(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Float new_value = new Float(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Double new_value = new Double(value);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeString(String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_objectoutstream.writeObject(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_objectoutstream.writeObject(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        byte[] new_value = new byte[length];
        ByteArrayInputStream binstream = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                binstream = new ByteArrayInputStream(value, offset, length);
                binstream.read(new_value, 0, length);
                this.bytes_objectoutstream.writeObject(new_value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeObject(Object value) throws JMSException {
        block6: {
            if (this.isBodyReadOnly()) {
                AQjmsError.throwMsgNotWriteableEx(163);
            } else {
                try {
                    if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String) {
                        this.bytes_objectoutstream.writeObject(value);
                        break block6;
                    }
                    if (value instanceof byte[]) {
                        this.bytes_objectoutstream.writeObject(value);
                        break block6;
                    }
                    AQjmsError.throwMsgFormatEx(161, null);
                }
                catch (IOException io_ex) {
                    AQjmsError.throwEx(157, io_ex.getMessage());
                }
            }
        }
    }

    public Object readObject() throws JMSException {
        Object value = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        try {
            value = this.bytes_objectinstream.readObject();
            return value;
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return null;
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsError.throwEx(109, cnf_exp.getMessage());
            return null;
        }
        catch (InvalidClassException ic_exp) {
            AQjmsError.throwEx(156, ic_exp.getMessage());
            return null;
        }
        catch (IOException io_exp) {
            AQjmsError.throwEx(157, io_exp.getMessage());
            return null;
        }
    }

    public void reset() throws JMSException {
        byte[] bdata = null;
        bdata = this.getBytesData();
        this.setAccessMode(0);
        this.setPropReadOnly(true);
        try {
            this.bytes_instream = new ByteArrayInputStream(bdata);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream.reset();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
        }
    }

    public void clearBody() throws JMSException {
        this.bytes_data = null;
        this.setAccessMode(1);
        this.setPropReadOnly(false);
        this.bytes_outstream.reset();
        try {
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
        }
    }

    AQjmsStreamMessage_C getStreamMessageCont() {
        return this.stream_msg_cont;
    }

    byte[] getBytesData() {
        if (this.bytes_data == null) {
            this.bytes_data = this.bytes_outstream.toByteArray();
        }
        return this.bytes_data;
    }

    void readStreamMessageContainer() throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.readBytesMessageContainer", "entry");
        try {
            bytes_len = this.stream_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.readStreamMessageContainer", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                bytes_lob = this.stream_msg_cont.getBytesLob();
                if (bytes_lob != null) {
                    b_data = bytes_lob.getBytes(1L, bytes_len);
                }
                this.bytes_data = b_data;
            } else {
                b_data = this.stream_msg_cont.getBytesRaw();
                this.bytes_data = b_data;
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.readStreamMessageContainer", "exit");
    }

    void populateStreamMessageContainer() throws JMSException {
        Object bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.populateStreamMessageContainer", "entry");
        try {
            this.stream_msg_cont.setHeader(this.header_ext);
            b_data = this.getBytesData();
            bytes_len = this.bytes_data.length;
            this.reset();
            this.stream_msg_cont.setBytesLen(new Integer(bytes_len));
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.populateStreamMessageContainer", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                this.stream_msg_cont.setBytesRaw(null);
            } else {
                this.stream_msg_cont.setBytesRaw(b_data);
                this.stream_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.populateStreamMessageContainer", "exit");
    }

    void write_blob(Connection db_conn, String q_table, byte[] msg_id) throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        int b_len = 0;
        OracleCallableStatement blob_stmt = null;
        ResultSet rset = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.write_blob", "entry");
        try {
            b_data = this.getBytesData();
            bytes_len = b_data.length;
            if (q_table == null) {
                AQjmsOracleDebug.trace(1, "AQjmsStreamMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.write_blob", "- bytes_len: " + bytes_len + "   qtable: " + q_table);
            if (bytes_len > 2000) {
                CustomDatumFactory payload_fact = AQjmsStreamMessage_C.getFactory();
                blob_stmt = (OracleCallableStatement)db_conn.prepareCall("SELECT user_data FROM " + q_table + " where msgid = ?");
                blob_stmt.setBytes(1, msg_id);
                rset = blob_stmt.executeQuery();
                if (rset.next()) {
                    AQjmsStreamMessage_C stream_msg_c = (AQjmsStreamMessage_C)((OracleResultSet)rset).getCustomDatum(1, payload_fact);
                    bytes_lob = stream_msg_c.getBytesLob();
                }
                if (bytes_lob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsStreamMessage.write_blob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                b_len = bytes_lob.putBytes(1L, b_data);
                try {
                    blob_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sql_ex) {
            try {
                if (blob_stmt != null) {
                    blob_stmt.close();
                }
            }
            catch (Exception exception) {}
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.write_blob", "exit");
    }
}

