/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import oracle.repapi.RepApiGui.AppletGui;
import oracle.repapi.RepApiGui.ButtonPanel;
import oracle.repapi.RepApiGui.ClientLogin_Back_actionAdapter;
import oracle.repapi.RepApiGui.ClientLogin_Frame_actionAdapter;
import oracle.repapi.RepApiGui.ClientLogin_Next_actionAdapter;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.FrameFileDialog;
import oracle.repapi.RepApiGui.GuiPanel;
import oracle.repapi.RepApiGui.IIException;
import oracle.repapi.RepApiGui.Purpose;
import oracle.repapi.RepApiGui.Separator;
import oracle.repapi.RepApiGui.Welcome;
import oracle.repapi.client.RepAPI;

public class ClientLogin
extends GuiPanel {
    public String m_clientUsername = null;
    public String m_clientPassword = null;
    public String m_clientDatabase = null;
    public String m_prevClientUsername = null;
    public String m_prevClientPassword = null;
    public String m_prevClientDatabase = null;
    public Purpose m_purpose = null;
    private AppletGui m_gui;
    private Welcome m_welcome;
    private TextField m_usernametf;
    private TextField m_passwordtf;
    private TextField m_databasetf;
    private Frame m_frame;
    RepAPI m_repapi;

    public ClientLogin(AppletGui gui, Welcome previous) {
        this.m_gui = gui;
        this.m_welcome = previous;
        this.m_frame = this.m_gui.getTopLevelFrame(this);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            new ErrorDialog(this.m_frame, e.getMessage());
        }
    }

    void Back_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_welcome.setVisible(true);
    }

    void Frame_actionPerformed(ActionEvent e) {
        new FrameFileDialog(this.m_frame, this.m_databasetf);
    }

    void Next_actionPerformed(ActionEvent e) {
        this.m_clientUsername = this.m_usernametf.getText();
        this.m_clientPassword = this.m_passwordtf.getText();
        this.m_clientDatabase = this.m_databasetf.getText();
        try {
            this.ValidateInput(this.m_clientUsername, this.m_clientPassword, this.m_clientDatabase);
        }
        catch (IIException ie) {
            new ErrorDialog(this.m_frame, ie.getMessage());
            return;
        }
        if (this.m_purpose == null) {
            this.m_purpose = new Purpose(this.m_gui, this);
            this.m_gui.add(this.m_purpose);
        }
        this.m_gui.validate();
        this.setVisible(false);
        this.m_purpose.setVisible(true);
    }

    void ValidateInput(String name, String passwd, String db) throws IIException {
        if (name.length() == 0) {
            throw new IIException("Client username needs to be entered.");
        }
        if (passwd.length() == 0) {
            throw new IIException("Client password needs to be entered.");
        }
        if (db.length() == 0) {
            throw new IIException("Client database needs to be entered.");
        }
    }

    public void layoutComponents() {
        this.gbc.anchor = 18;
        Label m_title = new Label("Oracle Client Replication Tool, step 1 of 7: Client Login");
        m_title.setFont(this.titleFont);
        this.add(this, m_title, this.gbl, this.gbc, 0, 0, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        Separator m_sep1 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep1, this.gbl, this.gbc, 0, 1, 8, 1);
        this.setFont(this.textFont);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 10;
        Label m_command = new Label("Please login to the client database:");
        this.add(this, m_command, this.gbl, this.gbc, 0, 2, 8, 1);
        this.gbc.anchor = 13;
        Label m_username = new Label("Username:");
        this.add(this, m_username, this.gbl, this.gbc, 1, 3, 1, 1);
        this.gbc.anchor = 17;
        this.m_usernametf = new TextField(30);
        this.add(this, this.m_usernametf, this.gbl, this.gbc, 2, 3, 5, 1);
        this.gbc.anchor = 13;
        Label m_password = new Label("Password:");
        this.add(this, m_password, this.gbl, this.gbc, 1, 4, 1, 1);
        this.gbc.anchor = 17;
        this.m_passwordtf = new TextField(30);
        this.m_passwordtf.setEchoChar('*');
        this.add(this, this.m_passwordtf, this.gbl, this.gbc, 2, 4, 5, 1);
        this.gbc.anchor = 13;
        Label m_database = new Label("Database filename:");
        this.add(this, m_database, this.gbl, this.gbc, 0, 5, 2, 1);
        this.gbc.anchor = 17;
        this.m_databasetf = new TextField(30);
        this.add(this, this.m_databasetf, this.gbl, this.gbc, 2, 5, 5, 1);
        Button m_fileDialog = new Button("Browse...");
        m_fileDialog.addActionListener(new ClientLogin_Frame_actionAdapter(this));
        this.add(this, m_fileDialog, this.gbl, this.gbc, 7, 5, 1, 1);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 15;
        Separator m_sep2 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep2, this.gbl, this.gbc, 0, 6, 8, 1);
        this.gbc.anchor = 15;
        Button m_back = new Button("< Back");
        m_back.addActionListener(new ClientLogin_Back_actionAdapter(this));
        Button m_next = new Button("Next >");
        m_next.addActionListener(new ClientLogin_Next_actionAdapter(this));
        ButtonPanel m_buttonPanel = new ButtonPanel(this.m_gui, null, m_back, m_next, null);
        this.add(this, m_buttonPanel, this.gbl, this.gbc, 0, 7, 8, 1);
    }
}

