/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import oracle.repapi.RepApiGui.AppletGui;
import oracle.repapi.RepApiGui.ButtonPanel;
import oracle.repapi.RepApiGui.ClientLogin;
import oracle.repapi.RepApiGui.Confirmation;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.FrameFileDialog;
import oracle.repapi.RepApiGui.GuiPanel;
import oracle.repapi.RepApiGui.IIException;
import oracle.repapi.RepApiGui.Offline_Back_actionAdapter;
import oracle.repapi.RepApiGui.Offline_Cancel_actionAdapter;
import oracle.repapi.RepApiGui.Offline_Frame_actionAdapter;
import oracle.repapi.RepApiGui.Offline_Next_actionAdapter;
import oracle.repapi.RepApiGui.Separator;
import oracle.repapi.RepApiGui.ServerInfo;

public class Offline
extends GuiPanel {
    public AppletGui m_gui;
    public ClientLogin m_clientLogin;
    public Confirmation m_confirmation;
    public TextField m_templatetf;
    public String m_offlineTemplate = null;
    public String m_filename = null;
    public ServerInfo m_serverInfo;
    public ButtonPanel m_buttonPanel;
    private Frame m_frame;

    public Offline(AppletGui gui, ClientLogin client, ServerInfo previous) {
        this.m_gui = gui;
        this.m_clientLogin = client;
        this.m_serverInfo = previous;
        this.m_frame = this.m_gui.getTopLevelFrame(this);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            new ErrorDialog(this.m_frame, e.getMessage());
        }
    }

    void Back_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_serverInfo.setVisible(true);
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_clientLogin.m_purpose.setVisible(true);
    }

    void Next_actionPerformed(ActionEvent e) {
        this.m_offlineTemplate = this.m_templatetf.getText();
        try {
            this.ValidateInput(this.m_offlineTemplate);
        }
        catch (IIException ie) {
            new ErrorDialog(this.m_frame, ie.getMessage());
            return;
        }
        StringTokenizer token = new StringTokenizer(this.m_offlineTemplate, "/");
        while (token.hasMoreTokens()) {
            this.m_filename = token.nextToken();
        }
        if (this.m_confirmation == null) {
            this.m_confirmation = new Confirmation(this.m_gui, this, 3);
            this.m_gui.add(this.m_confirmation);
        } else {
            this.m_confirmation.layoutComponents(true);
        }
        this.m_gui.validate();
        this.setVisible(false);
        this.m_confirmation.setVisible(true);
    }

    void Offline_Frame_actionPerformed(ActionEvent e) {
        new FrameFileDialog(this.m_frame, this.m_templatetf);
    }

    void ValidateInput(String file) throws IIException {
        if (file.length() == 0) {
            throw new IIException("Template file needs to be entered.");
        }
    }

    public void layoutComponents() {
        this.gbc.anchor = 18;
        Label m_title = new Label("Oracle Client Replication Tool, step 6 of 7: Offline Instantiation");
        m_title.setFont(this.titleFont);
        this.add(this, m_title, this.gbl, this.gbc, 0, 0, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        Separator m_sep1 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep1, this.gbl, this.gbc, 0, 1, 8, 1);
        this.setFont(this.textFont);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 10;
        Label m_command = new Label("Which instantiation file would you like to use to create your data?");
        this.add(this, m_command, this.gbl, this.gbc, 0, 2, 8, 1);
        Panel m_filePanel = new Panel();
        Label m_template = new Label("Local file:");
        m_filePanel.add(m_template);
        this.m_templatetf = new TextField(30);
        m_filePanel.add(this.m_templatetf);
        Button m_fileDialog = new Button("Browse...");
        m_fileDialog.addActionListener(new Offline_Frame_actionAdapter(this));
        m_filePanel.add(m_fileDialog);
        this.gbc.anchor = 11;
        this.add(this, m_filePanel, this.gbl, this.gbc, 0, 3, 8, 3);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 15;
        Separator m_sep2 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep2, this.gbl, this.gbc, 0, 6, 8, 1);
        this.gbc.anchor = 15;
        Button m_cancel = new Button("Cancel");
        m_cancel.addActionListener(new Offline_Cancel_actionAdapter(this));
        Button m_back = new Button("< Back");
        m_back.addActionListener(new Offline_Back_actionAdapter(this));
        Button m_next = new Button("Next >");
        m_next.addActionListener(new Offline_Next_actionAdapter(this));
        this.m_buttonPanel = new ButtonPanel(this.m_gui, m_cancel, m_back, m_next, null);
        this.add(this, this.m_buttonPanel, this.gbl, this.gbc, 0, 7, 8, 1);
    }
}

