/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import oracle.repapi.RepApiGui.AppletGui;
import oracle.repapi.RepApiGui.ButtonPanel;
import oracle.repapi.RepApiGui.ClientLogin;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.GuiPanel;
import oracle.repapi.RepApiGui.IIException;
import oracle.repapi.RepApiGui.ProgressDialog;
import oracle.repapi.RepApiGui.Separator;
import oracle.repapi.RepApiGui.ServerLoginExecutioner;
import oracle.repapi.RepApiGui.ServerLogin_Back_actionAdapter;
import oracle.repapi.RepApiGui.ServerLogin_Cancel_actionAdapter;
import oracle.repapi.RepApiGui.ServerLogin_Next_actionAdapter;
import oracle.repapi.RepApiGui.Template;
import oracle.repapi.RepApiGui.Url;

public class ServerLogin
extends GuiPanel {
    public AppletGui m_gui;
    public ClientLogin m_clientLogin;
    public Url m_url = null;
    public Template m_template = null;
    public String m_serverUsername = null;
    public String m_serverPassword = null;
    public String m_serverDatabase = null;
    public String m_prevServerUsername = null;
    public String m_prevServerPassword = null;
    public String m_prevServerDatabase = null;
    public String m_serverUrl = null;
    public int m_serverTask = 0;
    public Button m_back;
    public Button m_next;
    public Button m_cancel;
    public GuiPanel m_prev;
    public TextField m_databasetf;
    public ButtonPanel m_buttonPanel;
    public ProgressDialog m_progDialog;
    public Frame m_frame;
    private TextField m_usernametf;
    private TextField m_passwordtf;
    private Thread m_serverLoginThread;

    public ServerLogin(AppletGui gui, ClientLogin client, GuiPanel previous) {
        this.m_gui = gui;
        this.m_clientLogin = client;
        this.m_prev = previous;
        this.m_frame = this.m_gui.getTopLevelFrame(this);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            new ErrorDialog(this.m_frame, e.getMessage());
        }
    }

    void Back_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_prev.setVisible(true);
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_clientLogin.m_purpose.setVisible(true);
    }

    void Next_actionPerformed(ActionEvent e) {
        this.m_serverUsername = this.m_usernametf.getText();
        this.m_serverPassword = this.m_passwordtf.getText();
        this.m_serverDatabase = this.m_databasetf.getText();
        try {
            this.ValidateInput(this.m_serverUsername, this.m_serverPassword, this.m_serverDatabase);
        }
        catch (IIException ie) {
            new ErrorDialog(this.m_frame, ie.getMessage());
            return;
        }
        this.m_cancel.setEnabled(false);
        this.m_back.setEnabled(false);
        this.m_next.setEnabled(false);
        ServerLoginExecutioner sle = new ServerLoginExecutioner(this);
        this.m_serverLoginThread = new Thread(sle);
        this.m_progDialog = new ProgressDialog(this.m_gui.getTopLevelFrame(this), this.m_clientLogin.m_repapi, this.m_serverLoginThread);
        this.m_serverLoginThread.start();
    }

    void ValidateInput(String name, String passwd, String db) throws IIException {
        if (name.length() == 0) {
            throw new IIException("Server username needs to be entered.");
        }
        if (passwd.length() == 0) {
            throw new IIException("Server password needs to be entered.");
        }
        if (db.length() == 0) {
            throw new IIException("Server database needs to be entered.");
        }
    }

    public void layoutComponents() {
        this.gbc.anchor = 18;
        Label m_title = new Label("Oracle Client Replication Tool, step 4 of 7: Server Login");
        m_title.setFont(this.titleFont);
        this.add(this, m_title, this.gbl, this.gbc, 0, 0, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        Separator m_sep1 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep1, this.gbl, this.gbc, 0, 1, 8, 1);
        this.setFont(this.textFont);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 10;
        Label m_command = new Label("Please login to the server database:");
        this.add(this, m_command, this.gbl, this.gbc, 0, 2, 8, 1);
        this.gbc.anchor = 13;
        Label m_username = new Label("Username:");
        this.add(this, m_username, this.gbl, this.gbc, 0, 3, 2, 1);
        this.gbc.anchor = 17;
        this.m_usernametf = new TextField(30);
        this.add(this, this.m_usernametf, this.gbl, this.gbc, 2, 3, 6, 1);
        this.gbc.anchor = 13;
        Label m_password = new Label("Password:");
        this.add(this, m_password, this.gbl, this.gbc, 0, 4, 2, 1);
        this.gbc.anchor = 17;
        this.m_passwordtf = new TextField(30);
        this.m_passwordtf.setEchoChar('*');
        this.add(this, this.m_passwordtf, this.gbl, this.gbc, 2, 4, 6, 1);
        this.gbc.anchor = 13;
        Label m_database = new Label("Server URL Label:");
        this.add(this, m_database, this.gbl, this.gbc, 0, 5, 2, 1);
        this.gbc.anchor = 17;
        this.m_databasetf = new TextField(30);
        this.add(this, this.m_databasetf, this.gbl, this.gbc, 2, 5, 6, 1);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 15;
        Separator m_sep2 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep2, this.gbl, this.gbc, 0, 6, 8, 1);
        this.gbc.anchor = 15;
        this.m_cancel = new Button("Cancel");
        this.m_cancel.addActionListener(new ServerLogin_Cancel_actionAdapter(this));
        this.m_back = new Button("< Back");
        this.m_back.addActionListener(new ServerLogin_Back_actionAdapter(this));
        this.m_next = new Button("Next >");
        this.m_next.addActionListener(new ServerLogin_Next_actionAdapter(this));
        this.m_buttonPanel = new ButtonPanel(this.m_gui, this.m_cancel, this.m_back, this.m_next, null);
        this.add(this, this.m_buttonPanel, this.gbl, this.gbc, 0, 7, 8, 1);
    }
}

