/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import oracle.repapi.RepApiGui.AppletGui;
import oracle.repapi.RepApiGui.ButtonPanel;
import oracle.repapi.RepApiGui.Confirmation;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.GuiPanel;
import oracle.repapi.RepApiGui.IIException;
import oracle.repapi.RepApiGui.Separator;
import oracle.repapi.RepApiGui.ServerLogin;
import oracle.repapi.RepApiGui.Template_Back_actionAdapter;
import oracle.repapi.RepApiGui.Template_Cancel_actionAdapter;
import oracle.repapi.RepApiGui.Template_Next_actionAdapter;
import oracle.repapi.client.RepAPI;

public class Template
extends GuiPanel {
    public AppletGui m_gui;
    public ServerLogin m_serverLogin;
    public Confirmation m_confirmation;
    public List m_list;
    public RepAPI m_repapi;
    public ButtonPanel m_buttonPanel;
    private Frame m_frame;
    private GuiPanel m_url;
    private String[] m_localGroups;

    public Template(AppletGui gui, GuiPanel previous, ServerLogin sl) {
        this.m_gui = gui;
        this.m_url = previous;
        this.m_serverLogin = sl;
        this.m_frame = this.m_gui.getTopLevelFrame(this);
        try {
            this.layoutComponents();
            this.availableTemplates();
        }
        catch (Exception e) {
            new ErrorDialog(this.m_frame, e.getMessage());
        }
    }

    void Back_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_url.setVisible(true);
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_serverLogin.m_clientLogin.m_purpose.setVisible(true);
    }

    void Next_actionPerformed(ActionEvent e) {
        try {
            this.ValidateInput(this.m_list.getSelectedItems());
        }
        catch (IIException ie) {
            new ErrorDialog(this.m_frame, ie.getMessage());
            return;
        }
        if (this.m_confirmation == null) {
            this.m_confirmation = new Confirmation(this.m_gui, this, this.m_serverLogin.m_serverTask);
            this.m_gui.add(this.m_confirmation);
        } else {
            this.m_confirmation.layoutComponents(true);
        }
        this.m_gui.validate();
        this.setVisible(false);
        this.m_confirmation.setVisible(true);
    }

    void ValidateInput(String[] files) throws IIException {
        if (files == null || files.length == 0) {
            throw new IIException("There are no templates to be selected or no template has been chosen");
        }
    }

    public void availableTemplates() {
        this.m_repapi = this.m_serverLogin.m_clientLogin.m_repapi;
        try {
            this.m_localGroups = this.m_serverLogin.m_serverTask == 2 ? this.m_repapi.showAvailableGroups() : this.m_repapi.showLocalGroupsForMaster();
        }
        catch (Exception ex) {
            new ErrorDialog(this.m_frame, ex.getMessage());
            return;
        }
        if (this.m_localGroups != null && this.m_localGroups.length != 0) {
            int i = 0;
            int l = this.m_localGroups.length;
            while (i < l) {
                String str = new String(this.m_localGroups[i++]);
                this.m_list.add(str);
            }
        }
        this.m_localGroups = this.m_list.getItems();
    }

    public void layoutComponents() {
        this.gbc.anchor = 18;
        Label m_title = this.m_serverLogin.m_serverTask == 2 ? new Label("Oracle Client Replication Tool, step 6 of 7: Online Instantiation") : (this.m_serverLogin.m_serverTask == 1 ? new Label("Oracle Client Replication Tool, step 6 of 7: Template Refresh") : new Label("Oracle Client Replication Tool, step 6 of 7: Drop Template"));
        m_title.setFont(this.titleFont);
        this.add(this, m_title, this.gbl, this.gbc, 0, 0, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        Separator m_sep1 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep1, this.gbl, this.gbc, 0, 1, 8, 1);
        this.setFont(this.textFont);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 10;
        Label m_command = this.m_serverLogin.m_serverTask == 2 ? new Label("Which template data sets would you like to instantiate at your local site?") : (this.m_serverLogin.m_serverTask == 1 ? new Label("Which template data sets would you like to synchronize with the server site?") : new Label("Which template data sets would you like to drop from your local site?"));
        this.add(this, m_command, this.gbl, this.gbc, 0, 2, 8, 1);
        this.setFont(new Font("Helvetica", 0, 7));
        Label m_instruction = new Label("Select by clicking on the template name (choose only one):");
        this.gbc.weighty = 0.0;
        this.add(this, m_instruction, this.gbl, this.gbc, 0, 3, 7, 1);
        this.setFont(this.textFont);
        this.gbc.ipadx = 40;
        this.gbc.ipady = 30;
        this.gbc.weighty = 1.0;
        this.m_list = new List();
        this.m_list.setMultipleMode(false);
        this.add(this, this.m_list, this.gbl, this.gbc, 0, 3, 8, 3);
        this.gbc.ipadx = 0;
        this.gbc.ipady = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 15;
        Separator m_sep2 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep2, this.gbl, this.gbc, 0, 6, 8, 1);
        this.gbc.anchor = 15;
        Button m_cancel = new Button("Cancel");
        m_cancel.addActionListener(new Template_Cancel_actionAdapter(this));
        Button m_back = new Button("< Back");
        m_back.addActionListener(new Template_Back_actionAdapter(this));
        Button m_next = new Button("Next >");
        m_next.addActionListener(new Template_Next_actionAdapter(this));
        this.m_buttonPanel = new ButtonPanel(this.m_gui, m_cancel, m_back, m_next, null);
        this.add(this, this.m_buttonPanel, this.gbl, this.gbc, 0, 7, 8, 1);
    }
}

