/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.adminObj.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.sysman.emSDK.adminObj.client.ClientObject;
import oracle.sysman.emSDK.adminObj.client.PropertyPage;
import oracle.sysman.emSDK.adminObj.client.PropertySheet;
import oracle.sysman.emSDK.adminObj.server.DataSourceUpdateException;
import oracle.sysman.emSDK.adminObj.server.InsufficientInitException;
import oracle.sysman.emSDK.adminObj.server.ValidateException;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.vtx.VtxWindowsUtil;

public abstract class GuiObject {
    private PropertySheet m_ps;
    private ClientObject m_clientObj;
    private ListenerManager m_listenerManager = new ListenerManager();

    public GuiObject() {
    }

    public GuiObject(ClientObject obj) {
        this.m_clientObj = obj;
    }

    public void doCleanUp() {
        if (this.m_clientObj != null) {
            this.m_clientObj.doCleanUp();
        }
        this.m_clientObj = null;
    }

    public void setPropertySheet(PropertySheet ps) {
        this.m_ps = ps;
    }

    public String[] getHelpBookNTopic() {
        String[] str = new String[]{"", ""};
        return str;
    }

    public abstract String getDisplayName();

    protected String getFullDisplayName() {
        return null;
    }

    protected boolean arePagesResizable() {
        return false;
    }

    public Dimension getPreferredPageSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMinimumPageSize() {
        return new Dimension(0, 0);
    }

    public Dimension getMaximumPageSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int launchDialog(ImageLoader container, Component parent, boolean modal) {
        int result = 0;
        if (this.getNumPages() > 0) {
            this.m_ps = this.createPropertySheet(container);
            if (modal) {
                this.m_ps.createModal(this, VtxWindowsUtil.getFrame(parent));
            } else {
                this.m_ps.createModeless(this, VtxWindowsUtil.getFrame(parent));
            }
        }
        return result;
    }

    public int launchInView(ImageLoader container, Container parent) {
        int result = 0;
        if (this.getNumPages() > 0) {
            this.m_ps = this.createPropertySheet(container);
            this.m_ps.createEmbedded(this, parent);
        }
        return result;
    }

    public PropertySheet createPropertySheet(ImageLoader container) {
        PropertySheet ps = new PropertySheet(container);
        return ps;
    }

    protected PropertySheet getPropSheet() {
        return this.m_ps;
    }

    public String getType() {
        return this.m_clientObj.getType();
    }

    public int getNumPages() {
        return 0;
    }

    public abstract PropertyPage createPageAt(int var1);

    void commit(boolean bReinitToReuse) throws ValidateException, InsufficientInitException, DataSourceUpdateException {
        this.m_clientObj.commit(bReinitToReuse);
    }

    void remove() throws DataSourceUpdateException {
        String warning = this.m_clientObj.getRemoveWarning();
        if (!warning.equals("")) {
            AppAlert alert = new AppAlert((Frame)new BufferedFrame(), 1, 3);
            alert.setMessage(warning);
            alert.setDefaultButton(2);
            int result = alert.runAlert();
            if (result == 2) {
                return;
            }
        }
        this.m_clientObj.remove();
    }

    void revertToOriginal() {
        this.m_clientObj.revert();
    }

    boolean isCreatingNew() {
        return this.m_clientObj.isCreating();
    }

    protected boolean isModifiable() {
        return true;
    }

    public void setVisiblePages() {
    }

    protected ClientObject getClientObject() {
        return this.m_clientObj;
    }

    protected boolean isModified() {
        return true;
    }
}

