/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.adminObj.client;

import java.awt.Component;
import java.awt.Frame;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.sysman.emSDK.adminObj.client.ClientObject;
import oracle.sysman.emSDK.adminObj.client.GuiException;
import oracle.sysman.emSDK.adminObj.client.GuiObject;
import oracle.sysman.emSDK.adminObj.client.PropertySheet;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.vtx.VtxAssert;
import oracle.sysman.vtx.VtxWindowsUtil;

public abstract class PropertyPage
extends EwtContainer {
    private boolean m_initNeeded = true;
    private boolean modified = false;
    private boolean displayed = false;
    private boolean reinitOnApply = false;
    private String title;
    private PropertySheet _ps;
    private ClientObject m_clientObject;

    public PropertyPage(String title) {
        this.title = title;
    }

    protected abstract void initializePage() throws GuiException;

    protected void onSetActive() {
        if (this.m_initNeeded) {
            try {
                this.initializePage();
            }
            catch (GuiException e) {
                PropertySheet ps = this.getPropSheet();
                if (ps != null) {
                    ps.notifyOfInitError(this, e.getMessage());
                }
                return;
            }
            this.m_initNeeded = false;
            this.checkPS();
        }
        if (this._ps != null) {
            this._ps.setHelpBook(this.getHelpBook());
            this._ps.setHelpTopic(this.getHelpTopic());
        }
    }

    protected abstract void onCreatePage();

    public void reinitializePage() {
        VtxAssert.notFalse(this.reinitOnApply);
        VtxAssert.notFalse(this.m_initNeeded);
        this.onSetActive();
    }

    protected void updateObject() throws GuiException {
    }

    protected void setObj(ClientObject obj) {
        this.setInitNeeded(true);
        this.m_clientObject = obj;
    }

    protected ClientObject getObj() {
        return this.m_clientObject;
    }

    public void setObj(GuiObject guiObj) {
        this.setObj(guiObj.getClientObject());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    private void checkPS() {
        if (this._ps == null) {
            Object c = this;
            while ((c = ((Component)c).getParent()) != null) {
                if (!(c instanceof PropertySheet)) continue;
                this._ps = (PropertySheet)c;
                return;
            }
        }
    }

    protected BufferedFrame getFrame() {
        return VtxWindowsUtil.getFrame((Component)((Object)this));
    }

    protected int showAlert(String message, int alertType, int buttons) {
        BufferedFrame frame = this.getFrame();
        if (frame != null) {
            AppAlert alert = new AppAlert((Frame)frame, message, alertType, buttons);
            return alert.runAlert();
        }
        return 4;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
        this.checkPS();
        if (this._ps != null) {
            this._ps.updateModifiedPage();
        }
    }

    protected boolean isModified() {
        return this.modified;
    }

    protected void setInitNeeded(boolean needed) {
        this.m_initNeeded = needed;
    }

    protected boolean isInitNeeded() {
        return this.m_initNeeded;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean disp) {
        this.displayed = disp;
    }

    public boolean setReinitOnApply(boolean reinitFlag) {
        this.reinitOnApply = reinitFlag;
        return this.reinitOnApply;
    }

    public boolean getReinitOnApply() {
        return this.reinitOnApply;
    }

    public ImageLoader getLoaderForImage() {
        this.checkPS();
        if (this._ps != null) {
            return this._ps.getLoaderForImage();
        }
        return null;
    }

    protected void cleanup() {
    }

    protected PropertySheet getPropSheet() {
        this.checkPS();
        return this._ps;
    }
}

