/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appContainer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Vector;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.util.WindowUtils;
import oracle.help.Book;
import oracle.help.Help;
import oracle.help.TopicNotFoundException;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxx.VxxResourceUtil;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class EMACHelp
implements HelpProvider {
    private Help m_jhelp;
    private boolean m_loadFailed = false;
    private Vector m_bookList;

    private boolean loadIceBrowser() {
        try {
            this.m_jhelp = new Help(Class.forName("oracle.help.htmlBrowser.ICEBrowser"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.m_jhelp = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.m_jhelp = null;
        }
        return this.m_jhelp != null;
    }

    private boolean loadDefaultBrowser() {
        try {
            this.m_jhelp = new Help();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.m_jhelp = null;
        }
        return this.m_jhelp != null;
    }

    private void loadBrowser() {
        if (this.m_jhelp == null && !this.m_loadFailed && !this.loadIceBrowser()) {
            MessageBundle msgFile = MessageBundle.getMessageBundle("Vta");
            String strError = msgFile.getMessage("2001", true);
            System.err.println(strError);
            this.m_loadFailed = true;
        }
    }

    private void saveBook(Object baseClass, Object obj1, Object obj2, Object obj3) {
        if (this.m_bookList == null) {
            this.m_bookList = new Vector(4);
        }
        this.m_bookList.addElement(baseClass);
        this.m_bookList.addElement(obj1);
        this.m_bookList.addElement(obj2);
        this.m_bookList.addElement(obj3);
    }

    private void loadBooks() {
        if (this.m_bookList != null) {
            int numRows = this.m_bookList.size();
            int i = 0;
            while (i < numRows) {
                Object o0 = this.m_bookList.elementAt(i);
                if (o0 instanceof Book) {
                    this.m_jhelp.addBook((Book)o0);
                } else if (o0 instanceof Class) {
                    this.addBook((Class)o0, (String)this.m_bookList.elementAt(i + 1), (String)this.m_bookList.elementAt(i + 2), (String)this.m_bookList.elementAt(i + 3));
                } else if (o0 instanceof String) {
                    this.addBook((String)o0, (String)this.m_bookList.elementAt(i + 1), (String)this.m_bookList.elementAt(i + 2), (String)this.m_bookList.elementAt(i + 3));
                }
                i += 4;
            }
            this.m_bookList.removeAllElements();
            this.m_bookList = null;
        }
    }

    public boolean loadHelp() {
        this.loadBrowser();
        if (!this.m_loadFailed) {
            this.setVisible(true);
            this.loadBooks();
            return true;
        }
        return false;
    }

    public void destroy() {
        this.removeAllBooks();
        this.setVisible(false);
        this.m_loadFailed = false;
        if (this.m_jhelp != null) {
            this.m_jhelp.dispose();
            this.m_jhelp = null;
        }
    }

    public void addBook(Class baseClass, String dirNameFormat, String baseName, String title) {
        if (this.m_jhelp == null) {
            this.saveBook(baseClass, dirNameFormat, baseName, title);
        } else {
            Book book;
            int nIndex;
            String dirName = VxxResourceUtil.getLocalizedDirectory(baseClass, dirNameFormat);
            if (dirName == null) {
                VxxtTRACE.out("EMACHelp: no help book at '" + dirNameFormat + "', trying '.'", 2);
                dirName = ".";
            }
            if ((nIndex = this.findBook(baseName)) != -1) {
                book = this.m_jhelp.getBookAt(nIndex);
                this.m_jhelp.removeBook(book);
            }
            if (baseClass != null && dirName != null && baseName != null && title != null) {
                book = Help.createBook((Class)baseClass, (String)dirName, (String)baseName, (String)title);
                this.m_jhelp.addBook(book);
            }
        }
    }

    public void addBook(String baseClass, String dirNameFormat, String baseName, String title) {
        if (this.m_jhelp == null) {
            this.saveBook(baseClass, dirNameFormat, baseName, title);
        } else {
            try {
                Class<?> c = Class.forName(baseClass);
                this.addBook(c, dirNameFormat, baseName, title);
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
        }
    }

    public void addBooks(Class baseClass, Object[][] books) {
        int numRows = books.length;
        int i = 0;
        while (i < numRows) {
            String dirName = (String)books[i][0];
            String baseName = (String)books[i][1];
            String title = (String)books[i][2];
            this.addBook(baseClass, dirName, baseName, title);
            ++i;
        }
    }

    public void removeAllBooks() {
        if (this.m_jhelp == null) {
            this.m_bookList = null;
        } else {
            this.m_jhelp.removeAllBooks();
        }
    }

    public void showContents() {
        this.loadHelp();
        if (this.m_jhelp != null) {
            this.m_jhelp.showContents();
        }
    }

    public void showIndex() {
        this.loadHelp();
        if (this.m_jhelp != null) {
            this.m_jhelp.showIndex();
        }
    }

    public void showSearch() {
        this.loadHelp();
        if (this.m_jhelp != null) {
            this.m_jhelp.showSearch();
        }
    }

    public final boolean showTopic(String baseName, String topic) {
        this.showHelp(baseName, topic);
        return true;
    }

    public void showHelp(Object baseName, String topic) {
        this.showHelp(baseName, topic, null);
    }

    public void showHelp(Object baseName, String topic, Component c) {
        this.handleModalCall();
        this.loadHelp();
        if (this.m_jhelp != null) {
            int nIndex = -1;
            if (baseName instanceof String) {
                nIndex = this.findBook((String)baseName);
            }
            Book book = null;
            if (nIndex != -1) {
                book = this.m_jhelp.getBookAt(nIndex);
            }
            this.showHelp(book, topic, c);
        }
    }

    private void showHelp(Book book, String topic, Component c) {
        block3: {
            this.loadHelp();
            if (this.m_jhelp == null) break block3;
            if (topic != null) {
                topic = topic.toLowerCase();
            }
            try {
                this.m_jhelp.showHelp((Object)book, topic);
            }
            catch (TopicNotFoundException e) {
                System.err.println((Object)e);
                this.m_jhelp.showContents();
            }
        }
    }

    private void handleModalCall() {
        if (this.isActiveWindowModal() && this.m_jhelp != null) {
            this.recreate();
        }
    }

    private void recreate() {
        this.saveBooks();
        this.destroy();
        this.loadHelp();
    }

    private void saveBooks() {
        if (this.m_jhelp != null) {
            int count = this.m_jhelp.getBookCount();
            int i = 0;
            while (i < count) {
                this.saveBook(this.m_jhelp.getBookAt(i), null, null, null);
                ++i;
            }
        }
    }

    private boolean isActiveWindowModal() {
        Window w = WindowUtils.getActiveWindow();
        return w instanceof Dialog && ((Dialog)w).isModal();
    }

    public void setVisible(boolean bVisible) {
        if (this.m_jhelp != null) {
            this.m_jhelp.setVisible(bVisible);
        }
    }

    public void setVisible(String baseName, boolean visible) {
        int index = this.findBook(baseName);
        this.setVisible(index, visible);
    }

    private int findBook(String baseName) {
        if (this.m_jhelp != null && baseName != null) {
            int nCount = this.m_jhelp.getBookCount();
            int i = 0;
            while (i < nCount) {
                Book book = this.m_jhelp.getBookAt(i);
                if (book != null && book.getBaseName() == baseName) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String getTitle(int index) {
        Book book;
        if (this.m_jhelp != null && (book = this.m_jhelp.getBookAt(index)) != null) {
            return book.getTitle();
        }
        return null;
    }

    private String getBaseName(int index) {
        Book book;
        if (this.m_jhelp != null && (book = this.m_jhelp.getBookAt(index)) != null) {
            return book.getBaseName();
        }
        return null;
    }

    private void setVisible(int index, boolean visible) {
        Book book;
        if (this.m_jhelp != null && (book = this.m_jhelp.getBookAt(index)) != null) {
            this.m_jhelp.setBookVisible(book, visible);
        }
    }
}

