/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appContainer;

import oracle.sysman.emSDK.client.appContainer.LaunchComponent;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public final class LaunchApplication
extends WebApplication {
    private static MessageBundle m_msgFile = MessageBundle.getMessageBundle("Vta");
    public static final String PARAM_LAUNCHEE = "LaunchApplicationLaunchee";

    public void init() {
        super.init();
        this.removeStandardMenus();
        this.setFrameSize(1, 1);
        this.setFrameVisible(false);
        this.launch();
    }

    private void launch() {
        boolean bExit;
        String strLaunchee = this.getLaunchee();
        boolean bl = bExit = strLaunchee.length() == 0;
        if (!bExit) {
            LaunchComponent launcher = new LaunchComponent(this);
            try {
                launcher.launchApplication(strLaunchee);
            }
            catch (Exception e) {
                String strError = m_msgFile.getMessage("2002", true);
                System.err.println(String.valueOf(strError) + e);
                bExit = true;
            }
        }
        if (bExit) {
            this.exit();
        }
    }

    private String getLauncheeFromArgs() {
        String strParam = null;
        String[] arg = this.getCommandLineArgs();
        if (arg != null) {
            strParam = arg[0];
        }
        if (strParam == null) {
            strParam = "";
        }
        return strParam;
    }

    private String getLauncheeFromParam() {
        String strParam = null;
        try {
            strParam = this.getProperty(PARAM_LAUNCHEE);
        }
        catch (NullPointerException nullPointerException) {}
        if (strParam == null) {
            strParam = "";
        }
        return strParam;
    }

    private String getLaunchee() {
        String strParam = null;
        strParam = this.getLauncheeFromParam();
        if (strParam.length() == 0) {
            strParam = this.getLauncheeFromArgs();
        }
        if (strParam.length() == 0) {
            String strError = m_msgFile.getMessage("2003", false);
            System.err.println(String.valueOf(this.getClass().getName()) + strError);
        }
        return strParam;
    }
}

