/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appContainer;

import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import oracle.sysman.emSDK.client.appContainer.Launchable;
import oracle.sysman.emSDK.client.appContainer.VTALaunchThread;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class LaunchComponent {
    AppletContext myContext;
    WebApplication myContainer;
    URL documentBase;
    Object launchContext;
    Vector launchedApps;

    public LaunchComponent(WebApplication container) {
        this.myContainer = container;
        this.myContext = container.getAppletContext();
        this.documentBase = container.getDocumentBase();
        this.launchedApps = new Vector();
    }

    public void launchApplication(String appName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        VTALaunchThread t = new VTALaunchThread(appName, this.getLaunchContext());
        Launchable app = t.init();
        t.start();
        if (app != null) {
            app.setLaunchComponent(this);
            this.launchedApps.addElement(app);
        }
    }

    public void launchApplication(String appName, URL documentBase) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL temp = this.documentBase;
        this.myContainer.resetNamedContext("_vtaDocumentBase", documentBase);
        this.launchApplication(appName);
        this.myContainer.resetNamedContext("_vtaDocumentBase", temp);
    }

    public void launchURL(String urlString) throws MalformedURLException {
        this.launchURL(new URL(urlString));
    }

    public void launchURL(URL url) {
        if (this.myContext != null) {
            this.myContext.showDocument(url, "_blank");
        }
    }

    public void setLaunchContext(Object launchContext) {
        this.launchContext = launchContext;
    }

    public Object getLaunchContext() {
        return this.launchContext;
    }

    public void destroy() {
        int i = 0;
        while (i < this.launchedApps.size()) {
            Launchable app = (Launchable)this.launchedApps.elementAt(i);
            if (app != null) {
                app.destroy();
            }
            ++i;
        }
    }

    public String[] getLaunchedApps() {
        if (this.launchedApps != null) {
            String[] launchedAppNames = new String[this.launchedApps.size()];
            int i = 0;
            while (i < this.launchedApps.size()) {
                Launchable app = (Launchable)this.launchedApps.elementAt(i);
                launchedAppNames[i] = app.getDisplayName();
                ++i;
            }
            return launchedAppNames;
        }
        return new String[0];
    }

    public void removeLaunchedApp(Launchable app) {
        this.launchedApps.removeElement(app);
    }
}

