/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appContainer.contextLibrary;

import oracle.sysman.emSDK.client.appContainer.Context;
import oracle.sysman.emSDK.client.appContainer.LaunchPropertyException;
import oracle.sysman.emSDK.client.appContainer.MissingPropertyException;
import oracle.sysman.emSDK.client.appContainer.contextLibrary.MalformedPropertyException;

public class DBContext
implements Context {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SERVICE = "service";
    public static final String ROLE = "role";
    private String m_username;
    private String m_password;
    private String m_service;
    private String m_role;

    public void initFromProperties() throws LaunchPropertyException, MalformedPropertyException, MissingPropertyException {
        try {
            this.m_username = System.getProperty(USERNAME);
            this.m_password = System.getProperty(PASSWORD);
            this.m_service = System.getProperty(SERVICE);
            this.m_role = System.getProperty(ROLE);
            if (this.m_username == null) {
                throw new MissingPropertyException(USERNAME);
            }
            if (this.m_password == null) {
                throw new MissingPropertyException(PASSWORD);
            }
        }
        catch (SecurityException securityException) {}
    }

    public String[] getListOfProperties() {
        return new String[]{USERNAME, PASSWORD, SERVICE, ROLE};
    }

    public final String getUsername() {
        return this.m_username;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final String getService() {
        if (this.m_service != null) {
            return this.m_service;
        }
        return "";
    }

    public final String getRole() {
        if (this.m_role != null) {
            return this.m_role;
        }
        return "normal";
    }

    public DBContext() {
    }

    public DBContext(String username, String password, String service, String role) {
        this.m_username = username;
        this.m_password = password;
        this.m_service = service;
        this.m_role = role;
    }
}

