/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appContainer.contextLibrary;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.sysman.emSDK.client.appContainer.Context;
import oracle.sysman.emSDK.client.appContainer.LaunchPropertyException;
import oracle.sysman.emSDK.client.appContainer.MissingPropertyException;
import oracle.sysman.emSDK.client.appContainer.contextLibrary.MalformedPropertyException;
import oracle.sysman.emSDK.client.omsClient.Credential;
import oracle.sysman.emSDK.client.omsClient.EMCredentialFactory;

public class OEMContext
implements Context {
    public static final String PROPERTY_OEM_CREDENTIAL = "oem.Credential";
    public static final String PROPERTY_OEM_ALT_LOGIN = "oem.DirectLogin";
    private Credential m_cred;
    private boolean m_altLogin = false;

    public void initFromProperties() throws LaunchPropertyException, MalformedPropertyException, MissingPropertyException {
        try {
            String raw = System.getProperty(PROPERTY_OEM_CREDENTIAL);
            if (raw == null) {
                throw new MissingPropertyException(PROPERTY_OEM_CREDENTIAL);
            }
            this.parseCredential(raw);
            String alt = System.getProperty(PROPERTY_OEM_ALT_LOGIN);
            if (alt != null && alt.equalsIgnoreCase("true")) {
                this.m_altLogin = true;
            }
        }
        catch (SecurityException securityException) {}
    }

    public String[] getListOfProperties() {
        return new String[]{PROPERTY_OEM_CREDENTIAL, PROPERTY_OEM_ALT_LOGIN};
    }

    public final Credential getOEMCredential() {
        return this.m_cred;
    }

    public final void setAlternativeLogin(boolean altLogin) {
        this.m_altLogin = altLogin;
    }

    public final boolean isAlternativeLogin() {
        return this.m_altLogin;
    }

    public OEMContext() {
    }

    public OEMContext(String domain, String username, String password) {
        this.m_cred = EMCredentialFactory.create(username, password, domain);
    }

    public OEMContext(Credential cred) {
        this.m_cred = cred;
    }

    public String toString() {
        String msg = String.valueOf(EMCredentialFactory.credString(this.m_cred)) + "\n";
        msg = this.m_altLogin ? String.valueOf(msg) + "Alternative login specified" : String.valueOf(msg) + "No Alternative login specified";
        return msg;
    }

    private void parseCredential(String raw) throws MalformedPropertyException {
        StringTokenizer stringTokenizer = new StringTokenizer(raw, "/@");
        String user = "";
        String password = "";
        String domain = "";
        try {
            user = stringTokenizer.nextToken();
            password = stringTokenizer.nextToken();
            domain = stringTokenizer.nextToken();
            this.m_cred = EMCredentialFactory.create(user, password, domain);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedPropertyException("oem.Credential must be of form <username>/<password>@<domain>");
        }
    }
}

