/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeButtonDecoration;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeLineDecoration;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeStackingDecoration;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceRegistry;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeEventManager;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeRootNode;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ApplicationAdapter;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupCommandMenu;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuListener;
import oracle.sysman.emSDK.client.guiComponent.selection.EMSelection;
import oracle.sysman.emSDK.client.guiComponent.selection.EMSelectionComponent;
import oracle.sysman.emSDK.client.guiComponent.selection.EMSelectionManager;
import oracle.sysman.vtx.VtxWindowsUtil;
import oracle.sysman.vxx.VxxTypes;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class DataDrivenTree
extends DTree
implements EMSelectionComponent {
    private Object m_appComponent;
    private String m_appName = "";
    private EMSelectionManager m_selectionManager;
    private ApplicationAdapter m_commandAdapter;
    private ImageLoader m_imageLoader;
    private TreeDataSourceRegistry m_dsRegistry;
    private ListenerManager m_rightMouseLm;

    public DataDrivenTree() {
        TreeEventManager eventManager = new TreeEventManager();
        eventManager.setTree(this);
        this.addActivateListener(eventManager);
        this.addExpansionListener(eventManager);
        this.addSelectionListener(eventManager);
        this.addRMouseListener(eventManager);
        ((Component)((Object)this)).addFocusListener(eventManager);
        ((Component)((Object)this)).addKeyListener(eventManager);
        DTreeButtonDecoration buttons = new DTreeButtonDecoration();
        DTreeLineDecoration lines = new DTreeLineDecoration();
        DTreeStackingDecoration stack = new DTreeStackingDecoration((DTreeDecoration)lines, (DTreeDecoration)buttons);
        this.setDecoration((DTreeDecoration)stack);
    }

    String constructContext(TreeItem node) {
        String rootContext;
        int index;
        DTreeRootItem root;
        String context = null;
        if (node != null) {
            context = String.valueOf(node.getType()) + "=" + node.getLabel();
            DTreeItem parent = node.getParent();
            while (parent != null && parent instanceof TreeItem) {
                context = String.valueOf(((TreeItem)parent).getType()) + "=" + ((TreeItem)parent).getLabel() + "/" + context;
                parent = parent.getParent();
            }
        }
        if ((root = this.getRoot()) != node && root instanceof TreeRootNode && (index = (rootContext = ((TreeRootNode)root).getContext()).lastIndexOf(47)) != -1) {
            String presetContext = rootContext.substring(0, index);
            context = String.valueOf(presetContext) + context.substring(context.indexOf(47));
        }
        return context;
    }

    public BufferedFrame getFrame() {
        return VtxWindowsUtil.getFrame((Component)((Object)this));
    }

    public void setImageLoader(ImageLoader loader) {
        this.m_imageLoader = loader;
    }

    public ImageLoader getImageLoader() {
        return this.m_imageLoader;
    }

    public void setSelectionManager(EMSelectionManager selManager) {
        this.m_selectionManager = selManager;
    }

    public EMSelectionManager getSelectionManager() {
        return this.m_selectionManager;
    }

    public void setCommandAdapter(ApplicationAdapter cmdAdapter) {
        this.m_commandAdapter = cmdAdapter;
    }

    public ApplicationAdapter getCommandAdapter() {
        return this.m_commandAdapter;
    }

    public void setAppComponent(Object appComponent) {
        this.m_appComponent = appComponent;
    }

    public Object getAppComponent() {
        return this.m_appComponent;
    }

    public void setApplicationName(String appName) {
        this.m_appName = appName;
    }

    public String getApplicationName() {
        return this.m_appName;
    }

    public void setDSRegistry(TreeDataSourceRegistry registry) {
        this.m_dsRegistry = registry;
    }

    public TreeDataSourceRegistry getDSRegistry() {
        return this.m_dsRegistry;
    }

    public final void addRMouseListener(PopupMenuListener listener) {
        if (this.m_rightMouseLm == null) {
            this.m_rightMouseLm = new ListenerManager();
        }
        this.m_rightMouseLm.addListener((EventListener)listener);
    }

    public final void removeRMouseListener(PopupMenuListener listener) {
        if (this.m_rightMouseLm != null) {
            this.m_rightMouseLm.removeListener((EventListener)listener);
        }
    }

    public void refreshTree(DTreeItem parent) {
        if (parent == null && (parent = this.getRoot()) == null) {
            return;
        }
        if (parent.isExpanded()) {
            if (parent != this.getRoot() && parent.getItemCount() == 0) {
                parent.setExpanded(false);
                return;
            }
            this.refreshChildrenOfItem(parent);
            int num = parent.getItemCount();
            if (num == 0 && parent != this.getRoot()) {
                parent.setExpanded(false);
                return;
            }
            int i = 0;
            while (i < num) {
                DTreeItem child = parent.getItem(i);
                if (child != null) {
                    this.refreshTree(child);
                }
                ++i;
            }
        }
    }

    public void refreshNodesOfType(String type) {
        this.refreshNodesOfTypeAndName(type, null);
    }

    public void refreshNodesOfTypeAndName(String type, String name) {
        DTreeRootItem root = this.getRoot();
        if (root == null) {
            return;
        }
        this.refreshTypeAndName((DTreeItem)root, type, name);
    }

    public void refreshNodesWithChildOfType(String type) {
        String[] typeList = new String[]{type};
        this.refreshNodesWithChildOfTypes(typeList);
    }

    public void refreshNodesWithChildOfTypes(String[] types) {
        DTreeRootItem root = this.getRoot();
        if (root == null) {
            return;
        }
        VxxtTRACE.out("DataDrivenTree.refreshNodesWithChildOfTypes " + types);
        if (types == null) {
            this.refreshDecendantsOfItem((DTreeItem)root);
        } else {
            this.refreshChildOfTypes((DTreeItem)root, types);
        }
    }

    private void refreshChildOfTypes(DTreeItem parent, String[] types) {
        if (parent != null && parent.isExpanded()) {
            DTreeItem child;
            int num;
            boolean bRefresh = false;
            if (parent instanceof TreeItem) {
                int index = 0;
                while (index < types.length) {
                    String parentType = ((TreeItem)parent).getType();
                    if (parentType.equalsIgnoreCase(VxxTypes.getContainerType(types[index]))) {
                        bRefresh = true;
                        break;
                    }
                    ++index;
                }
            }
            if (!bRefresh) {
                num = parent.getItemCount();
                int i = 0;
                while (i < num && !bRefresh) {
                    child = parent.getItem(i);
                    if (child instanceof TreeItem) {
                        String childType = ((TreeItem)child).getType();
                        if (types != null && childType != null) {
                            int index = 0;
                            while (index < types.length) {
                                if (childType.equalsIgnoreCase(types[index])) {
                                    bRefresh = true;
                                    break;
                                }
                                ++index;
                            }
                        }
                    }
                    ++i;
                }
            }
            if (bRefresh) {
                this.refreshChildrenOfItem(parent);
            }
            if ((num = parent.getItemCount()) == 0) {
                parent.setExpanded(false);
            } else {
                int i = 0;
                while (i < num) {
                    child = parent.getItem(i);
                    this.refreshChildOfTypes(child, types);
                    ++i;
                }
            }
        }
    }

    private void refreshTypeAndName(DTreeItem parent, String type, String name) {
        if (parent != null && parent.isExpanded()) {
            boolean bRefresh = false;
            if (parent instanceof TreeItem) {
                TreeItem ddParent = (TreeItem)parent;
                String parentType = ddParent.getType();
                String parentName = ddParent.getLabel();
                if (parentType != null && parentType.equalsIgnoreCase(type) && (name == null || name.equalsIgnoreCase(parentName))) {
                    bRefresh = true;
                }
            }
            if (bRefresh) {
                this.refreshDecendantsOfItem(parent);
            } else {
                int num = parent.getItemCount();
                if (num == 0) {
                    parent.setExpanded(false);
                } else {
                    int i = 0;
                    while (i < num) {
                        DTreeItem child = parent.getItem(i);
                        this.refreshTypeAndName(child, type, name);
                        ++i;
                    }
                }
            }
        }
    }

    private void refreshDecendantsOfItem(DTreeItem parent) {
        this.refreshChildrenOfItem(parent);
        if (parent.isExpanded()) {
            int num = parent.getItemCount();
            int i = 0;
            while (i < num) {
                DTreeItem child = parent.getItem(i);
                this.refreshDecendantsOfItem(child);
                ++i;
            }
        }
    }

    private void refreshChildrenOfItem(DTreeItem parent) {
        if (parent.isExpanded()) {
            if (!(parent instanceof DTreeDeferringParent)) {
                return;
            }
            OneDDataSource ds = ((DTreeDeferringParent)parent).getDataSource();
            if (ds instanceof TreeDataSource) {
                ((TreeDataSource)ds).refreshData();
                parent.setExpanded(true);
            }
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        Enumeration listeners;
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        super.processMouseEvent(evt);
        if (evt.isPopupTrigger() && this.m_rightMouseLm != null && (listeners = this.m_rightMouseLm.getListeners()) != null) {
            PopupCommandMenu menu = new PopupCommandMenu();
            while (listeners.hasMoreElements()) {
                PopupMenuListener l = (PopupMenuListener)listeners.nextElement();
                l.buildRMouseMenu(menu);
            }
            if (menu.getItemCount() > 0) {
                ((Component)((Object)this)).add(menu);
                menu.show((Component)((Object)this), x, y);
            }
        }
    }

    protected void processKeyEvent(KeyEvent evt) {
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        super.processKeyEvent(evt);
    }

    public boolean selectChildNode(String label) {
        DTreeItem parent = this.getSelectedNode();
        if (parent == null) {
            return false;
        }
        int childIndex = this.findChild(parent, label);
        if (childIndex == -1) {
            return false;
        }
        DTreeRange range = new DTreeRange(parent, childIndex, 1);
        DTreeRangeSet rangeSet = new DTreeRangeSet();
        rangeSet.addRange(range);
        this.getSelection().setSelectionRanges(rangeSet);
        this.makeVisible(parent.getItem(childIndex));
        return true;
    }

    private int findChild(DTreeItem parent, String label) {
        if (parent == null) {
            return -1;
        }
        if (!parent.isExpanded()) {
            return -1;
        }
        int num = parent.getItemCount();
        if (num == 0) {
            return -1;
        }
        int i = 0;
        while (i < num) {
            String childLabel;
            DTreeItem child = parent.getItem(i);
            if (child instanceof TreeItem && (childLabel = ((TreeItem)child).getLabel()).equalsIgnoreCase(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private DTreeItem getSelectedNode() {
        DTreeRangeSet selectionRanges = this.getSelection().getSelectionRanges();
        if (selectionRanges.getCount() != 1) {
            return null;
        }
        DTreeRange selectedRange = selectionRanges.getRange(0);
        DTreeItem parent = selectedRange.getParent();
        if (selectedRange.getCount() != 1) {
            return null;
        }
        int start = selectedRange.getStartIndex();
        DTreeItem selectedNode = parent.getItem(start);
        return selectedNode;
    }

    public EMSelection[] getSelectedItems() {
        Vector<EMSelection> selObjVector = new Vector<EMSelection>();
        DTreeRangeSet selectionRanges = this.getSelection().getSelectionRanges();
        int rangeIndex = 0;
        while (rangeIndex < selectionRanges.getCount()) {
            int start;
            DTreeRange selectedRange = selectionRanges.getRange(rangeIndex);
            DTreeItem parent = selectedRange.getParent();
            int count = selectedRange.getCount();
            int itemIndex = start = selectedRange.getStartIndex();
            while (itemIndex < start + count) {
                DTreeItem selectedNode = parent.getItem(itemIndex);
                if (selectedNode instanceof TreeItem) {
                    TreeItem p;
                    DTreeItem item;
                    TreeItem vtaSelNode = (TreeItem)selectedNode;
                    EMSelection selection = new EMSelection(vtaSelNode.getType(), vtaSelNode.getID());
                    selObjVector.addElement(selection);
                    TreeProxy proxy = vtaSelNode.getProxy();
                    if (vtaSelNode.getProxy() != null) {
                        vtaSelNode.getProxy().setSelectionInfo(selection, vtaSelNode);
                    }
                    if ((item = vtaSelNode.getParent()) instanceof TreeItem && (p = (TreeItem)item) != null && p.getType() != null && p.getType().equalsIgnoreCase("oracle_sysman_group")) {
                        String[] data = new String[]{p.getType(), p.getID()};
                        selection.setData(data);
                    }
                }
                ++itemIndex;
            }
            ++rangeIndex;
        }
        Object[] selList = new EMSelection[selObjVector.size()];
        selObjVector.copyInto(selList);
        return selList;
    }
}

