/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.awt.Menu;
import java.awt.MenuItem;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.emSDK.client.consoleIntegration.ToolDisplayDriver;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceRegistry;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuSource;
import oracle.sysman.emSDK.client.omsClient.ConsoleClient;
import oracle.sysman.emSDK.client.omsClient.EMClientRegistry;
import oracle.sysman.emSDK.client.omsClient.TargetManager;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.emSDK.common.registry.PaletteApplication;
import oracle.sysman.emSDK.common.target.Target;
import oracle.sysman.vtaGallery.vtaEmTree.VtaEmTree;
import oracle.sysman.vtx.VtxSeperator;
import oracle.sysman.vxx.VxxSortVector;

public class ServiceProxy
extends TreeProxy
implements PopupMenuSource {
    private static MessageBundle m_msgFile = MessageBundle.getMessageBundle("Vta");
    private static MessageBundle m_vtcMsgFile = MessageBundle.getMessageBundle("Vtc");

    public ServiceProxy(DataDrivenTree tree) {
        super(tree);
    }

    public ServiceProxy() {
    }

    public static Vector getRelatedToolsCommandItems(TreeItem node, DataDrivenTree tree) {
        Vector<Menu> itemList = new Vector<Menu>();
        String type = node.getType();
        TreeDataSourceRegistry registry = tree.getDSRegistry();
        if (registry instanceof EMClientRegistry) {
            EMClientRegistry clientRegistry = (EMClientRegistry)registry;
            Object[] tools = clientRegistry.getRelatedTools(type);
            if ((tools = EMClientRegistry.filterPlatformApps((PaletteApplication[])tools)) != null && tools.length > 0) {
                String strTools = m_msgFile.getMessage("3033", false);
                Menu relatedTools = new Menu(strTools);
                Collator coll = Collator.getInstance();
                CollationKey[] keys = new CollationKey[tools.length];
                Hashtable<String, String> hDisplayNames = new Hashtable<String, String>();
                int i = 0;
                while (i < tools.length) {
                    String displayName = new String(tools[i].getInternalName());
                    try {
                        ToolDisplayDriver info = (ToolDisplayDriver)Class.forName(tools[i].getDisplayClass()).newInstance();
                        displayName = info.getLabel(tools[i].getInternalName());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                    keys[i] = coll.getCollationKey(displayName);
                    hDisplayNames.put(tools[i].getInternalName(), displayName);
                    ++i;
                }
                VxxSortVector.quickSortItemsByCollKey(keys, tools);
                int i2 = 0;
                while (i2 < tools.length) {
                    String displayName = (String)hDisplayNames.get(tools[i2].getInternalName());
                    PopupMenuCommandItem menuItem = new PopupMenuCommandItem(1403, displayName, type, 2);
                    menuItem.setCommand(tools[i2].getInternalName());
                    relatedTools.add(menuItem);
                    ++i2;
                }
                itemList.addElement(relatedTools);
            }
        }
        return itemList;
    }

    public static Vector getStdRMenuCommandItems(TreeItem node, DataDrivenTree tree) {
        Vector<MenuItem> vectorMenuItems = new Vector<MenuItem>();
        String strMenu = m_msgFile.getMessage("3034", false);
        vectorMenuItems.addElement(new PopupMenuCommandItem(904, strMenu, node.getType(), 10));
        strMenu = m_msgFile.getMessage("3035", false);
        vectorMenuItems.addElement(new PopupMenuCommandItem(901, strMenu, node.getType(), 10));
        Vector vectorTools = ServiceProxy.getRelatedToolsCommandItems(node, tree);
        if (vectorTools.size() > 0) {
            vectorMenuItems.addElement(VtxSeperator.getSeperator());
        }
        Enumeration enumTools = vectorTools.elements();
        while (enumTools.hasMoreElements()) {
            vectorMenuItems.addElement((MenuItem)enumTools.nextElement());
        }
        return vectorMenuItems;
    }

    public Vector getRMenuCommandItems(TreeItem node) {
        return ServiceProxy.getStdRMenuCommandItems(node, this.getTree());
    }

    public static MenuItem getCreateBPMenuItem(TreeItem node) {
        String type = node.getType();
        String nlsText = m_vtcMsgFile.getMessage("4631", false);
        PopupMenuCommandItem popUpMenuItem = new PopupMenuCommandItem(1310, nlsText, type, 10);
        return popUpMenuItem;
    }

    public static MenuItem getTotalBlackoutMenuItem(TreeItem node, DataDrivenTree tree) {
        String menuText;
        int commandId;
        boolean totalBlackout = false;
        boolean isSuperUser = false;
        if (tree instanceof VtaEmTree) {
            ConsoleClient client = (ConsoleClient)((VtaEmTree)tree).getClient();
            try {
                TargetManager targetManager = client.getTargetManager();
                Target target = new Target(node.getID(), node.getType());
                totalBlackout = targetManager.isTotalBlackout(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isSuperUser = client.isSuperUser();
        }
        if (totalBlackout) {
            commandId = 1309;
            menuText = m_vtcMsgFile.getMessage("4633", false);
        } else {
            commandId = 1308;
            menuText = m_vtcMsgFile.getMessage("4632", false);
        }
        PopupMenuCommandItem pm = new PopupMenuCommandItem(commandId, menuText, node.getType(), 2);
        pm.setEnabled(isSuperUser);
        return pm;
    }
}

