/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.awt.Image;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.EmptyDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceLoader;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceRegistry;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceUtils;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItemData;

public abstract class TreeDataSource
implements OneDDataSource,
DTreeItemFactory {
    private ListenerManager m_oneDManager;
    private TreeDataSource[] m_dsList;
    private TreeItem m_node;
    private boolean m_checkRegistry = false;
    private static TreeDataSourceLoader m_dsLoader = null;
    private Image[] m_imageList;
    private DataDrivenTree m_tree;
    private boolean m_sorted = false;

    public TreeDataSource(DataDrivenTree tree) {
        this.m_tree = tree;
        this.init();
        this.setCheckRegistry(true);
    }

    protected TreeDataSource() {
    }

    public void setTree(DataDrivenTree tree) {
        this.m_tree = tree;
        this.init();
    }

    public void resetTree(DataDrivenTree tree) {
        this.m_tree = tree;
    }

    protected void init() {
        TreeDataSourceRegistry reg = this.m_tree.getDSRegistry();
        if (reg != null) {
            m_dsLoader = new TreeDataSourceLoader(this.m_tree, reg);
        }
    }

    protected abstract DTreeItem internal_createItem(DTreeDeferringParent var1, int var2);

    protected abstract int internal_getItemCount();

    protected abstract Object internal_getData(int var1);

    protected abstract void internal_setData(int var1, Object var2);

    protected abstract void internal_clearData();

    protected abstract void internal_refreshData();

    protected void setImageList(Image[] imgList) {
        this.m_imageList = imgList;
    }

    protected Image[] getImageList() {
        return this.m_imageList;
    }

    public TreeItem getNode() {
        return this.m_node;
    }

    protected void setNode(TreeItem node) {
        this.m_node = node;
    }

    protected void setSorted(boolean sorted) {
        this.m_sorted = sorted;
    }

    protected boolean isSorted() {
        return this.m_sorted;
    }

    protected DataDrivenTree getTree() {
        return this.m_tree;
    }

    protected void setCheckRegistry(boolean checkRegistry) {
        this.m_checkRegistry = checkRegistry;
    }

    protected void processEvent(OneDDataSourceEvent evt) {
        Enumeration listeners;
        if (this.m_oneDManager == null || (listeners = this.m_oneDManager.getListeners()) == null) {
            return;
        }
        int evtid = evt.getID();
        while (listeners.hasMoreElements()) {
            OneDDataSourceListener l = (OneDDataSourceListener)listeners.nextElement();
            switch (evtid) {
                case 2001: {
                    l.itemsAdded(evt);
                    break;
                }
                case 2002: {
                    l.itemsRemoved(evt);
                    break;
                }
                case 2003: {
                    l.invalidateItems(evt);
                    break;
                }
            }
        }
    }

    public final int getItemCount() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        int numItems = this.m_dsList[0].internal_getItemCount();
        if (this.m_checkRegistry) {
            int i = 1;
            while (i < this.m_dsList.length) {
                numItems += this.m_dsList[i].internal_getItemCount();
                ++i;
            }
        }
        return numItems;
    }

    public final Object getData(int index) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return null;
        }
        return this.m_dsList[helper.dsIndex].internal_getData(helper.itemIndex);
    }

    public final void setData(int index, Object data) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return;
        }
        this.m_dsList[helper.dsIndex].internal_setData(helper.itemIndex, data);
    }

    public final void addDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager == null) {
            this.m_oneDManager = new ListenerManager();
        }
        this.m_oneDManager.addListener((EventListener)listener);
    }

    public final void removeDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager != null) {
            this.m_oneDManager.removeListener((EventListener)listener);
        }
    }

    public final DTreeItem createItem(DTreeDeferringParent parent, int index) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return null;
        }
        return this.m_dsList[helper.dsIndex].internal_createItem(parent, helper.itemIndex);
    }

    public final void clearData() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        this.m_dsList[0].internal_clearData();
        if (this.m_checkRegistry) {
            int i = 1;
            while (i < this.m_dsList.length) {
                this.m_dsList[i].internal_clearData();
                ++i;
            }
        }
    }

    public final void refreshData() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        if (this.m_checkRegistry) {
            int i = this.m_dsList.length - 1;
            while (i > 0) {
                this.m_dsList[i].internal_refreshData();
                --i;
            }
        }
        this.m_dsList[0].internal_refreshData();
    }

    public boolean isNodeExpandable() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        return !(this instanceof EmptyDataSource) || this.m_dsList.length != 1;
    }

    private DSHelper _locate(int index) {
        int i = 0;
        while (i < this.m_dsList.length) {
            int count = this.m_dsList[i].internal_getItemCount();
            if (index < count) {
                return new DSHelper(i, index);
            }
            index -= count;
            ++i;
        }
        return null;
    }

    private void _loadDataSources() {
        Vector dsList_temp = null;
        int dsCount = 0;
        if (m_dsLoader != null && this.m_checkRegistry && (dsList_temp = m_dsLoader.getRegisteredDataSourceItems(this.m_node.getContext())) != null) {
            dsCount = dsList_temp.size();
        }
        this.m_dsList = new TreeDataSource[dsCount + 1];
        this.m_dsList[0] = this;
        int i = 0;
        while (i < dsCount) {
            this.m_dsList[i + 1] = (TreeDataSource)dsList_temp.elementAt(i);
            this.m_dsList[i + 1].m_node = this.m_node;
            this.m_dsList[i + 1].m_oneDManager = this.m_oneDManager;
            ++i;
        }
    }

    protected String[] getOriginalList() {
        int originalNum = this.internal_getItemCount();
        String[] originalList = new String[originalNum];
        int i = 0;
        while (i < originalNum) {
            originalList[i] = ((TreeItemData)this.internal_getData(i)).getLabel();
            ++i;
        }
        return originalList;
    }

    protected String[] getRefreshedList() {
        int refreshedNum = this.internal_getItemCount();
        String[] refreshedList = new String[refreshedNum];
        int i = 0;
        while (i < refreshedNum) {
            refreshedList[i] = ((TreeItemData)this.internal_getData(i)).getLabel();
            ++i;
        }
        return refreshedList;
    }

    protected void optimizeRefresh(String[] originalList, String[] refreshedList) {
        Vector deletedEventList = new Vector();
        Vector addedEventList = new Vector();
        TreeDataSourceUtils.generateRefreshEvent(originalList, refreshedList, this.isSorted(), deletedEventList, addedEventList, this);
        int i = deletedEventList.size() - 1;
        while (i >= 0) {
            OneDDataSourceEvent evt = (OneDDataSourceEvent)deletedEventList.elementAt(i);
            this.processEvent(evt);
            --i;
        }
        int i2 = 0;
        while (i2 < addedEventList.size()) {
            OneDDataSourceEvent evt = (OneDDataSourceEvent)addedEventList.elementAt(i2);
            this.processEvent(evt);
            ++i2;
        }
    }

    class DSHelper {
        int dsIndex;
        int itemIndex;

        DSHelper(int ds, int item) {
            TreeDataSource.this = TreeDataSource.this;
            this.dsIndex = ds;
            this.itemIndex = item;
        }
    }
}

