/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import oracle.ewt.dTree.DTreeActivateListener;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ApplicationAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.SystemEvent;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupCommandMenu;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuCommand;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuListener;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuSource;
import oracle.sysman.emSDK.client.guiComponent.selection.EMSelectionManager;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class TreeEventManager
implements DTreeSelectionListener,
DTreeExpansionListener,
DTreeActivateListener,
PopupMenuListener,
ActionListener,
FocusListener,
KeyListener,
ItemListener {
    private DataDrivenTree m_tree;

    public void setTree(DataDrivenTree tree) {
        this.m_tree = tree;
    }

    public DataDrivenTree getTree() {
        return this.m_tree;
    }

    public void dTreeSelectionChanging(DTreeSelectionEvent evt) {
        DTreeRangeSet selectionRanges = this.m_tree.getSelection().getSelectionRanges();
        int rangeIndex = 0;
        while (rangeIndex < selectionRanges.getCount()) {
            int start;
            DTreeRange selectedRange = selectionRanges.getRange(rangeIndex);
            DTreeItem parent = selectedRange.getParent();
            int count = selectedRange.getCount();
            int itemIndex = start = selectedRange.getStartIndex();
            while (itemIndex < start + count) {
                TreeProxy proxy;
                DTreeItem selected = parent.getItem(itemIndex);
                if (selected instanceof TreeItem && (proxy = ((TreeItem)selected).getProxy()) != null && proxy instanceof TreeNodeSelectionListener) {
                    ((TreeNodeSelectionListener)((Object)proxy)).treeSelectionChanging(evt, (TreeItem)selected);
                }
                ++itemIndex;
            }
            ++rangeIndex;
        }
    }

    public void dTreeSelectionChanged(DTreeSelectionEvent evt) {
        DTreeRangeSet selectionRanges = this.m_tree.getSelection().getSelectionRanges();
        int rangeIndex = 0;
        while (rangeIndex < selectionRanges.getCount()) {
            int start;
            DTreeRange selectedRange = selectionRanges.getRange(rangeIndex);
            DTreeItem parent = selectedRange.getParent();
            int count = selectedRange.getCount();
            int itemIndex = start = selectedRange.getStartIndex();
            while (itemIndex < start + count) {
                TreeProxy proxy;
                DTreeItem selected = parent.getItem(itemIndex);
                if (selected instanceof TreeItem && (proxy = ((TreeItem)selected).getProxy()) != null && proxy instanceof TreeNodeSelectionListener) {
                    ((TreeNodeSelectionListener)((Object)proxy)).treeSelectionChanged(evt, (TreeItem)selected);
                }
                ++itemIndex;
            }
            ++rangeIndex;
        }
    }

    public void dTreeItemCollapsed(DTreeItemEvent evt) {
        TreeProxy proxy;
        DTreeItem item = evt.getItem();
        if (item instanceof TreeItem && (proxy = ((TreeItem)item).getProxy()) != null && proxy instanceof DTreeExpansionListener) {
            ((DTreeExpansionListener)proxy).dTreeItemCollapsed(evt);
        }
    }

    public void dTreeItemCollapsing(DTreeItemEvent evt) {
        TreeProxy proxy;
        DTreeItem item = evt.getItem();
        if (item instanceof TreeItem && (proxy = ((TreeItem)item).getProxy()) != null && proxy instanceof DTreeExpansionListener) {
            ((DTreeExpansionListener)proxy).dTreeItemCollapsing(evt);
        }
    }

    public void dTreeItemExpanded(DTreeItemEvent evt) {
        TreeProxy proxy;
        DTreeItem item = evt.getItem();
        if (item instanceof TreeItem && (proxy = ((TreeItem)item).getProxy()) != null && proxy instanceof DTreeExpansionListener) {
            ((DTreeExpansionListener)proxy).dTreeItemExpanded(evt);
        }
    }

    public void dTreeItemExpanding(DTreeItemEvent evt) {
        TreeProxy proxy;
        DTreeItem item = evt.getItem();
        if (item instanceof TreeItem && (proxy = ((TreeItem)item).getProxy()) != null && proxy instanceof DTreeExpansionListener) {
            ((DTreeExpansionListener)proxy).dTreeItemExpanding(evt);
        }
    }

    public void dTreeItemActivate(DTreeItemEvent evt) {
        TreeProxy proxy;
        DTreeItem item = evt.getItem();
        if (item instanceof TreeItem && (proxy = ((TreeItem)item).getProxy()) != null && proxy instanceof DTreeActivateListener) {
            ((DTreeActivateListener)proxy).dTreeItemActivate(evt);
        }
    }

    public void buildRMouseMenu(PopupCommandMenu menu) {
        DTreeRangeSet selectionRanges = this.m_tree.getSelection().getSelectionRanges();
        int selCount = selectionRanges == null ? 0 : (selectionRanges.getCount() == 1 ? selectionRanges.getRange(0).getCount() : 2);
        Vector menuItemList = null;
        Object enabled = null;
        String selType = "";
        int rangeIndex = 0;
        while (rangeIndex < selectionRanges.getCount()) {
            int start;
            DTreeRange selectedRange = selectionRanges.getRange(rangeIndex);
            DTreeItem parent = selectedRange.getParent();
            int count = selectedRange.getCount();
            int itemIndex = start = selectedRange.getStartIndex();
            while (itemIndex < start + count) {
                TreeItem item;
                TreeProxy proxy;
                DTreeItem selected = parent.getItem(itemIndex);
                if (selected instanceof TreeItem && (proxy = (item = (TreeItem)selected).getProxy()) instanceof PopupMenuSource) {
                    menuItemList = ((PopupMenuSource)((Object)proxy)).getRMenuCommandItems(item);
                }
                ++itemIndex;
            }
            ++rangeIndex;
        }
        if (menuItemList != null) {
            int i = 0;
            while (i < menuItemList.size()) {
                Object item = menuItemList.elementAt(i);
                if (item instanceof MenuItem) {
                    MenuItem mItem = (MenuItem)item;
                    if (mItem.getName().equals("SEPARATOR")) {
                        menu.addSeparator();
                    } else {
                        this.registerMenuItemListener(mItem);
                        menu.add(mItem);
                    }
                }
                ++i;
            }
        }
    }

    private void registerMenuItemListener(MenuItem item) {
        if (item instanceof PopupMenuCommand) {
            item.addActionListener(this);
        } else if (item instanceof Menu) {
            Menu menu = (Menu)item;
            int i = 0;
            while (i < menu.getItemCount()) {
                this.registerMenuItemListener(menu.getItem(i));
                ++i;
            }
        }
    }

    private int _findItem(Vector itemList, PopupMenuCommand item) {
        int i = 0;
        while (i < itemList.size()) {
            PopupMenuCommand currentItem = (PopupMenuCommand)itemList.elementAt(i);
            if (currentItem.getCommand().equals(item.getCommand())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean _enableItem(PopupMenuCommand item, int selCount, String type) {
        int flags = item.getEnableFlags();
        if (selCount == 0) {
            VxxtTRACE.out("TreeEventManager:No selection on right mouse!");
            return false;
        }
        if (selCount == 1) {
            if (flags == 255) {
                return true;
            }
            if ((flags & 2) > 0) {
                return true;
            }
        } else {
            if (flags == 255) {
                return true;
            }
            if ((flags & 8) > 0) {
                return true;
            }
            if ((flags & 4) > 0) {
                return !type.equals("_mixed_types_selected_");
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof CommandItem) {
            CommandItem source = (CommandItem)evt.getSource();
            String command = source.getCommand();
            ApplicationAdapter adapter = this.getTree().getCommandAdapter();
            if (adapter != null) {
                adapter.commandIssued(new CommandEvent(evt));
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() instanceof CommandItem) {
            CommandItem source = (CommandItem)evt.getSource();
            String command = source.getCommand();
            ApplicationAdapter adapter = this.getTree().getCommandAdapter();
            if (adapter != null) {
                adapter.commandIssued(new CommandEvent(evt));
            }
        }
    }

    public void focusGained(FocusEvent event) {
        EMSelectionManager manager = this.m_tree.getSelectionManager();
        if (manager != null) {
            manager.setCurrentSelectionComponent(this.m_tree);
        }
    }

    public void focusLost(FocusEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            ApplicationAdapter adapter = this.getTree().getCommandAdapter();
            SystemEvent sysevt = new SystemEvent(event.getSource(), 901);
            if (adapter != null) {
                adapter.commandIssued(sysevt);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }
}

