/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataSource;

import java.awt.Container;
import java.awt.FontMetrics;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.dataSource.Sortable;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.vtx.VtxCachedResultSet;

public class DataSource
implements TwoDDataSource,
OneDDataSource,
Sortable {
    boolean m_cleanupDone = false;
    boolean m_gotData = false;
    boolean m_sendingEvent = false;
    boolean m_gotColCount = false;
    int m_colCount;
    boolean m_gotRowCount = false;
    int m_rowCount;
    VtxCachedResultSet m_resultSet;
    ListenerManager m_twoDManager;
    ListenerManager m_oneDManager;
    protected int m_sortColumn = -1;
    protected boolean m_sortAscending = true;
    Container m_panel;
    Object m_refreshDataSync = new Object();

    public DataSource() {
    }

    public DataSource(String[] headerStrings, String[][] dataStrings) {
        this.m_resultSet = new VtxCachedResultSet(headerStrings, dataStrings);
        this.m_resultSet.set2DClient(this);
        this.m_resultSet.set1DClient(this);
        this.m_rowCount = this.m_resultSet.getNumRows();
        this.m_colCount = this.m_resultSet.getNumColumns();
        this.m_gotData = true;
        this.m_gotRowCount = true;
        this.m_gotColCount = true;
    }

    public void updateRowInfo() {
        Enumeration en = this.m_twoDManager.getListeners();
        if (en != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2004, 0, this.getRowCount());
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.rowsAdded(event);
            }
        }
    }

    public void clearData() {
        Enumeration en = this.m_twoDManager.getListeners();
        if (en != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2005, 0, this.getRowCount());
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.rowsRemoved(event);
            }
        }
    }

    public void rowChangeNotify(int first, int rowCount) {
        Enumeration en = this.m_twoDManager.getListeners();
        if (en != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2006, first, rowCount);
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.invalidateRows(event);
            }
        }
    }

    public void replaceDataSet(String[] headerStrings, String[][] dataStrings) {
        this.clearData();
        this.m_resultSet = new VtxCachedResultSet(headerStrings, dataStrings);
        this.m_resultSet.set2DClient(this);
        this.m_resultSet.set1DClient(this);
        this.m_rowCount = this.m_resultSet.getNumRows();
        this.m_colCount = this.m_resultSet.getNumColumns();
        this.m_gotData = true;
        this.m_gotRowCount = true;
        this.m_gotColCount = true;
        this.updateRowInfo();
        this.reSort();
    }

    public void addData(String[] newData) {
        Enumeration en;
        Vector<String> newRow = new Vector<String>();
        int j = 0;
        while (j < newData.length) {
            newRow.addElement(newData[j]);
            ++j;
        }
        this.m_resultSet.addData(newRow);
        ++this.m_rowCount;
        if (this.m_twoDManager != null && (en = this.m_twoDManager.getListeners()) != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2004, this.m_rowCount - 1, 1);
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.rowsAdded(event);
            }
        }
    }

    public void reset() {
        this.m_rowCount = 0;
    }

    public void setPanel(Container p) {
        this.m_panel = p;
    }

    public int getColumnWidth(int whichColumnIndex) {
        String stuff = this.m_resultSet.getColumnLabel(whichColumnIndex);
        FontMetrics metrics = this.m_panel.getFontMetrics(this.m_panel.getFont());
        int stringWidth = metrics.stringWidth(stuff);
        return stringWidth;
    }

    public void sort(int colIndex, boolean ascending) {
        Object object = this.m_refreshDataSync;
        synchronized (object) {
            this.m_sortColumn = colIndex;
            this.m_sortAscending = ascending;
        }
        this.reSort();
    }

    public void reSort() {
        if (this.m_sortColumn != -1) {
            this.m_resultSet.sort(this.m_sortColumn, this.m_sortAscending);
            this.rowChangeNotify(0, this.getRowCount());
        }
    }

    public void addDataSourceListener(TwoDDataSourceListener listener) {
        if (this.m_twoDManager == null) {
            this.m_twoDManager = new ListenerManager();
        }
        this.m_twoDManager.addListener((EventListener)listener);
    }

    public void removeDataSourceListener(TwoDDataSourceListener listener) {
        if (this.m_twoDManager != null) {
            this.m_twoDManager.removeListener((EventListener)listener);
        }
    }

    public int getColumnCount() {
        return this.m_colCount;
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException();
        }
        String cellData = this.m_resultSet.getItem(rowIndex, columnIndex);
        return cellData;
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        this.m_resultSet.setItem(rowIndex, columnIndex, data.toString());
    }

    public void updateData(int columnIndex, int rowIndex, Object data) {
        this.m_resultSet.updateItem(rowIndex, columnIndex, data.toString());
    }

    public void addDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager == null) {
            this.m_oneDManager = new ListenerManager();
        }
        this.m_oneDManager.addListener((EventListener)listener);
    }

    public void removeDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager != null) {
            this.m_oneDManager.removeListener((EventListener)listener);
        }
    }

    public int getItemCount() {
        int colCount = 0;
        Object object = this.m_refreshDataSync;
        synchronized (object) {
            colCount = this.getColumnCount();
        }
        return colCount;
    }

    public Object getData(int index) {
        String stuff = null;
        Object object = this.m_refreshDataSync;
        synchronized (object) {
            stuff = this.m_resultSet.getColumnLabel(index);
        }
        return stuff;
    }

    public void setData(int index, Object data) {
    }

    protected VtxCachedResultSet getCachedResultSet() {
        return this.m_resultSet;
    }

    public void addDataAt(String[] newData, int index) {
        Vector<String> newRow = new Vector<String>();
        int j = 0;
        while (j < newData.length) {
            newRow.addElement(newData[j]);
            ++j;
        }
        this.m_resultSet.addDataAt(newRow, index);
        ++this.m_rowCount;
        Enumeration en = this.m_twoDManager.getListeners();
        if (en != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2004, index, 1);
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.rowsAdded(event);
            }
        }
    }

    public void removeDataAt(int index) {
        this.m_resultSet.removeDataAt(index);
        --this.m_rowCount;
        Enumeration en = this.m_twoDManager.getListeners();
        if (en != null) {
            TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2005, index, 1);
            while (en.hasMoreElements()) {
                TwoDDataSourceListener listener = (TwoDDataSourceListener)en.nextElement();
                listener.rowsRemoved(event);
            }
        }
    }
}

