/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.multiColumnWidget;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderResizeListener;
import oracle.ewt.table.SpreadTable;
import oracle.sysman.emSDK.client.dataComponent.multiColumnWidget.ResizeColumnInfo;

class ExpandingColumnResizer
extends ComponentAdapter {
    private SpreadTable m_spreadTable;
    private Vector m_columnInfo = new Vector();

    public ExpandingColumnResizer(SpreadTable st) {
        this.m_spreadTable = st;
        st.getColumnHeader().addResizeListener((HeaderResizeListener)new 1());
    }

    public ExpandingColumnResizer(SpreadTable st, int column) {
        this(st);
        this.addExpander(column);
    }

    public ExpandingColumnResizer(SpreadTable st, int[] column) {
        this(st);
        this.addExpanders(column, null, null);
    }

    public ExpandingColumnResizer(SpreadTable st, int[] column, int[] min, int[] weight) {
        this(st);
        this.addExpanders(column, min, weight);
    }

    private void addInfo(ResizeColumnInfo info) {
        int i = 0;
        while (i < this.getInfoCount()) {
            ResizeColumnInfo check = this.getInfo(i);
            if (info.getWeight() <= check.getWeight()) break;
            ++i;
        }
        this.m_columnInfo.insertElementAt(info, i);
        this.resize();
    }

    private ResizeColumnInfo getInfo(int index) {
        return (ResizeColumnInfo)this.m_columnInfo.elementAt(index);
    }

    private void removeInfo(int index) {
        this.m_columnInfo.removeElementAt(index);
        this.resize();
    }

    private int getInfoCount() {
        return this.m_columnInfo.size();
    }

    public synchronized void addExpander(int column) {
        this.addInfo(new ResizeColumnInfo(column));
    }

    public synchronized void addExpander(int column, int min, int weight) {
        this.addInfo(new ResizeColumnInfo(column, min, weight));
    }

    public synchronized void addExpanders(int[] column) {
        this.addExpanders(column, null, null);
    }

    public synchronized void addExpanders(int[] column, int[] min, int[] weight) {
        int i = 0;
        while (i < column.length) {
            ResizeColumnInfo info = new ResizeColumnInfo(column[i]);
            if (min != null) {
                info.setMin(min[i]);
            }
            if (weight != null) {
                info.setWeight(weight[i]);
            }
            this.addInfo(info);
            ++i;
        }
    }

    public synchronized void removeExpander(int column) {
        int index = this.columnToIndex(column);
        if (index >= 0) {
            this.removeInfo(index);
        }
    }

    private int columnToIndex(int column) {
        Grid grid = this.m_spreadTable.getGrid();
        int i = 0;
        while (i < this.getInfoCount()) {
            if (column == this.indexToColumn(i, grid)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexToColumn(int index, Grid grid) {
        int col = this.getInfo(index).getCol();
        if (col < 0) {
            col += grid.getColumnCount();
        }
        return col;
    }

    private int getCurrentColumnSize(Grid grid) {
        int size = 0;
        int i = 0;
        while (i < grid.getColumnCount()) {
            if (grid.isColumnVisible(i)) {
                size += grid.getColumnWidth(i);
            }
            ++i;
        }
        return size;
    }

    private int getResizeColumnSize(Grid grid) {
        int size = 0;
        int i = 0;
        while (i < this.getInfoCount()) {
            int column = this.indexToColumn(i, grid);
            if (grid.isColumnVisible(column)) {
                size += grid.getColumnWidth(column);
            }
            ++i;
        }
        return size;
    }

    private int getFixedColumnSize(Grid grid) {
        return this.getCurrentColumnSize(grid) - this.getResizeColumnSize(grid);
    }

    private int sumWeights(Grid grid) {
        int totalWeight = 0;
        int i = 0;
        while (i < this.getInfoCount()) {
            int column = this.indexToColumn(i, grid);
            if (grid.isColumnVisible(column)) {
                totalWeight += this.getInfo(i).getWeight();
            }
            ++i;
        }
        return totalWeight;
    }

    private void parselDistrib(Grid grid, int distrib) {
        int totalWeight = this.sumWeights(grid);
        int i = 0;
        while (i < this.getInfoCount()) {
            if (totalWeight == 0) {
                throw new ArithmeticException("/0 ExpandingColumnResizer.java");
            }
            int column = this.indexToColumn(i, grid);
            if (grid.isColumnVisible(column)) {
                ResizeColumnInfo info = this.getInfo(i);
                int width = distrib * info.getWeight() / totalWeight;
                int min = info.getMin();
                int extra = min - width;
                if (extra < 0) {
                    extra = 0;
                }
                this.m_spreadTable.setColumnWidth(column, width + extra);
                distrib -= width + extra;
                totalWeight -= info.getWeight();
            }
            ++i;
        }
    }

    public void componentResized(ComponentEvent e) {
        this.resize();
    }

    public synchronized void resize() {
        Grid grid;
        int newWidth = grid.getBounds().width;
        grid = this.m_spreadTable.getGrid();
        int current = this.getCurrentColumnSize(grid);
        if (newWidth == current) {
            return;
        }
        if (grid.getHorizontalSeparatorsVisible()) {
            newWidth -= grid.getColumnCount();
        }
        int resize = this.getResizeColumnSize(grid);
        int fixed = current - resize;
        int distrib = newWidth - fixed;
        this.parselDistrib(grid, distrib);
        this.m_spreadTable.repaint();
    }

    private final class 1
    implements HeaderResizeListener {
        public void itemResizing(HeaderEvent e) {
        }

        public void itemResized(HeaderEvent e) {
            ExpandingColumnResizer.this.removeExpander(e.getHeaderItem());
        }

        /* synthetic */ 1() {
        }
    }
}

