/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.multiColumnWidget;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.Sortable;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderItemInputHandler;
import oracle.ewt.header.HeaderResizeListener;
import oracle.ewt.header.HeaderSelection;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.table.TableColSelectListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollBox;
import oracle.sysman.emSDK.client.dataComponent.dataSource.DataSource;
import oracle.sysman.emSDK.client.dataComponent.multiColumnWidget.ExpandingColumnResizer;
import oracle.sysman.emSDK.client.dataComponent.multiColumnWidget.ExtractableSpreadTable;
import oracle.sysman.vtx.VtxSTableUtil;
import oracle.sysman.vtx.VtxWindowsUtil;

public class MultiColumnWidget
extends TableScrollBox
implements TableColSelectListener,
TableRowSelectListener,
GridRowSelectListener,
HeaderResizeListener,
HeaderItemInputHandler {
    ExtractableSpreadTable m_table;
    Grid m_grid;
    DataSource m_dataSource;
    Container m_panel;
    int sortColumn = -1;
    TwoDDataSource m_2Dds;
    OneDDataSource m_1Dds1;
    OneDDataSource m_1Dds2;
    boolean _resizing = false;
    boolean sortAscending = true;
    boolean m_sortable = true;
    ExpandingColumnResizer m_expandingResizer;

    public MultiColumnWidget() {
    }

    public MultiColumnWidget(DataSource ds, Container pnl) {
        this.m_2Dds = ds;
        this.m_1Dds1 = ds;
        this.m_1Dds2 = null;
        this.m_dataSource = ds;
        this.m_dataSource.setPanel(pnl);
        this.m_panel = pnl;
        this.doConstruct();
    }

    public MultiColumnWidget(TwoDDataSource ds1, OneDDataSource ds2, OneDDataSource ds3, Container pnl) {
        this.m_2Dds = ds1;
        this.m_1Dds1 = ds2;
        this.m_1Dds2 = ds3;
        this.m_panel = pnl;
        this.doConstruct();
    }

    public MultiColumnWidget(String[] oneDimSource, String[][] twoDimSource, Container pnl) {
        this(new DataSource(oneDimSource, twoDimSource), pnl);
    }

    void doConstruct() {
        this.m_table = new ExtractableSpreadTable(this.m_2Dds, this.m_1Dds1, this.m_1Dds2);
        this.m_table.addColSelectListener(this);
        this.m_table.addRowSelectListener(this);
        this.m_grid = this.m_table.getGrid();
        this.m_grid.setHorizontalSeparatorsVisible(false);
        this.m_grid.setVerticalSeparatorsVisible(false);
        this.m_grid.setDefaultPainter((Painter)new TextPainter());
        this.m_grid.setDefaultInputHandler(NullInputHandler.getCellInputHandler());
        this.m_grid.setGridSelection((GridSelection)new SingleRowSelection());
        this.m_grid.addRowSelectListener((GridRowSelectListener)this);
        this.m_grid.setDrawFocusCellHighlite(true);
        this.m_grid.setToolTipValue(GridToolTipClient.getToolTipClient());
        Header hdr = this.m_table.getColumnHeader();
        if (hdr != null) {
            hdr.setItemInputHandler((HeaderItemInputHandler)this);
            hdr.addResizeListener((HeaderResizeListener)this);
            VtxSTableUtil.enableAutoResize(this.m_table);
        }
        this.setContent((Component)((Object)this.m_table));
        this.m_table.setRowHeaderVisible(false);
    }

    void sortDataForColumn(int colIndex) {
        if (this.m_grid.getRowCount() == 0) {
            return;
        }
        if (this.m_sortable && this.m_2Dds instanceof Sortable) {
            if (this.sortColumn != colIndex) {
                this.sortColumn = colIndex;
                this.sortAscending = true;
            } else {
                this.sortAscending = !this.sortAscending;
            }
            VtxWindowsUtil.setCursor(Cursor.getPredefinedCursor(3), (Component)this.m_panel);
            ((Sortable)this.m_2Dds).sort(colIndex, this.sortAscending);
            this.m_grid.getGridSelection().deselectAll();
            this.m_table.setFirstRowOnScreen(0);
            VtxWindowsUtil.setCursor(Cursor.getDefaultCursor(), (Component)this.m_panel);
        }
    }

    public ExtractableSpreadTable getTable() {
        return this.m_table;
    }

    public Grid getGrid() {
        return this.m_grid;
    }

    public void setGridColumnCellInputHandler(int index, CellInputHandler inputHandler) {
        this.m_grid.setColumnCellInputHandler(index, inputHandler);
    }

    public void setGridDefaultInputHandler(CellInputHandler inputHandler) {
        this.m_grid.setDefaultInputHandler(inputHandler);
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void addData(String[] newData) {
        if (this.m_dataSource != null) {
            this.m_dataSource.addData(newData);
        }
    }

    public void setData(int columnIndex, int rowIndex, String newData) {
        this.m_dataSource.setData(columnIndex, rowIndex, newData);
    }

    public Object getData(int columnIndex, int rowIndex) {
        return this.m_dataSource.getData(columnIndex, rowIndex);
    }

    public void enableSorting(boolean canSort) {
        this.m_sortable = canSort;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.getTable().setEnabled(enable);
        this.getGrid().setEnabled(enable);
    }

    private ExpandingColumnResizer getExpandingResizer() {
        if (this.m_expandingResizer == null) {
            this.m_expandingResizer = new ExpandingColumnResizer(this.getTable());
            this.getGrid().addComponentListener(this.m_expandingResizer);
        }
        return this.m_expandingResizer;
    }

    public void addExpandingColumn(int column) {
        this.getExpandingResizer().addExpander(column);
    }

    public void addExpandingColumn(int column, int min, int weight) {
        this.getExpandingResizer().addExpander(column, min, weight);
    }

    public void addExpandingColumns(int[] column) {
        this.getExpandingResizer().addExpanders(column);
    }

    public void addExpandingColumns(int[] column, int[] min, int[] weight) {
        this.getExpandingResizer().addExpanders(column, min, weight);
    }

    public void removeExpandingColumn(int column) {
        this.getExpandingResizer().removeExpander(column);
    }

    public void columnDeselected(TableEvent e) {
    }

    public void columnDeselecting(TableEvent e) {
    }

    public void columnSelected(TableEvent e) {
        this.sortDataForColumn(e.getColumn());
    }

    public void columnSelecting(TableEvent e) {
    }

    public void rowDeselected(TableEvent e) {
    }

    public void rowDeselecting(TableEvent e) {
    }

    public void rowSelected(TableEvent e) {
    }

    public void rowSelecting(TableEvent e) {
    }

    public void rowDeselected(GridEvent e) {
    }

    public void rowDeselecting(GridEvent e) {
    }

    public void rowSelected(GridEvent e) {
    }

    public void rowSelecting(GridEvent e) {
    }

    public void itemResizing(HeaderEvent e) {
        this._resizing = true;
    }

    public void itemResized(HeaderEvent e) {
        this._resizing = false;
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        if (!(e.isShiftDown() || e.isControlDown() || this._resizing)) {
            HeaderSelection sm = header.getHeaderSelection();
            if (!sm.isItemSelected(itemIndex)) {
                sm.deselectAll();
                sm.setItemSelected(itemIndex, true);
            } else {
                this.sortDataForColumn(itemIndex);
            }
        }
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
    }

    public void doExtract(BufferedFrame parent) {
        this.m_table.doExtract(parent);
    }

    public void doExtract(BufferedFrame parent, AppletContext appletContext) {
        this.m_table.doExtract(parent, appletContext);
    }
}

