/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import oracle.ewt.button.PushButton;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.emSDK.client.guiComponent.alert.ExceptionAlertActionListener;
import oracle.sysman.emSDK.client.guiComponent.alert.TextAreaAlert;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class ExceptionAlert
extends AppAlert {
    private Exception m_exception;
    private static boolean m_showDetails;
    private static MessageBundle m_msgFile;

    private static String getReason(Exception e) {
        String reason = null;
        try {
            Field f = e.getClass().getDeclaredField("reason");
            Object o = f.get(e);
            if (o instanceof String) {
                reason = (String)o;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return reason;
    }

    private static String getExceptionString(Exception e, boolean fullName) {
        int index;
        String name = e.getClass().getName();
        if (!fullName && (index = name.lastIndexOf(46)) >= 0) {
            name = name.substring(index + 1);
        }
        return m_msgFile.getMessage("2041", false, new Object[]{name});
    }

    public static String getSafeExceptionMessage(Exception e) {
        return ExceptionAlert.getSafeExceptionMessage(e, false);
    }

    public static String getSafeExceptionMessage(Exception e, boolean forceExceptionName) {
        if (e == null) {
            return "";
        }
        String exMessage = e.getMessage();
        if (exMessage == null || exMessage.length() == 0) {
            exMessage = ExceptionAlert.getReason(e);
        }
        if (exMessage == null) {
            exMessage = "";
        }
        if (exMessage.length() == 0 || forceExceptionName) {
            if (exMessage.length() > 0) {
                exMessage = "\n" + exMessage;
            }
            exMessage = String.valueOf(ExceptionAlert.getExceptionString(e, true)) + exMessage;
        }
        return exMessage;
    }

    public static String getAlertMessage(Exception e, boolean forceExceptionName) {
        return ExceptionAlert.getSafeExceptionMessage(e, forceExceptionName);
    }

    private static int getAlertType(Exception e) {
        return 0;
    }

    public ExceptionAlert(Dialog parent, Exception e) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e), ExceptionAlert.getAlertType(e), 1);
        this.init(e);
    }

    public ExceptionAlert(Frame parent, Exception e) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e), ExceptionAlert.getAlertType(e), 1);
        this.init(e);
    }

    public ExceptionAlert(Frame parent, Exception e, int alertType, int buttons) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e), alertType, buttons);
        this.init(e);
    }

    public ExceptionAlert(Dialog parent, Exception e, int alertType, int buttons) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e), alertType, buttons);
        this.init(e);
    }

    public ExceptionAlert(Frame parent, Exception e, boolean forceExceptionName) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e, forceExceptionName), ExceptionAlert.getAlertType(e), 1);
        this.init(e);
    }

    public ExceptionAlert(Frame parent, Exception e, boolean forceExceptionName, int alertType, int buttons) {
        super(parent, ExceptionAlert.getSafeExceptionMessage(e, forceExceptionName), alertType, buttons);
        this.init(e);
    }

    public ExceptionAlert(Frame parent, Exception e, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.init(e);
    }

    public ExceptionAlert(Dialog parent, Exception e, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.init(e);
    }

    private void init(Exception e) {
        this.m_exception = e;
        if (m_showDetails && e != null) {
            this.addDetailsButton();
        }
    }

    public static void showExceptionDetailsButton(boolean show) {
        m_showDetails = show;
    }

    private void addDetailsButton() {
        String strDetailsButtonText = m_msgFile.getMessage("2043", false);
        PushButton button = new PushButton(strDetailsButtonText);
        button.addActionListener((ActionListener)new ExceptionAlertActionListener(this));
        this.addUserButton((Component)button);
    }

    void showDetails() {
        String message = this.m_exception.getMessage();
        String occurred = ExceptionAlert.getExceptionString(this.m_exception, true);
        String reason = ExceptionAlert.getReason(this.m_exception);
        String trace = this.getStackTrace(this.m_exception);
        if (message == null) {
            message = "";
        }
        if (reason == null) {
            reason = "";
        }
        String strExceptionDetailFormat = m_msgFile.getMessage("2042", false);
        String result = MessageFormat.format(strExceptionDetailFormat, occurred, message, reason);
        TextAreaAlert alert = new TextAreaAlert((Dialog)((Object)this), result, 2, 1);
        alert.setText(trace);
        alert.runAlert();
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    static {
        m_msgFile = MessageBundle.getMessageBundle("EmSDK");
    }
}

