/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.alert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import oracle.ewt.EwtComponent;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.vxx.VxxStringWriter;

public class TextAreaAlert
extends AppAlert {
    private LWTextArea m_textArea;

    public TextAreaAlert(Dialog parent, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.addTextArea();
    }

    public TextAreaAlert(Frame parent, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.addTextArea();
    }

    public TextAreaAlert(Frame parent, int alertType, int buttons) {
        super(parent, alertType, buttons);
        this.addTextArea();
    }

    private void addTextArea() {
        this.m_textArea = new LWTextArea("", 10, 50);
        this.m_textArea.setEditable(false);
        EwtComponent textPanel = new EwtComponent();
        textPanel.setLayout(new BorderLayout());
        ScrollBox scrollBox = new ScrollBox((Component)this.m_textArea, 0, 0);
        textPanel.add((Component)scrollBox, "Center");
        this.setExtraComponent((Component)textPanel);
    }

    public void setText(String text) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            this.setText(reader);
        }
        catch (IOException iOException) {}
    }

    public void setText(BufferedReader reader) throws IOException {
        String line;
        VxxStringWriter writer = new VxxStringWriter(true);
        PrintWriter printer = new PrintWriter(writer);
        while ((line = reader.readLine()) != null) {
            printer.println(line);
        }
        this.m_textArea.setText(writer.toString());
    }

    public void setTextFromFile(String fileName) throws FileNotFoundException, IOException {
        this.setText(new BufferedReader(new FileReader(fileName)));
    }

    public LWTextArea getTextArea() {
        return this.m_textArea;
    }
}

