/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.popupMenu;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MnemonicUtils;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuCommandItem;

public class PopupCommandMenu
extends PopupMenu
implements ActionListener {
    private final ListenerManager m_listenerManager = new ListenerManager();

    public final void addCommandListener(CommandListener listener) {
        this.m_listenerManager.addListener((EventListener)listener);
    }

    public final void removeCommandListener(CommandListener listener) {
        this.m_listenerManager.removeListener((EventListener)listener);
    }

    public final MenuItem add(MenuItem item) {
        if (item instanceof PopupMenuCommandItem) {
            item.addActionListener(this);
        }
        PopupCommandMenu.removeItemAnnotations(item);
        return super.add(item);
    }

    public int getItemCount() {
        return super.getItemCount();
    }

    public Object getItemAt(int index) {
        return super.getItem(index);
    }

    public void actionPerformed(ActionEvent e) {
        Enumeration enumeration = this.m_listenerManager.getListeners();
        while (enumeration != null && enumeration.hasMoreElements()) {
            ((CommandListener)enumeration.nextElement()).commandIssued(new CommandEvent(e));
        }
    }

    private static final void removeItemAnnotations(MenuItem item) {
        if (item instanceof Menu) {
            PopupCommandMenu.removeMenuAnnotations((Menu)item);
        } else {
            PopupCommandMenu.removeLeafItemAnnotation(item);
        }
    }

    private static final void removeMenuAnnotations(Menu menu) {
        PopupCommandMenu.removeLeafItemAnnotation(menu);
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            PopupCommandMenu.removeItemAnnotations(item);
            ++i;
        }
    }

    private static final void removeLeafItemAnnotation(MenuItem item) {
        String label = item.getLabel();
        if (label != null) {
            label = MnemonicUtils.getUnannotatedLabel(label);
            item.setLabel(label);
        }
    }
}

