/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.splashScreen;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.lwAWT.BufferedWindow;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterTiler;
import oracle.ewt.timer.Timer;
import oracle.sysman.emSDK.client.guiComponent.splashScreen.SplashScreenAdapter;

public class SplashScreen
extends BufferedWindow {
    SplashScreenAdapter m_adapter;
    Timer m_timer;

    public SplashScreen(Frame frame) {
        super(frame);
        this.construct();
    }

    public SplashScreen(Frame frame, Class baseClass, Image image) {
        this(frame, baseClass, image, -1);
    }

    public SplashScreen(Frame frame, Class baseClass, String strRelativeImageUrl) {
        this(frame, baseClass, strRelativeImageUrl, -1);
    }

    public SplashScreen(Frame frame, Class baseClass, Image image, int nTimeout) {
        super(frame);
        this.construct();
        this.setImage(image);
        this.setTimer(nTimeout);
    }

    public SplashScreen(Frame frame, Class baseClass, String strRelativeImageUrl, int nTimeout) {
        super(frame);
        this.construct();
        this.setImage(baseClass, strRelativeImageUrl);
        this.setTimer(nTimeout);
    }

    public SplashScreen(Frame frame, URL urlImage) {
        this(frame, urlImage, -1);
    }

    public SplashScreen(Frame frame, URL urlImage, int nTimeout) {
        super(frame);
        this.construct();
        this.setImage(urlImage);
        this.setTimer(nTimeout);
    }

    public SplashScreen(Frame frame, Image image) {
        this(frame, image, -1);
    }

    public SplashScreen(Frame frame, Image image, int nTimeout) {
        super(frame);
        this.construct();
        this.setImage(image);
        this.setTimer(nTimeout);
    }

    public void setImage(Class baseClass, String strRelativeImageUrl) {
        this.setImage(this.getImage(baseClass, strRelativeImageUrl));
    }

    public void setImage(URL urlImage) {
        this.setImage(this.getImage(urlImage));
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setFill((Painter)new PainterTiler((Painter)new ImageSetPainter((ImageSet)new SynthesizingImageSet(image))));
            this.m_adapter.setSize(image);
        }
    }

    private Image getImage(Class baseClass, String strRelativeImageUrl) {
        Image image = null;
        if (strRelativeImageUrl != null) {
            image = ImageUtils.getImageResource((Class)baseClass, (String)strRelativeImageUrl);
        }
        return image;
    }

    private Image getImage(URL url) {
        Image image = null;
        if (url != null) {
            image = Toolkit.getDefaultToolkit().getImage(url);
        }
        return image;
    }

    public void setTimer(int nTimeoutSeconds) {
        if (this.m_timer != null) {
            if (nTimeoutSeconds < 0) {
                this.m_timer.cancel();
            } else {
                this.m_timer.schedule((long)(1000 * nTimeoutSeconds));
            }
        }
    }

    public boolean isClosed() {
        return this.m_timer == null;
    }

    private void construct() {
        this.m_adapter = new SplashScreenAdapter(this);
        this.m_timer = new Timer((Runnable)this.m_adapter);
        this.m_timer.setDaemon(true);
        ((Window)((Object)this)).addWindowListener(this.m_adapter);
        ((Component)((Object)this)).enableEvents(24L);
        ((Window)((Object)this)).show();
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        switch (e.getID()) {
            case 500: {
                if (!((Component)((Object)this)).contains(e.getX(), e.getY())) break;
                this.dispose();
                break;
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        switch (e.getID()) {
            case 400: {
                this.dispose();
                break;
            }
        }
    }

    public void dispose() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer.kill();
            this.m_timer = null;
        }
        super.dispose();
    }
}

