/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.splashScreen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.BufferedWindow;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterJoiner;
import oracle.ewt.painter.SeparatorBorderPainter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarItem;
import oracle.ewt.statusBar.StatusBarTextItem;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.emSDK.client.guiComponent.splashScreen.EMSplashRenderer;
import oracle.sysman.emSDK.common.nls.ImageBundle;
import oracle.sysman.emSDK.common.nls.MessageBundle;

class SplashScreenWindow
extends BufferedWindow {
    ImageBundle m_imgBundle;
    Image m_splashImage;
    Image m_bannerImage;
    Image m_productImage;
    String m_productName;
    String m_initialStatusText;
    private boolean m_initialized = false;
    private LWLabel m_labelAction;
    private StatusBar m_statusBar;
    private StatusBarTextItem m_statusBarItem;
    private LWLabel m_copyright;

    SplashScreenWindow(Image splashImage, Image bannerImage, Image productImage, String productName, String initialStatusText) {
        super(new Frame());
        this.m_splashImage = splashImage;
        this.m_bannerImage = bannerImage;
        this.m_productImage = productImage;
        this.m_productName = productName;
        this.m_initialStatusText = initialStatusText;
    }

    void init() {
        this.m_imgBundle = new ImageBundle("Vta");
        this.initControls(this.m_splashImage, this.m_bannerImage, this.m_productImage, this.m_productName, this.m_initialStatusText);
        ((Window)((Object)this)).pack();
        WindowUtils.centerWindow((Window)((Object)this));
        ((Component)((Object)this)).enableEvents(24L);
        SplashScreenWindow splashScreenWindow = this;
        synchronized (splashScreenWindow) {
            this.m_initialized = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    void destroy() {
        this.m_imgBundle = null;
        this.m_splashImage = null;
        this.m_bannerImage = null;
        this.m_productImage = null;
        this.m_productName = null;
        this.m_initialStatusText = null;
    }

    private void initControls(Image splashImage, Image bannerImage, Image productImage, String productName, String initialStatusText) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        EwtComponent centerPanel = new EwtComponent();
        centerPanel.setBorderPainter(UIManager.createGroupBoxPainter((String)""));
        centerPanel.setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)centerPanel);
        if (productName != null) {
            centerPanel.add("North", (Component)this.createBannerPanel(bannerImage, productImage, productName));
        }
        centerPanel.add("South", (Component)this.createStatusPanel(initialStatusText));
        centerPanel.add("Center", (Component)this.createImagePanel(splashImage));
    }

    private EwtComponent createBannerPanel(Image bannerImage, Image productImage, String productName) {
        if (bannerImage == null) {
            bannerImage = this.m_imgBundle.getImage("5000");
        }
        EwtComponent bannerPanel = new EwtComponent();
        bannerPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 2, 6, 6));
        bannerPanel.setLayout(new BorderLayout());
        bannerPanel.setBackground(Color.black);
        bannerPanel.setForeground(Color.black);
        Image image = this.m_imgBundle.getImage("5001");
        EwtComponent productImgPanel = new EwtComponent();
        productImgPanel.setFill((Painter)new PainterJoiner((Painter)new FixedBorderPainter(0, 0, 0, 0), (Painter)new FixedImagePainter(image, 1), 4));
        ImageCanvas productImgCanvas = new ImageCanvas(productImage);
        productImgPanel.setLayout(new BorderLayout());
        productImgPanel.add("Center", (Component)productImgCanvas);
        EwtComponent productNamePanel = new EwtComponent();
        productNamePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(6, 6, 6, 0));
        productNamePanel.setLayout(new GridLayout(2, 1));
        EwtComponent productPanel = new EwtComponent();
        productPanel.setBorderPainter((BorderPainter)new SeparatorBorderPainter(2, true, 0));
        productPanel.setLayout(new BorderLayout());
        LWLabel product = new LWLabel(productName, 1);
        product.setForeground(Color.white);
        product.setFont(new Font("Helvetica", 0, 18));
        productPanel.add("Center", (Component)product);
        EwtComponent bannerImgPanel = new EwtComponent();
        bannerImgPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 0, 0));
        bannerImgPanel.setBackground(Color.black);
        ImageCanvas imageCanvas = new ImageCanvas(bannerImage);
        bannerImgPanel.setLayout(new BorderLayout());
        bannerImgPanel.add("Center", (Component)imageCanvas);
        productNamePanel.add((Component)bannerImgPanel);
        productNamePanel.add((Component)productPanel);
        bannerPanel.add("East", (Component)productImgPanel);
        bannerPanel.add("Center", (Component)productNamePanel);
        return bannerPanel;
    }

    private EwtComponent createImagePanel(Image img) {
        if (img == null) {
            img = this.m_imgBundle.getImage("5002");
        }
        EwtComponent imagePanel = new EwtComponent();
        imagePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 0, 0));
        imagePanel.setBackground(Color.black);
        ImageCanvas imageCanvas = new ImageCanvas(img);
        imageCanvas.setScalingMode(1);
        imagePanel.setLayout((LayoutManager)new EqualColumnLayout());
        imagePanel.add((Component)imageCanvas);
        return imagePanel;
    }

    private EwtComponent createStatusPanel(String initialStatusText) {
        EwtComponent statusPanel = new EwtComponent();
        statusPanel.setBorderPainter((BorderPainter)new SeparatorBorderPainter((Painter)new FixedBorderPainter(4, 8, 0, 8), 1, true, 0));
        statusPanel.setLayout(new GridLayout(2, 1, 0, 0));
        statusPanel.setBackground(UIManager.getColor((Object)LookAndFeel.DARK_LOOK));
        statusPanel.setForeground(UIManager.getColor((Object)LookAndFeel.LIGHT_LOOK));
        this.m_statusBar = new StatusBar();
        this.m_statusBarItem = new StatusBarTextItem(initialStatusText);
        this.m_statusBar.addItem((StatusBarItem)this.m_statusBarItem);
        this.m_statusBar.setFont(new Font("Helvetica", 0, 11));
        this.m_labelAction = new LWLabel(initialStatusText, 3);
        this.m_labelAction.setForeground(Color.white);
        this.m_labelAction.setFont(new Font("Helvetica", 0, 12));
        MessageBundle vtaMsgBundle = MessageBundle.getMessageBundle("Vta");
        String copyright = vtaMsgBundle.getMessage("3032", false);
        if (copyright == null) {
            copyright = new String("Copyright 1998 Oracle Corporation. All rights reserved.");
        }
        this.m_copyright = new LWLabel(copyright, 3);
        this.m_copyright.setForeground(Color.lightGray);
        this.m_copyright.setFont(new Font("Helvetica", 0, 9));
        statusPanel.add((Component)this.m_statusBar);
        statusPanel.add((Component)this.m_copyright);
        return statusPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setActionText(String action) {
        SplashScreenWindow splashScreenWindow = this;
        synchronized (splashScreenWindow) {
            while (!this.m_initialized) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        this.m_statusBarItem.setText(action);
        this.requestFocus();
        this.m_statusBar.setEnabled(true);
    }

    public void requestFocus() {
        this.m_statusBar.requestFocus();
    }

    public final void toFront() {
        this.requestFocus();
        Graphics m_graphics = EMSplashRenderer.getScreenGraphics();
        if (m_graphics != null) {
            super.paintAll(m_graphics);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this.toFront();
        switch (e.getID()) {
            case 500: {
                if (!((Component)((Object)this)).contains(e.getX(), e.getY())) break;
                this.toFront();
                break;
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        switch (e.getID()) {
            case 400: {
                this.toFront();
                break;
            }
        }
    }
}

