/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.help.QuickTourWindow;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.emSDK.client.guiComponent.util.QTDisposeListenerCL;
import oracle.sysman.emSDK.client.guiComponent.util.QTExitListenerCL;
import oracle.sysman.emSDK.client.guiComponent.util.QTExitListenerWL;
import oracle.sysman.emSDK.client.guiComponent.util.WindowClosingAdapter;
import oracle.sysman.emSDK.common.nls.ImageBundle;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxx.VxxResourceUtil;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class BrowserLauncher {
    private static final String REDIRECT_FILE_TEXT_FMT4 = "<HTML>\n<HEAD>\n<META http-equiv=\"refresh\" content=\"{3}; url={0}\">\n</HEAD>\n<BODY>\n<h1>{1}</h1>\n<p>\n{2}\n</BODY>\n</HTML>\n";
    private static final String REDIRECT_FILE_ADDRESS_FMT = "<a href=\"{0}\">{0}</a>";
    private static final String FILE_PROTOCOL = "file";
    private static final String DOCUMENT_NAME = "_blank";
    private static final String NETSCAPE_EXE_NAME = "netscape";
    private static final String BROWSER_PROPERTY = "user.browser";
    private static final String NT_BROWSER_EXE_LAUNCH = "cmd /c start rundll32 url.dll,FileProtocolHandler";
    private static final String TEMP_FILE_EXT = "htm";
    private static final String TEMP_FILE_DIR_PROPERTY = "user.dir";
    private static final String TEMP_FILE_PREFIX = "Tmp";
    private static boolean m_s_exitQuickTourOnClose;

    private BrowserLauncher() {
    }

    private static void alert(Frame frame, boolean isQuickTourOnly, String location) {
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Vta");
        String msgID = isQuickTourOnly ? "1002" : "1000";
        String message = msgBundle.getMessage(msgID, true);
        int buttons = 1;
        if (frame != null) {
            buttons |= 8;
        } else {
            frame = new BufferedFrame();
        }
        AppAlert alert = new AppAlert(frame, message, 2, buttons);
        String helpID = isQuickTourOnly ? "BrowserLauncher_quicktourError" : "BrowserLauncher_browserError";
        alert.setHelpBook("vtc");
        alert.setHelpTopic(helpID);
        LWTextField text = new LWTextField(location, 50);
        text.setEditable(false);
        alert.setExtraComponent((Component)text);
        alert.runAlert();
    }

    public static boolean showFileInBrowser(Frame frame, Object context, String localFileName) {
        if (BrowserLauncher.showFileInBrowserOnly(context, localFileName)) {
            return true;
        }
        URL fileURL = BrowserLauncher.safeGetFileURL(localFileName);
        if (BrowserLauncher.showInQuickTour(frame, null, fileURL, false, localFileName) != null) {
            return true;
        }
        BrowserLauncher.alert(frame, false, localFileName);
        return false;
    }

    private static boolean showFileInBrowserOnly(Object context, String localFileName) {
        if (localFileName == null) {
            return false;
        }
        URL fileURL = BrowserLauncher.safeGetFileURL(localFileName);
        if (BrowserLauncher.showInBrowser(BrowserLauncher.safeGetAppletContext(context), fileURL)) {
            return true;
        }
        if (BrowserLauncher.execToBrowser(localFileName)) {
            return true;
        }
        if (BrowserLauncher.execToDefaultBrowser(localFileName)) {
            return true;
        }
        return BrowserLauncher.execToNetscape(localFileName);
    }

    public static boolean showURLInBrowser(Frame frame, Object context, String strURL) {
        URL url = BrowserLauncher.safeGetURL(strURL);
        if (BrowserLauncher.showInBrowser(BrowserLauncher.safeGetAppletContext(context), url)) {
            return true;
        }
        String localFileName = BrowserLauncher.saveRedirectFile(strURL);
        if (BrowserLauncher.showFileInBrowserOnly(context, localFileName)) {
            return true;
        }
        if (BrowserLauncher.showInQuickTour(frame, null, url, false, strURL) != null) {
            return true;
        }
        BrowserLauncher.alert(frame, false, strURL);
        return false;
    }

    private static AppletContext safeGetAppletContext(Object context) {
        if (context instanceof AppletContext) {
            return (AppletContext)context;
        }
        try {
            Applet applet = null;
            if (context instanceof Applet) {
                applet = (Applet)context;
            }
            if (applet != null) {
                return applet.getAppletContext();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    private static URL safeGetFileURL(String filename) {
        try {
            if (filename != null) {
                URL url = new URL(FILE_PROTOCOL, "/", filename);
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private static URL safeGetURL(String strURL) {
        try {
            if (strURL != null) {
                URL url = new URL(strURL);
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private static boolean showInBrowser(AppletContext context, URL url) {
        if (context != null && url != null) {
            context.showDocument(url, DOCUMENT_NAME);
            return true;
        }
        return false;
    }

    private static boolean execToNetscape(String localFileName) {
        return BrowserLauncher.exec("netscape " + localFileName);
    }

    private static boolean execToBrowser(String localFileName) {
        String browser = System.getProperty(BROWSER_PROPERTY);
        if (browser == null || browser.length() == 0) {
            return false;
        }
        return BrowserLauncher.exec(String.valueOf(browser) + " " + localFileName);
    }

    private static boolean execToDefaultBrowser(String localFileName) {
        return BrowserLauncher.exec("cmd /c start rundll32 url.dll,FileProtocolHandler " + localFileName);
    }

    private static boolean exec(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            int status = process.waitFor();
            return status == 0;
        }
        catch (SecurityException e) {
            VxxtTRACE.out(e);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException e) {
            VxxtTRACE.out(e);
        }
        return false;
    }

    public static boolean showInQuickTour(Frame frame, String strURL) {
        QuickTourWindow qtw = BrowserLauncher.showInQuickTour(frame, null, new BrowserLauncher().getClass(), strURL, false);
        return qtw != null;
    }

    public static QuickTourWindow showInQuickTour(Frame frame, QuickTourWindow prevQTW, Object cls, String strURL) {
        return BrowserLauncher.showInQuickTour(frame, prevQTW, cls, strURL, true);
    }

    private static QuickTourWindow showInQuickTour(Frame frame, QuickTourWindow prevQTW, Object cls, String strURL, boolean reuse) {
        URL url = BrowserLauncher.getQuickTourURL(cls, strURL);
        MessageBundle msgBundle = MessageBundle.getMessageBundle("EmSDK");
        String title = msgBundle.getMessage("3035", false);
        QuickTourWindow qtw = BrowserLauncher.showInQuickTour(frame, prevQTW, url, reuse, title);
        qtw.setSize(810, 560);
        if (url != null) {
            strURL = url.toString();
        }
        if (qtw == null) {
            BrowserLauncher.alert(frame, true, strURL);
        }
        return qtw;
    }

    private static URL getQuickTourURL(Object cls, String strURL) {
        Class cl = BrowserLauncher.getClass(cls);
        if (cl == null) {
            return null;
        }
        URL url = VxxResourceUtil.getLocalizedResource(cl, strURL);
        return url;
    }

    private static Class getClass(Object cls) {
        if (cls instanceof Class) {
            return (Class)cls;
        }
        try {
            if (cls instanceof String) {
                return Class.forName((String)cls);
            }
        }
        catch (ClassNotFoundException e) {
            VxxtTRACE.out(e);
        }
        return null;
    }

    private static QuickTourWindow showInQuickTour(Frame frame, QuickTourWindow prevQTW, URL url, boolean reuse, String title) {
        if (url == null) {
            return null;
        }
        QuickTourWindow qtw = prevQTW;
        if (qtw == null) {
            qtw = new QuickTourWindow();
        }
        qtw.setFrontpage(url);
        qtw.setTitle(title);
        Image image = null;
        if (frame != null) {
            image = frame.getIconImage();
        }
        if (image == null) {
            ImageBundle imgBundle = new ImageBundle("Vtc");
            image = imgBundle.getImage("0001");
        }
        qtw.setIconImage(image);
        if (!reuse) {
            if (m_s_exitQuickTourOnClose) {
                qtw.addComponentListener(new QTExitListenerCL());
                qtw.addWindowListener(new QTExitListenerWL());
            } else {
                qtw.addComponentListener(new QTDisposeListenerCL());
                qtw.addWindowListener(WindowClosingAdapter.getWindowClosingAdapter());
            }
        }
        qtw.show();
        return qtw;
    }

    private static String getFileText(URL url, int nWaitSeconds) {
        return BrowserLauncher.getFileText(url.toString(), nWaitSeconds);
    }

    static String getFileText(String strURL, int nWaitSeconds) {
        String strAddr = MessageFormat.format(REDIRECT_FILE_ADDRESS_FMT, strURL);
        String strLink = MessageFormat.format("Link to {0}", strAddr);
        String strGoto = MessageFormat.format("Goto {0} for the desired page.", strAddr);
        Object[] argList = new Object[]{strURL, strLink, strGoto, new Integer(nWaitSeconds).toString()};
        String strFile = MessageFormat.format(REDIRECT_FILE_TEXT_FMT4, argList);
        return strFile;
    }

    private static boolean saveFile(String fileName, String fileText) {
        return BrowserLauncher.saveFile(new File(fileName), fileText);
    }

    private static boolean saveFile(File file, String fileText) {
        boolean isSaved = false;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(fileText);
                isSaved = true;
            }
            catch (IOException iOException) {
                isSaved = false;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                isSaved = false;
            }
            throw throwable;
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            isSaved = false;
        }
        return isSaved;
    }

    private static boolean saveRedirectFile(String fileName, String strURL) {
        return BrowserLauncher.saveFile(fileName, BrowserLauncher.getFileText(strURL, 0));
    }

    private static String saveRedirectFile(String strURL) {
        String fileName = BrowserLauncher.getTempFile(TEMP_FILE_EXT).getPath();
        if (BrowserLauncher.saveFile(fileName, BrowserLauncher.getFileText(strURL, 0))) {
            return fileName;
        }
        return null;
    }

    private static File getFile(String dirName, String baseName) {
        if (dirName != null) {
            return new File(dirName, baseName);
        }
        return new File(baseName);
    }

    private static File getFile(String baseName) {
        String dir = System.getProperty(TEMP_FILE_DIR_PROPERTY);
        return BrowserLauncher.getFile(dir, baseName);
    }

    private static File getTempFile(String strExt) {
        return BrowserLauncher.getFile("emRedir." + strExt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void main(String[] argv) {
        VxxtTRACE.enableDebugTracing();
        VxxtTRACE.configure(false, true, false, false, "", false);
        m_s_exitQuickTourOnClose = true;
        boolean isQuickTour = false;
        String strResource = null;
        int i = 0;
        while (i < argv.length) {
            block6: {
                String arg = argv[i];
                if (arg.charAt(0) == '-') {
                    if (arg.equalsIgnoreCase("-q")) {
                        isQuickTour = true;
                        break block6;
                    } else {
                        strResource = null;
                        VxxtTRACE.out("Unrecognized parameter: " + arg);
                        break;
                    }
                }
                strResource = arg;
            }
            ++i;
        }
        if (strResource == null) {
            VxxtTRACE.out("usage: [-q] location");
            VxxtTRACE.out("   eg: Q:\\oracle\\sysman\\vtf\\html\\instmgr.htm");
            VxxtTRACE.out("   eg: -q /oracle/sysman/help/vtc/qt{0}/em.htm");
            VxxtTRACE.out("       -q forces it to run as a Quick Tour");
            System.exit(1);
        }
        if (isQuickTour) {
            BrowserLauncher.showInQuickTour(null, strResource);
            return;
        }
        BrowserLauncher.showFileInBrowser(null, null, strResource);
    }
}

